/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.gdlink;

import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.debug.AbstractDebugServer;
import com.gigadevice.debug.ui.DebugTab;
import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.utils.constants.DebugConstants;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class OpenocdDebug
extends AbstractDebugServer {
    private Composite fSettingsComp;
    private Text fGdbServerOtherOptions;
    final boolean debug = false;
    private ILaunchConfiguration config;

    public String getDefaultPortNumber() {
        return "5099";
    }

    public void createControl(Composite parent, DebugTab dt) {
        super.createControl(parent, dt);
        this.fSettingsComp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.fSettingsComp);
        GridDataFactory.swtDefaults().grab(true, false).applyTo((Control)this.fSettingsComp);
        Label label = new Label(this.fSettingsComp, 0);
        label.setText("Config Options");
        GridDataFactory.swtDefaults().applyTo((Control)label);
        this.fGdbServerOtherOptions = new Text(this.fSettingsComp, 2626);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)this.fGdbServerOtherOptions);
        this.fGdbServerOtherOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OpenocdDebug.this.updateLaunchDialog();
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration, TargetAdapter.MbsType clientTool, String GdbServer, String ServerArgs) {
        this.config = configuration;
        String str = "";
        try {
            str = configuration.getAttribute("com.gigadevice.debug.launch.serverParam", ServerArgs);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        if (GdbServer.equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString())) {
            try {
                this.setDefaultOpenocdFilePath((ILaunchConfigurationWorkingCopy)configuration);
                String OpenocdFilePath = configuration.getAttribute("com.gigadevice.debug.launch.OpenocdFilePath", "");
                this.fGdbServerOtherOptions.setText("-f " + OpenocdFilePath);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (GdbServer.equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
            if (str.toLowerCase().contains(" -port")) {
                str = str.substring(0, str.indexOf(" -port"));
            }
            this.fGdbServerOtherOptions.setText(str);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration, TargetAdapter.MbsType clientTool) {
        try {
            String GDLinkDebuggerServer = configuration.getAttribute("com.gigadevice.debug.gdlink.server", "");
            if (GDLinkDebuggerServer.contains(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString())) {
                String stringValue = this.fGdbServerOtherOptions.getText();
                this.setOpenocdFilePath(configuration, stringValue, false);
                configuration.setAttribute("com.gigadevice.debug.launch.serverParam", stringValue);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.UpdateCommands(configuration, clientTool);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration, TargetAdapter.MbsType clientTool, String GdbServer, String ServerArgs) {
        this.UpdateCommands(configuration, clientTool);
        this.setDefaultOpenocdFilePath(configuration);
        try {
            configuration.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setDefaultOpenocdFilePath(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String DefaultOpenocdFileAbsolutePath;
            String OpenocdFilePath = configuration.getAttribute("com.gigadevice.debug.launch.OpenocdFilePath", "");
            File OpenocdFile = new File(OpenocdFilePath);
            if (!(OpenocdFilePath.contains(".cfg") && !OpenocdFilePath.equals("") && OpenocdFile.exists() || (DefaultOpenocdFileAbsolutePath = DebugUtil.getFirstFileAbsolutePath((ILaunchConfiguration)configuration, (String)"openocd", (boolean)true)) == null || DefaultOpenocdFileAbsolutePath == "")) {
                configuration.setAttribute("com.gigadevice.debug.launch.OpenocdFilePath", DefaultOpenocdFileAbsolutePath);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void UpdateGroup(ILaunchConfigurationWorkingCopy configuration, String GdbServer, String Interface, String McuNo) {
        String text = null;
        try {
            text = configuration.getAttribute("com.gigadevice.debug.launch.serverParam", this.fGdbServerOtherOptions.getText());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (GdbServer.contains(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
            if (text.toLowerCase().contains("-device ") && text.toLowerCase().contains("-speed ")) {
                if (!text.toLowerCase().contains(String.valueOf(McuNo.toLowerCase()) + " ")) {
                    text = text.replace(text.subSequence(text.indexOf("-device ") + 8, text.indexOf(" -speed")), McuNo);
                }
            } else {
                text = "-device " + McuNo + " -speed 2000 -if swd";
            }
            if (text.toLowerCase().contains("-port ")) {
                text = "-device " + McuNo + " -speed 2000 -if swd";
            }
            if (!text.toLowerCase().contains(Interface)) {
                if (text.toLowerCase().contains("jtag")) {
                    text = text.replace("jtag", Interface);
                } else if (text.toLowerCase().contains("swd")) {
                    text = text.replace("swd", Interface);
                }
            }
            this.fGdbServerOtherOptions.setText(text);
            configuration.setAttribute("com.gigadevice.debug.launch.serverParam", text);
        } else if (GdbServer.contains(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString())) {
            try {
                this.UpdateOpenocdArgs(configuration, text, true);
                String OpenocdFilePath = configuration.getAttribute("com.gigadevice.debug.launch.OpenocdFilePath", "");
                this.fGdbServerOtherOptions.setText("-f " + OpenocdFilePath);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public Composite getControl() {
        return this.fSettingsComp;
    }

    public int getSleepTime() {
        return 4;
    }

    public void setOpenocdFilePath(ILaunchConfigurationWorkingCopy configuration, String txt, boolean isOpenocdDebugPara) {
        try {
            String GDLinkDebuggerServer = configuration.getAttribute("com.gigadevice.debug.gdlink.server", DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
            Boolean isOpenocdDebug = GDLinkDebuggerServer.equals(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString());
            if (isOpenocdDebug.booleanValue() || isOpenocdDebugPara) {
                if (txt.contains("-f")) {
                    String openocdFilePathString = txt.replace("-f", "").trim();
                    if (openocdFilePathString.contains(".cfg")) {
                        configuration.setAttribute("com.gigadevice.debug.launch.OpenocdFilePath", openocdFilePathString);
                    } else {
                        this.setDefaultOpenocdFilePath(configuration);
                    }
                } else {
                    this.setDefaultOpenocdFilePath(configuration);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void UpdateCommands(ILaunchConfigurationWorkingCopy configuration, TargetAdapter.MbsType clientTool) {
        try {
            configuration.setAttribute("com.gigadevice.debug.launch.remoteCommand", "target remote");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void UpdateOpenocdArgs(ILaunchConfigurationWorkingCopy configuration, String str, boolean isOpenocdDebugPara) {
        try {
            String GDLinkDebuggerServer = configuration.getAttribute("com.gigadevice.debug.gdlink.server", DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
            boolean isOpenocdDebug = GDLinkDebuggerServer.equals(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString());
            if (isOpenocdDebug || isOpenocdDebugPara) {
                this.setOpenocdFilePath(configuration, str, isOpenocdDebugPara);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getServerLocation(TargetAdapter.MbsType type, String McuNo, String Server, String Location) {
        if (Server.contains(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString())) {
            return DebugUtil.getOpenocdEXELoc();
        }
        if (Server.contains(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
            if (Location.equalsIgnoreCase("") || !Location.contains("GDLinkGDBServer")) {
                return DebugUtil.getGDLinkGDBServerEXELoc();
            }
            return Location;
        }
        return "";
    }
}

