/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codepreview;

import com.gigadevice.codepreview.CodePreview;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class DiffScrollViewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int WIDTH = 16;
    private RSyntaxTextArea leftTextArea;
    private RSyntaxTextArea rightTextArea;
    private RTextScrollPane leftScrollPane;
    private RTextScrollPane rightScrollPane;
    private List<DiffInfo> diffInfoList = new ArrayList<DiffInfo>();

    public DiffScrollViewPanel(RSyntaxTextArea leftTextArea, RSyntaxTextArea rightTextArea, final RTextScrollPane leftScrollPane, final RTextScrollPane rightScrollPane) {
        this.leftTextArea = leftTextArea;
        this.rightTextArea = rightTextArea;
        this.leftScrollPane = leftScrollPane;
        this.rightScrollPane = rightScrollPane;
        this.setPreferredSize(new Dimension(16, Integer.MAX_VALUE));
        this.setBackground(Color.LIGHT_GRAY);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                DiffScrollViewPanel.this.scrollToPosition(e.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                DiffScrollViewPanel.this.scrollToPosition(e.getY());
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                JScrollBar leftBar = leftScrollPane.getVerticalScrollBar();
                JScrollBar rightBar = rightScrollPane.getVerticalScrollBar();
                int scrollAmount = e.getUnitsToScroll() * 15;
                leftBar.setValue(leftBar.getValue() + scrollAmount);
                rightBar.setValue(rightBar.getValue() + scrollAmount);
                DiffScrollViewPanel.this.repaint();
            }
        });
        leftScrollPane.getVerticalScrollBar().addAdjustmentListener(e -> this.repaint());
        rightScrollPane.getVerticalScrollBar().addAdjustmentListener(e -> this.repaint());
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DiffScrollViewPanel.this.repaint();
            }
        };
        leftTextArea.addComponentListener((ComponentListener)resizeListener);
        rightTextArea.addComponentListener((ComponentListener)resizeListener);
    }

    public void setDiffInfoList(List<DiffInfo> diffInfoList) {
        this.diffInfoList = new ArrayList<DiffInfo>(diffInfoList);
        this.repaint();
    }

    private void scrollToPosition(int y) {
        try {
            float ratio = (float)y / (float)this.getHeight();
            int leftTotalLines = this.leftTextArea.getLineCount();
            int rightTotalLines = this.rightTextArea.getLineCount();
            int totalLines = Math.max(leftTotalLines, rightTotalLines);
            int targetLine = Math.round(ratio * (float)totalLines);
            if (leftTotalLines > 0) {
                int leftTargetLine = Math.min(targetLine, leftTotalLines - 1);
                int leftOffset = this.leftTextArea.getLineStartOffset(Math.max(0, leftTargetLine));
                this.leftTextArea.setCaretPosition(leftOffset);
            }
            if (rightTotalLines > 0) {
                int rightTargetLine = Math.min(targetLine, rightTotalLines - 1);
                int rightOffset = this.rightTextArea.getLineStartOffset(Math.max(0, rightTargetLine));
                this.rightTextArea.setCaretPosition(rightOffset);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        int width = this.getWidth();
        int height = this.getHeight();
        g2d.setColor(new Color(240, 240, 240));
        g2d.fillRect(0, 0, width, height);
        try {
            int leftTotalLines = this.leftTextArea.getLineCount();
            int rightTotalLines = this.rightTextArea.getLineCount();
            int totalLines = Math.max(leftTotalLines, rightTotalLines);
            if (totalLines <= 0) {
                return;
            }
            for (DiffInfo info : this.diffInfoList) {
                int totalLinesForThisSide;
                int startLine = Math.max(0, info.startLine);
                int endLine = Math.max(startLine + 1, info.endLine);
                int n = totalLinesForThisSide = info.isLeftSide ? leftTotalLines : rightTotalLines;
                if (totalLinesForThisSide <= 0) continue;
                int startY = (int)((float)(startLine * height) / (float)totalLinesForThisSide);
                int endY = (int)((float)(endLine * height) / (float)totalLinesForThisSide);
                int markHeight = Math.max(2, endY - startY);
                switch (info.type) {
                    case ADDED: {
                        g2d.setColor(CodePreview.DIFFCOLOR_ADDED);
                        break;
                    }
                    case DELETED: {
                        g2d.setColor(CodePreview.DIFFCOLOR_DELETED);
                        break;
                    }
                    case MODIFIED: {
                        g2d.setColor(CodePreview.DIFFCOLOR_MODIFIED);
                    }
                }
                g2d.fillRect(0, startY, width, markHeight);
            }
            try {
                Rectangle leftVisibleRect = this.leftScrollPane.getViewport().getViewRect();
                Rectangle rightVisibleRect = this.rightScrollPane.getViewport().getViewRect();
                int leftFirstVisibleLine = this.leftTextArea.getLineOfOffset(this.leftTextArea.viewToModel(new Point(0, leftVisibleRect.y)));
                int leftLastVisibleLine = this.leftTextArea.getLineOfOffset(this.leftTextArea.viewToModel(new Point(0, leftVisibleRect.y + leftVisibleRect.height)));
                int rightFirstVisibleLine = this.rightTextArea.getLineOfOffset(this.rightTextArea.viewToModel(new Point(0, rightVisibleRect.y)));
                int rightLastVisibleLine = this.rightTextArea.getLineOfOffset(this.rightTextArea.viewToModel(new Point(0, rightVisibleRect.y + rightVisibleRect.height)));
                int firstVisibleLine = Math.min(leftFirstVisibleLine, rightFirstVisibleLine);
                int lastVisibleLine = Math.max(leftLastVisibleLine, rightLastVisibleLine);
                int viewStartY = (int)((float)(firstVisibleLine * height) / (float)totalLines);
                int viewEndY = (int)((float)(lastVisibleLine * height) / (float)totalLines);
                int viewHeight = Math.max(5, viewEndY - viewStartY);
                g2d.setColor(new Color(100, 100, 100, 40));
                g2d.fillRect(0, viewStartY, width, viewHeight);
                g2d.setColor(new Color(70, 70, 70));
                g2d.drawRect(0, viewStartY, width - 1, viewHeight);
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        g2d.dispose();
    }

    public static class DiffInfo {
        public int startLine;
        public int endLine;
        public DiffType type;
        public boolean isLeftSide;

        public DiffInfo(int startLine, int endLine, DiffType type, boolean isLeftSide) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.type = type;
            this.isLeftSide = isLeftSide;
        }
    }

    public static enum DiffType {
        ADDED,
        DELETED,
        MODIFIED;

    }
}

