/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codepreview;

import com.gigadevice.codepreview.DiffScrollViewPanel;
import com.gigadevice.codepreview.FileTreePanel;
import com.gigadevice.codepreview.Messages;
import com.gigadevice.codepreview.util.CodePreviewUtil;
import com.github.difflib.DiffUtils;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.Patch;
import com.github.difflib.text.DiffRow;
import com.github.difflib.text.DiffRowGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class CodePreview {
    public static final Color DIFFCOLOR_ADDED = new Color(255, 255, 0);
    public static final Color DIFFCOLOR_DELETED = new Color(0, 0, 255);
    public static final Color DIFFCOLOR_MODIFIED = new Color(255, 0, 0);
    public static final Color GRAY_LIGHT = new Color(192, 192, 192);
    private static JComponent codePreviewPanel;
    private static final Preferences prefs;
    private static final String OPENED_FILES_KEY = "openedFiles";
    private static final String SELECTED_FILE_KEY = "selectedFile";
    private static JTabbedPane currentTabbedPane;

    static {
        prefs = Preferences.userNodeForPackage(CodePreview.class);
    }

    public static JComponent createPartControl() {
        codePreviewPanel = new JPanel(new BorderLayout());
        CodePreview.clearAllPreferences();
        return codePreviewPanel;
    }

    private static void clearAllPreferences() {
        try {
            String[] keys;
            String[] stringArray = keys = prefs.keys();
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                prefs.remove(key);
                ++n2;
            }
            prefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateCodePreview() {
        codePreviewPanel.removeAll();
        CodePreview.reCreateCodePreview();
        codePreviewPanel.revalidate();
        codePreviewPanel.repaint();
    }

    public static void reCreateCodePreview() {
        String codePreviewFileRootPath = CodePreviewUtil.GetNewFilePath();
        File rootFolder = new File(codePreviewFileRootPath);
        if (!rootFolder.exists() || !rootFolder.isDirectory()) {
            JLabel errorLabel = new JLabel(Messages.status_noCodeAvailable);
            errorLabel.setHorizontalAlignment(2);
            codePreviewPanel.add((Component)errorLabel, "North");
            return;
        }
        codePreviewPanel.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setDividerLocation(250);
        JTabbedPane rightTabbedPane = new JTabbedPane();
        rightTabbedPane.setTabLayoutPolicy(1);
        currentTabbedPane = rightTabbedPane;
        rightTabbedPane.addChangeListener(e -> CodePreview.saveCurrentState());
        FileTreePanel fileTreePanel = new FileTreePanel(rootFolder, rightTabbedPane);
        splitPane.setLeftComponent(fileTreePanel);
        splitPane.setRightComponent(rightTabbedPane);
        codePreviewPanel.add((Component)splitPane, "Center");
        SwingUtilities.invokeLater(() -> CodePreview.restoreLastSession(rootFolder, rightTabbedPane));
    }

    private static void restoreLastSession(File rootFolder, JTabbedPane tabbedPane) {
        String openedFilesStr = prefs.get(OPENED_FILES_KEY, "");
        String selectedFileName = prefs.get(SELECTED_FILE_KEY, "");
        if (openedFilesStr.isEmpty()) {
            return;
        }
        String[] fileNames = openedFilesStr.split(";");
        int selectedIndex = -1;
        int i = 0;
        while (i < fileNames.length) {
            File file;
            String fileName = fileNames[i].trim();
            if (!fileName.isEmpty() && (file = CodePreview.findFileInDirectory(rootFolder, fileName)) != null && file.exists() && file.isFile()) {
                CodePreview.openFileSideBySideDiffView(file, tabbedPane);
                if (fileName.equals(selectedFileName)) {
                    selectedIndex = tabbedPane.getTabCount() - 1;
                }
            }
            ++i;
        }
        if (selectedIndex >= 0 && selectedIndex < tabbedPane.getTabCount()) {
            tabbedPane.setSelectedIndex(selectedIndex);
        }
    }

    private static File findFileInDirectory(File directory, String fileName) {
        File file;
        if (directory == null || !directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (file.isFile() && file.getName().equals(fileName)) {
                return file;
            }
            ++n2;
        }
        fileArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            File found;
            file = fileArray[n2];
            if (file.isDirectory() && (found = CodePreview.findFileInDirectory(file, fileName)) != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    public static void saveCurrentState() {
        if (currentTabbedPane == null) {
            return;
        }
        StringJoiner openedFiles = new StringJoiner(";");
        int i = 0;
        while (i < currentTabbedPane.getTabCount()) {
            String tabTitle = currentTabbedPane.getTitleAt(i);
            if (tabTitle != null && !tabTitle.trim().isEmpty()) {
                openedFiles.add(tabTitle.trim());
            }
            ++i;
        }
        String selectedFileName = "";
        int selectedIndex = currentTabbedPane.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < currentTabbedPane.getTabCount()) {
            selectedFileName = currentTabbedPane.getTitleAt(selectedIndex);
        }
        prefs.put(OPENED_FILES_KEY, openedFiles.toString());
        prefs.put(SELECTED_FILE_KEY, selectedFileName != null ? selectedFileName : "");
        try {
            prefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void openFileNormalView(File file, JTabbedPane tabbedPane) {
        String fileName = file.getName();
        int i = 0;
        while (i < tabbedPane.getTabCount()) {
            String title = tabbedPane.getTitleAt(i);
            if (title.equals(fileName)) {
                tabbedPane.setSelectedIndex(i);
                CodePreview.saveCurrentState();
                return;
            }
            ++i;
        }
        RSyntaxTextArea textArea = new RSyntaxTextArea();
        textArea.setEditable(false);
        CodePreview.initRSyntaxTextArea(textArea, fileName);
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)textArea);
        scrollPane.setLineNumbersEnabled(true);
        scrollPane.setFoldIndicatorEnabled(true);
        JCheckBox sideBySideDiffCheckBox = new JCheckBox(Messages.checkbox_sideBySideDiff);
        sideBySideDiffCheckBox.setToolTipText(Messages.tooltip_sideBySideDiff);
        File finalFile = file;
        sideBySideDiffCheckBox.addActionListener(e -> {
            boolean isSideBySideDiffChecked = sideBySideDiffCheckBox.isSelected();
            int currentIndex = tabbedPane.indexOfComponent(((JComponent)sideBySideDiffCheckBox.getParent()).getParent());
            if (currentIndex >= 0) {
                tabbedPane.remove(currentIndex);
                if (isSideBySideDiffChecked) {
                    CodePreview.openFileSideBySideDiffView(finalFile, tabbedPane);
                } else {
                    CodePreview.openFileNormalView(finalFile, tabbedPane);
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add(sideBySideDiffCheckBox);
        contentPanel.add((Component)topPanel, "North");
        contentPanel.add((Component)scrollPane, "Center");
        try {
            Throwable throwable = null;
            Object var10_14 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                textArea.setText(content.toString());
                textArea.setCaretPosition(0);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            textArea.setText("Unable to read file: " + e2.getMessage());
        }
        tabbedPane.addTab(fileName, null, contentPanel);
        int index = tabbedPane.getTabCount() - 1;
        JPanel titlePanel = CodePreview.createTabTitlePanel(fileName, tabbedPane);
        tabbedPane.setTabComponentAt(index, titlePanel);
        tabbedPane.setSelectedIndex(index);
        CodePreview.saveCurrentState();
    }

    public static void openFileSideBySideDiffView(File file, JTabbedPane tabbedPane) {
        String fileName;
        String diffTabTitle = fileName = file.getName();
        int i = 0;
        while (i < tabbedPane.getTabCount()) {
            String title = tabbedPane.getTitleAt(i);
            if (title.equals(fileName)) {
                tabbedPane.setSelectedIndex(i);
                CodePreview.saveCurrentState();
                return;
            }
            ++i;
        }
        File compareFileTemp = new File(CodePreviewUtil.getFileOldPath(fileName));
        if (!compareFileTemp.exists() || !compareFileTemp.isFile()) {
            CodePreview.openFileSideBySideDiffView_OpenNormalView(file, tabbedPane, fileName, NormalViewEnmu.NOCOMPAREFILE.ordinal());
            return;
        }
        if (!CodePreview.openFileSideBySideDiffView_CheckDiff(file, tabbedPane, fileName)) {
            CodePreview.openFileSideBySideDiffView_OpenNormalView(file, tabbedPane, fileName, NormalViewEnmu.NODIFF.ordinal());
            return;
        }
        final JSplitPane diffPane = new JSplitPane(1);
        diffPane.setResizeWeight(0.5);
        diffPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                diffPane.setDividerLocation(0.5);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                diffPane.setDividerLocation(0.5);
            }
        });
        SwingUtilities.invokeLater(() -> diffPane.setDividerLocation(0.5));
        JCheckBox diffViewCheckBox = new JCheckBox(Messages.checkbox_sideBySideDiff);
        diffViewCheckBox.setToolTipText(Messages.tooltip_sideBySideDiff);
        diffViewCheckBox.setSelected(true);
        File finalFile = file;
        diffViewCheckBox.addActionListener(e -> {
            boolean isSideBySideDiffChecked = diffViewCheckBox.isSelected();
            int currentIndex = tabbedPane.indexOfComponent(((JComponent)diffViewCheckBox.getParent()).getParent());
            if (currentIndex >= 0) {
                tabbedPane.remove(currentIndex);
                if (isSideBySideDiffChecked) {
                    CodePreview.openFileSideBySideDiffView(finalFile, tabbedPane);
                } else {
                    CodePreview.openFileNormalView(finalFile, tabbedPane);
                }
            }
        });
        JPanel checkBoxPanel = new JPanel(new FlowLayout(0));
        checkBoxPanel.add(diffViewCheckBox);
        checkBoxPanel.add(new JLabel("      "));
        JLabel addedLabel = new JLabel(CodePreview.createColorIcon(DIFFCOLOR_ADDED));
        addedLabel.setToolTipText(Messages.label_addedCode);
        checkBoxPanel.add(addedLabel);
        checkBoxPanel.add(new JLabel(String.valueOf(Messages.label_addedCode) + "    "));
        JLabel removedLabel = new JLabel(CodePreview.createColorIcon(DIFFCOLOR_DELETED));
        removedLabel.setToolTipText(Messages.label_deletedCode);
        checkBoxPanel.add(removedLabel);
        checkBoxPanel.add(new JLabel(String.valueOf(Messages.label_deletedCode) + "    "));
        JLabel modifiedLabel = new JLabel(CodePreview.createColorIcon(DIFFCOLOR_MODIFIED));
        modifiedLabel.setToolTipText(Messages.label_modifiedCode);
        checkBoxPanel.add(modifiedLabel);
        checkBoxPanel.add(new JLabel(Messages.label_modifiedCode));
        RSyntaxTextArea codePreviewTextArea = new RSyntaxTextArea();
        codePreviewTextArea.setEditable(false);
        CodePreview.initRSyntaxTextArea(codePreviewTextArea, fileName);
        RTextScrollPane codePreviewScrollPane = new RTextScrollPane((RTextArea)codePreviewTextArea);
        codePreviewScrollPane.setLineNumbersEnabled(true);
        codePreviewScrollPane.setFoldIndicatorEnabled(true);
        JPanel codePreviewPanel = new JPanel(new BorderLayout());
        JLabel codePreviewLabel = new JLabel(Messages.label_newFile);
        codePreviewPanel.add((Component)codePreviewLabel, "North");
        codePreviewPanel.add((Component)codePreviewScrollPane, "Center");
        File compareFile = new File(CodePreviewUtil.getFileOldPath(fileName));
        RSyntaxTextArea compareTextArea = new RSyntaxTextArea();
        compareTextArea.setEditable(false);
        CodePreview.initRSyntaxTextArea(compareTextArea, fileName);
        RTextScrollPane compareScrollPane = new RTextScrollPane((RTextArea)compareTextArea);
        compareScrollPane.setLineNumbersEnabled(true);
        compareScrollPane.setFoldIndicatorEnabled(true);
        JPanel compareFilePanel = new JPanel(new BorderLayout());
        JLabel compareFileLabel = new JLabel(Messages.label_oldFile);
        compareFilePanel.add((Component)compareFileLabel, "North");
        compareFilePanel.add((Component)compareScrollPane, "Center");
        ArrayList<String> codePreviewLines = new ArrayList();
        ArrayList<String> compareFileLines = new ArrayList();
        try {
            codePreviewLines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            codePreviewTextArea.setText(String.join((CharSequence)"\n", codePreviewLines));
            codePreviewTextArea.setCaretPosition(0);
        }
        catch (IOException e2) {
            codePreviewTextArea.setText("Unable to read file: " + e2.getMessage());
        }
        if (compareFile.exists() && compareFile.isFile()) {
            try {
                compareFileLines = Files.readAllLines(compareFile.toPath(), StandardCharsets.UTF_8);
                compareTextArea.setText(String.join((CharSequence)"\n", compareFileLines));
                compareTextArea.setCaretPosition(0);
            }
            catch (IOException e3) {
                compareTextArea.setText("Unable to read file: " + e3.getMessage());
            }
        } else {
            compareTextArea.setText("Unable to read file");
        }
        try {
            Patch patch = DiffUtils.diff(compareFileLines, codePreviewLines);
            JPanel diffStatPanel = CodePreview.createDiffStatisticsPanel((Patch<String>)patch);
            checkBoxPanel.add(Box.createHorizontalStrut(20));
            checkBoxPanel.add(diffStatPanel);
            JButton prevDiffBtn = new JButton(Messages.button_previousDiff);
            JButton nextDiffBtn = new JButton(Messages.button_nextDiff);
            JPanel diffPanel = new JPanel(new FlowLayout(2));
            diffPanel.add(prevDiffBtn);
            diffPanel.add(nextDiffBtn);
            checkBoxPanel.add(Box.createHorizontalGlue());
            checkBoxPanel.add(diffPanel);
            ArrayList<Integer> diffLines = new ArrayList<Integer>();
            for (AbstractDelta delta : patch.getDeltas()) {
                diffLines.add(delta.getTarget().getPosition());
            }
            Collections.sort(diffLines);
            int[] currentDiffIndex = new int[]{-1};
            prevDiffBtn.addActionListener(e -> {
                if (diffLines.isEmpty()) {
                    return;
                }
                nArray[0] = currentDiffIndex[0] - 1;
                if (currentDiffIndex[0] < 0) {
                    nArray[0] = diffLines.size() - 1;
                }
                try {
                    int line = (Integer)diffLines.get(currentDiffIndex[0]);
                    int offset = codePreviewTextArea.getLineStartOffset(line);
                    codePreviewTextArea.setCaretPosition(offset);
                    compareTextArea.setCaretPosition(compareTextArea.getLineStartOffset(Math.min(line, compareTextArea.getLineCount() - 1)));
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            });
            nextDiffBtn.addActionListener(e -> {
                if (diffLines.isEmpty()) {
                    return;
                }
                nArray[0] = currentDiffIndex[0] + 1;
                if (currentDiffIndex[0] >= diffLines.size()) {
                    nArray[0] = 0;
                }
                try {
                    int line = (Integer)diffLines.get(currentDiffIndex[0]);
                    int offset = codePreviewTextArea.getLineStartOffset(line);
                    codePreviewTextArea.setCaretPosition(offset);
                    compareTextArea.setCaretPosition(compareTextArea.getLineStartOffset(Math.min(line, compareTextArea.getLineCount() - 1)));
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            });
            CodePreview.highlightDifferences(codePreviewTextArea, compareTextArea, codePreviewLines, compareFileLines);
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
        diffPane.setLeftComponent(compareFilePanel);
        diffPane.setRightComponent(codePreviewPanel);
        CodePreview.setupSynchronizedScrolling(codePreviewScrollPane, compareScrollPane);
        JPanel diffMainPanel = new JPanel(new BorderLayout());
        DiffScrollViewPanel diffScrollViewPanel = CodePreview.createDiffScrollViewPanel(compareTextArea, codePreviewTextArea, compareScrollPane, codePreviewScrollPane, compareFileLines, codePreviewLines);
        diffMainPanel.add((Component)diffScrollViewPanel, "West");
        diffMainPanel.add((Component)diffPane, "Center");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)checkBoxPanel, "North");
        contentPanel.add((Component)diffMainPanel, "Center");
        JPanel lineDetailPanel = CodePreview.creatLineDiffDetailPanel(compareTextArea, codePreviewTextArea);
        contentPanel.add((Component)lineDetailPanel, "South");
        tabbedPane.addTab(diffTabTitle, null, contentPanel);
        int index = tabbedPane.getTabCount() - 1;
        JPanel titlePanel = CodePreview.createTabTitlePanel(diffTabTitle, tabbedPane);
        tabbedPane.setTabComponentAt(index, titlePanel);
        tabbedPane.setSelectedIndex(index);
        CodePreview.saveCurrentState();
    }

    private static JPanel creatLineDiffDetailPanel(final RSyntaxTextArea compareTextArea, final RSyntaxTextArea codePreviewTextArea) {
        final JPanel lineDiffDetailPanel = new JPanel(new BorderLayout());
        lineDiffDetailPanel.setBorder(BorderFactory.createTitledBorder(""));
        final JTextPane detailTextPane = new JTextPane();
        detailTextPane.setEditable(false);
        detailTextPane.setFont(new Font("Monospaced", 0, 14));
        JScrollPane detailScrollPane = new JScrollPane(detailTextPane);
        detailScrollPane.setPreferredSize(new Dimension(0, 120));
        lineDiffDetailPanel.add((Component)detailScrollPane, "Center");
        lineDiffDetailPanel.setVisible(false);
        MouseAdapter lineClickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RSyntaxTextArea source = (RSyntaxTextArea)e.getSource();
                try {
                    int clickedOffset = source.viewToModel(e.getPoint());
                    int clickedLine = source.getLineOfOffset(clickedOffset);
                    boolean isCompareArea = source == compareTextArea;
                    RSyntaxTextArea otherArea = isCompareArea ? codePreviewTextArea : compareTextArea;
                    String line = source.getText(source.getLineStartOffset(clickedLine), source.getLineEndOffset(clickedLine) - source.getLineStartOffset(clickedLine));
                    String otherLine = "";
                    if (clickedLine < otherArea.getLineCount()) {
                        otherLine = otherArea.getText(otherArea.getLineStartOffset(clickedLine), otherArea.getLineEndOffset(clickedLine) - otherArea.getLineStartOffset(clickedLine));
                    }
                    boolean hasDifference = false;
                    Highlighter.Highlight[] highlightArray = source.getHighlighter().getHighlights();
                    int n = highlightArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Highlighter.Highlight highlight = highlightArray[n2];
                        if (highlight instanceof Highlighter.Highlight) {
                            Highlighter.Highlight h = highlight;
                            int startLine = source.getLineOfOffset(h.getStartOffset());
                            int endLine = source.getLineOfOffset(h.getEndOffset());
                            if (clickedLine >= startLine && clickedLine <= endLine) {
                                hasDifference = true;
                                break;
                            }
                        }
                        ++n2;
                    }
                    if (hasDifference && !line.trim().isEmpty()) {
                        CodePreview.showLineDifferenceDetails(detailTextPane, line, otherLine, isCompareArea, clickedLine + 1);
                        lineDiffDetailPanel.setVisible(true);
                    } else {
                        lineDiffDetailPanel.setVisible(false);
                    }
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
            }
        };
        compareTextArea.addMouseListener((MouseListener)lineClickListener);
        codePreviewTextArea.addMouseListener((MouseListener)lineClickListener);
        return lineDiffDetailPanel;
    }

    private static DiffScrollViewPanel createDiffScrollViewPanel(RSyntaxTextArea compareTextArea, RSyntaxTextArea codePreviewTextArea, RTextScrollPane compareScrollPane, RTextScrollPane codePreviewScrollPane, List<String> compareFileLines, List<String> codePreviewLines) {
        DiffScrollViewPanel diffScrollViewPanel = new DiffScrollViewPanel(compareTextArea, codePreviewTextArea, compareScrollPane, codePreviewScrollPane);
        ArrayList<DiffScrollViewPanel.DiffInfo> diffInfoList = new ArrayList<DiffScrollViewPanel.DiffInfo>();
        try {
            Patch patch = DiffUtils.diff(compareFileLines, codePreviewLines);
            for (AbstractDelta delta : patch.getDeltas()) {
                switch (delta.getType()) {
                    case INSERT: {
                        int insertStartLine = delta.getTarget().getPosition();
                        int insertEndLine = insertStartLine + delta.getTarget().getLines().size();
                        diffInfoList.add(new DiffScrollViewPanel.DiffInfo(insertStartLine, insertEndLine, DiffScrollViewPanel.DiffType.ADDED, false));
                        break;
                    }
                    case DELETE: {
                        int deleteStartLine = delta.getSource().getPosition();
                        int deleteEndLine = deleteStartLine + delta.getSource().getLines().size();
                        diffInfoList.add(new DiffScrollViewPanel.DiffInfo(deleteStartLine, deleteEndLine, DiffScrollViewPanel.DiffType.DELETED, true));
                        break;
                    }
                    case CHANGE: {
                        int rightModifyStartLine = delta.getTarget().getPosition();
                        int rightModifyEndLine = rightModifyStartLine + delta.getTarget().getLines().size();
                        diffInfoList.add(new DiffScrollViewPanel.DiffInfo(rightModifyStartLine, rightModifyEndLine, DiffScrollViewPanel.DiffType.MODIFIED, false));
                        int leftModifyStartLine = delta.getSource().getPosition();
                        int leftModifyEndLine = leftModifyStartLine + delta.getSource().getLines().size();
                        diffInfoList.add(new DiffScrollViewPanel.DiffInfo(leftModifyStartLine, leftModifyEndLine, DiffScrollViewPanel.DiffType.MODIFIED, true));
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        diffScrollViewPanel.setDiffInfoList(diffInfoList);
        return diffScrollViewPanel;
    }

    private static void openFileSideBySideDiffView_OpenNormalView(File file, JTabbedPane tabbedPane, String fileName, int NormalViewFlag) {
        Serializable infoLabel;
        RSyntaxTextArea textArea = new RSyntaxTextArea();
        textArea.setEditable(false);
        CodePreview.initRSyntaxTextArea(textArea, fileName);
        RTextScrollPane scrollPane = new RTextScrollPane((RTextArea)textArea);
        scrollPane.setLineNumbersEnabled(true);
        scrollPane.setFoldIndicatorEnabled(true);
        JCheckBox sideBySideDiffCheckBox = new JCheckBox(Messages.checkbox_sideBySideDiff);
        sideBySideDiffCheckBox.setToolTipText(Messages.status_comparedFileNotExist);
        sideBySideDiffCheckBox.setEnabled(false);
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add(sideBySideDiffCheckBox);
        String tipsStr = "";
        if (NormalViewFlag == NormalViewEnmu.NOCOMPAREFILE.ordinal()) {
            tipsStr = Messages.status_firstCreatedFile;
        } else if (NormalViewFlag == NormalViewEnmu.NODIFF.ordinal()) {
            tipsStr = Messages.status_noChangesInFile;
        }
        if (!tipsStr.equals("")) {
            infoLabel = new JLabel(tipsStr);
            ((JComponent)infoLabel).setForeground(Color.BLUE);
            topPanel.add((Component)infoLabel);
        }
        contentPanel.add((Component)topPanel, "North");
        contentPanel.add((Component)scrollPane, "Center");
        try {
            infoLabel = null;
            Object var11_14 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                textArea.setText(content.toString());
                textArea.setCaretPosition(0);
            }
            catch (Throwable throwable) {
                if (infoLabel == null) {
                    infoLabel = throwable;
                } else if (infoLabel != throwable) {
                    ((Throwable)infoLabel).addSuppressed(throwable);
                }
                throw infoLabel;
            }
        }
        catch (IOException e) {
            textArea.setText("Unable to read file: " + e.getMessage());
        }
        tabbedPane.addTab(fileName, null, contentPanel);
        int index = tabbedPane.getTabCount() - 1;
        JPanel titlePanel = CodePreview.createTabTitlePanel(fileName, tabbedPane);
        tabbedPane.setTabComponentAt(index, titlePanel);
        tabbedPane.setSelectedIndex(index);
        CodePreview.saveCurrentState();
    }

    private static boolean openFileSideBySideDiffView_CheckDiff(File file, JTabbedPane tabbedPane, String fileName) {
        File compareFileTemp = new File(CodePreviewUtil.getFileOldPath(fileName));
        try {
            List<String> codePreviewLines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            List<String> compareFileLines = Files.readAllLines(compareFileTemp.toPath(), StandardCharsets.UTF_8);
            Patch patch = DiffUtils.diff(compareFileLines, codePreviewLines);
            return !patch.getDeltas().isEmpty();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void initRSyntaxTextArea(RSyntaxTextArea textArea, String fileName) {
        textArea.setFont(new Font("Monospaced", 0, 14));
        textArea.setCodeFoldingEnabled(true);
        textArea.setAnimateBracketMatching(true);
        textArea.setAntiAliasingEnabled(true);
        textArea.setAutoIndentEnabled(true);
        textArea.setBracketMatchingEnabled(true);
        textArea.setPopupMenu(null);
        String fileExtensionStr = CodePreview.getFileExtensionStr(fileName).toLowerCase();
        CodePreview.setSyntaxHighlightStyle(textArea, fileExtensionStr);
    }

    private static JPanel createTabTitlePanel(String title, final JTabbedPane tabbedPane) {
        final JPanel titlePanel = new JPanel(new FlowLayout(0, 0, 0));
        titlePanel.setOpaque(false);
        JLabel titleLabel = new JLabel(title);
        titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    int selectedIndex = tabbedPane.indexOfTabComponent(titlePanel);
                    tabbedPane.setSelectedIndex(selectedIndex);
                    CodePreview.saveCurrentState();
                }
            }
        });
        final JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem closeItem = new JMenuItem(Messages.menu_close);
        JMenuItem closeOthers = new JMenuItem(Messages.menu_closeOthers);
        JMenuItem closeAll = new JMenuItem(Messages.menu_closeAll);
        closeItem.addActionListener(e -> {
            int index = tabbedPane.indexOfTabComponent(titlePanel);
            if (index != -1) {
                tabbedPane.remove(index);
                CodePreview.saveCurrentState();
            }
        });
        closeOthers.addActionListener(e -> {
            int index = tabbedPane.indexOfTabComponent(titlePanel);
            if (index != -1) {
                Component selectedComponent = tabbedPane.getComponentAt(index);
                tabbedPane.removeAll();
                tabbedPane.addTab(title, null, selectedComponent);
                tabbedPane.setTabComponentAt(0, titlePanel);
                CodePreview.saveCurrentState();
            }
        });
        closeAll.addActionListener(e -> {
            tabbedPane.removeAll();
            CodePreview.clearAllPreferences();
        });
        popupMenu.add(closeItem);
        popupMenu.add(closeOthers);
        popupMenu.add(closeAll);
        titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        final JButton closeButton = new JButton("X");
        closeButton.setFont(new Font("Arial", 1, 10));
        closeButton.setPreferredSize(new Dimension(17, 17));
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.setContentAreaFilled(false);
        closeButton.setBorderPainted(false);
        closeButton.setFocusable(false);
        closeButton.setToolTipText(Messages.tooltip_close);
        closeButton.addActionListener(e -> {
            int index = tabbedPane.indexOfTabComponent(titlePanel);
            if (index != -1) {
                tabbedPane.remove(index);
                CodePreview.saveCurrentState();
            }
        });
        closeButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                closeButton.setBorderPainted(true);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                closeButton.setBorderPainted(false);
            }
        });
        titlePanel.add(titleLabel);
        titlePanel.add(closeButton);
        return titlePanel;
    }

    private static String getFileExtensionStr(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    private static void setSyntaxHighlightStyle(RSyntaxTextArea textArea, String fileExtensionStr) {
        switch (fileExtensionStr) {
            case "java": {
                textArea.setSyntaxEditingStyle("text/java");
                break;
            }
            case "c": 
            case "h": {
                textArea.setSyntaxEditingStyle("text/c");
                break;
            }
            case "cpp": 
            case "hpp": {
                textArea.setSyntaxEditingStyle("text/cpp");
                break;
            }
            case "js": {
                textArea.setSyntaxEditingStyle("text/javascript");
                break;
            }
            case "htm": 
            case "html": {
                textArea.setSyntaxEditingStyle("text/html");
                break;
            }
            case "xml": {
                textArea.setSyntaxEditingStyle("text/xml");
                break;
            }
            case "css": {
                textArea.setSyntaxEditingStyle("text/css");
                break;
            }
            case "php": {
                textArea.setSyntaxEditingStyle("text/php");
                break;
            }
            case "py": {
                textArea.setSyntaxEditingStyle("text/python");
                break;
            }
            case "rb": {
                textArea.setSyntaxEditingStyle("text/ruby");
                break;
            }
            case "sql": {
                textArea.setSyntaxEditingStyle("text/sql");
                break;
            }
            case "json": {
                textArea.setSyntaxEditingStyle("text/json");
                break;
            }
            case "md": 
            case "markdown": {
                textArea.setSyntaxEditingStyle("text/markdown");
                break;
            }
            case "sh": 
            case "bash": {
                textArea.setSyntaxEditingStyle("text/unix");
                break;
            }
            case "bat": {
                textArea.setSyntaxEditingStyle("text/bat");
                break;
            }
            case "properties": {
                textArea.setSyntaxEditingStyle("text/properties");
                break;
            }
            default: {
                textArea.setSyntaxEditingStyle("text/plain");
            }
        }
    }

    private static void highlightDifferences(RSyntaxTextArea codePreviewTextArea, RSyntaxTextArea compareTextArea, List<String> codePreviewLines, List<String> compareLines) {
        ArrayList<String> alignedCodePreviewLines = new ArrayList<String>();
        ArrayList<String> alignedCompareLines = new ArrayList<String>();
        DiffRowGenerator generator = DiffRowGenerator.create().showInlineDiffs(false).inlineDiffByWord(true).ignoreWhiteSpaces(false).build();
        try {
            List rows = generator.generateDiffRows(compareLines, codePreviewLines);
            int i = 0;
            while (i < rows.size()) {
                DiffRow row = (DiffRow)rows.get(i);
                switch (row.getTag()) {
                    case EQUAL: {
                        alignedCodePreviewLines.add(row.getNewLine());
                        alignedCompareLines.add(row.getOldLine());
                        break;
                    }
                    case INSERT: {
                        alignedCodePreviewLines.add(row.getNewLine());
                        alignedCompareLines.add("");
                        break;
                    }
                    case DELETE: {
                        alignedCodePreviewLines.add("");
                        alignedCompareLines.add(row.getOldLine());
                        break;
                    }
                    case CHANGE: {
                        alignedCodePreviewLines.add(row.getNewLine());
                        alignedCompareLines.add(row.getOldLine());
                    }
                }
                ++i;
            }
            codePreviewTextArea.setText(String.join((CharSequence)"\n", alignedCodePreviewLines));
            compareTextArea.setText(String.join((CharSequence)"\n", alignedCompareLines));
            codePreviewTextArea.setCaretPosition(0);
            compareTextArea.setCaretPosition(0);
            ArrayList<DiffRow> alignedRows = new ArrayList<DiffRow>();
            int i2 = 0;
            while (i2 < alignedCodePreviewLines.size() && i2 < alignedCompareLines.size()) {
                String rightLine = (String)alignedCodePreviewLines.get(i2);
                String leftLine = (String)alignedCompareLines.get(i2);
                if (leftLine.isEmpty() && !rightLine.isEmpty()) {
                    alignedRows.add(new DiffRow(DiffRow.Tag.INSERT, leftLine, rightLine));
                } else if (!leftLine.isEmpty() && rightLine.isEmpty()) {
                    alignedRows.add(new DiffRow(DiffRow.Tag.DELETE, leftLine, rightLine));
                } else if (leftLine.equals(rightLine)) {
                    alignedRows.add(new DiffRow(DiffRow.Tag.EQUAL, leftLine, rightLine));
                } else {
                    alignedRows.add(new DiffRow(DiffRow.Tag.CHANGE, leftLine, rightLine));
                }
                ++i2;
            }
            CodePreview.applyDiffHighlight(codePreviewTextArea, compareTextArea, alignedRows);
        }
        catch (Exception e) {
            e.printStackTrace();
            codePreviewTextArea.setText(String.join((CharSequence)"\n", codePreviewLines));
            compareTextArea.setText(String.join((CharSequence)"\n", compareLines));
        }
    }

    private static void applyDiffHighlight(RSyntaxTextArea rightTextArea, RSyntaxTextArea liftTextArea, List<DiffRow> rows) {
        rightTextArea.getHighlighter().removeAllHighlights();
        liftTextArea.getHighlighter().removeAllHighlights();
        DefaultHighlighter.DefaultHighlightPainter addedPainter = new DefaultHighlighter.DefaultHighlightPainter(DIFFCOLOR_ADDED);
        DefaultHighlighter.DefaultHighlightPainter deletedPainter = new DefaultHighlighter.DefaultHighlightPainter(DIFFCOLOR_DELETED);
        DefaultHighlighter.DefaultHighlightPainter modifiedPainter = new DefaultHighlighter.DefaultHighlightPainter(DIFFCOLOR_MODIFIED);
        int leftLine = 0;
        int rightLine = 0;
        try {
            for (DiffRow row : rows) {
                switch (row.getTag()) {
                    case EQUAL: {
                        ++leftLine;
                        ++rightLine;
                        break;
                    }
                    case INSERT: {
                        int endOffset;
                        int startOffset;
                        if (leftLine < rightTextArea.getLineCount()) {
                            startOffset = rightTextArea.getLineStartOffset(leftLine);
                            endOffset = rightTextArea.getLineEndOffset(leftLine);
                            if (endOffset - startOffset > 1) {
                                rightTextArea.getHighlighter().addHighlight(startOffset, endOffset - 1, addedPainter);
                            }
                        }
                        ++leftLine;
                        ++rightLine;
                        break;
                    }
                    case DELETE: {
                        int endOffset;
                        int startOffset;
                        if (rightLine < liftTextArea.getLineCount()) {
                            startOffset = liftTextArea.getLineStartOffset(rightLine);
                            endOffset = liftTextArea.getLineEndOffset(rightLine);
                            if (endOffset - startOffset > 1) {
                                liftTextArea.getHighlighter().addHighlight(startOffset, endOffset - 1, deletedPainter);
                            }
                        }
                        ++leftLine;
                        ++rightLine;
                        break;
                    }
                    case CHANGE: {
                        int endOffset;
                        int startOffset;
                        if (leftLine < rightTextArea.getLineCount()) {
                            startOffset = rightTextArea.getLineStartOffset(leftLine);
                            endOffset = rightTextArea.getLineEndOffset(leftLine);
                            if (endOffset - startOffset > 1) {
                                rightTextArea.getHighlighter().addHighlight(startOffset, endOffset - 1, modifiedPainter);
                            }
                        }
                        if (rightLine < liftTextArea.getLineCount()) {
                            startOffset = liftTextArea.getLineStartOffset(rightLine);
                            endOffset = liftTextArea.getLineEndOffset(rightLine);
                            if (endOffset - startOffset > 1) {
                                liftTextArea.getHighlighter().addHighlight(startOffset, endOffset - 1, modifiedPainter);
                            }
                        }
                        ++leftLine;
                        ++rightLine;
                    }
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private static ImageIcon createColorIcon(Color color) {
        int width = 12;
        int height = 12;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(color);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, width - 1, height - 1);
        g.dispose();
        return new ImageIcon(image);
    }

    private static JPanel createDiffStatisticsPanel(Patch<String> patch) {
        JPanel panel = new JPanel(new FlowLayout(0));
        int insertNumb = 0;
        int deletNumb = 0;
        int modifyNumb = 0;
        int totalChangedNumb = 0;
        for (AbstractDelta delta : patch.getDeltas()) {
            switch (delta.getType()) {
                case INSERT: {
                    insertNumb += delta.getTarget().getLines().size();
                    totalChangedNumb += delta.getTarget().getLines().size();
                    break;
                }
                case DELETE: {
                    deletNumb += delta.getSource().getLines().size();
                    totalChangedNumb += delta.getSource().getLines().size();
                    break;
                }
                case CHANGE: {
                    int sourceSize = delta.getSource().getLines().size();
                    int targetSize = delta.getTarget().getLines().size();
                    modifyNumb += Math.max(sourceSize, targetSize);
                    totalChangedNumb += Math.max(sourceSize, targetSize);
                    break;
                }
            }
        }
        JLabel diffStatisticsLabel = new JLabel(MessageFormat.format(Messages.label_diffStatistics, totalChangedNumb, insertNumb, deletNumb, modifyNumb));
        diffStatisticsLabel.setFont(new Font("SansSerif", 1, 12));
        panel.add(diffStatisticsLabel);
        return panel;
    }

    private static void setupSynchronizedScrolling(RTextScrollPane scrollPane1, RTextScrollPane scrollPane2) {
        AdjustmentListener[] hListeners;
        AdjustmentListener[] vListeners;
        final JScrollBar vJScrollBar1 = scrollPane1.getVerticalScrollBar();
        final JScrollBar vJScrollBar2 = scrollPane2.getVerticalScrollBar();
        vListeners = new AdjustmentListener[]{new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                vJScrollBar2.removeAdjustmentListener(vListeners[1]);
                vJScrollBar2.setValue(e.getValue());
                vJScrollBar2.addAdjustmentListener(vListeners[1]);
            }
        }, new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                vJScrollBar1.removeAdjustmentListener(vListeners[0]);
                vJScrollBar1.setValue(e.getValue());
                vJScrollBar1.addAdjustmentListener(vListeners[0]);
            }
        }};
        vJScrollBar1.addAdjustmentListener(vListeners[0]);
        vJScrollBar2.addAdjustmentListener(vListeners[1]);
        final JScrollBar hJScrollBar1 = scrollPane1.getHorizontalScrollBar();
        final JScrollBar hJScrollBar2 = scrollPane2.getHorizontalScrollBar();
        hListeners = new AdjustmentListener[]{new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                hJScrollBar2.removeAdjustmentListener(hListeners[1]);
                hJScrollBar2.setValue(e.getValue());
                hJScrollBar2.addAdjustmentListener(hListeners[1]);
            }
        }, new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                hJScrollBar1.removeAdjustmentListener(hListeners[0]);
                hJScrollBar1.setValue(e.getValue());
                hJScrollBar1.addAdjustmentListener(hListeners[0]);
            }
        }};
        hJScrollBar1.addAdjustmentListener(hListeners[0]);
        hJScrollBar2.addAdjustmentListener(hListeners[1]);
    }

    private static void showLineDifferenceDetails(JTextPane detailTextPane, String line1, String line2, boolean isLeftSource, int lineNumber) {
        char c;
        String oldLine = isLeftSource ? line1 : line2;
        String newLine = isLeftSource ? line2 : line1;
        String diffTypeHint = "";
        String diffTypeColor = "";
        boolean isDeleted = false;
        boolean isAdded = false;
        if (oldLine.trim().isEmpty() && !newLine.trim().isEmpty()) {
            diffTypeHint = Messages.label_newFileAdded;
            diffTypeColor = String.format("#%02X%02X%02X", GRAY_LIGHT.getRed(), GRAY_LIGHT.getGreen(), GRAY_LIGHT.getBlue());
            isAdded = true;
        } else if (!oldLine.trim().isEmpty() && newLine.trim().isEmpty()) {
            diffTypeHint = Messages.label_newFileDeleted;
            diffTypeColor = String.format("#%02X%02X%02X", GRAY_LIGHT.getRed(), GRAY_LIGHT.getGreen(), GRAY_LIGHT.getBlue());
            isDeleted = true;
        } else if (!(oldLine.trim().isEmpty() || newLine.trim().isEmpty() || oldLine.equals(newLine))) {
            diffTypeHint = Messages.label_newFileModified;
            diffTypeColor = String.format("#%02X%02X%02X", GRAY_LIGHT.getRed(), GRAY_LIGHT.getGreen(), GRAY_LIGHT.getBlue());
        }
        ArrayList<String> oldChars = new ArrayList<String>();
        ArrayList<String> newChars = new ArrayList<String>();
        Object object = oldLine.toCharArray();
        int n = ((char[])object).length;
        int n2 = 0;
        while (n2 < n) {
            c = object[n2];
            oldChars.add(String.valueOf(c));
            ++n2;
        }
        object = newLine.toCharArray();
        n = ((char[])object).length;
        n2 = 0;
        while (n2 < n) {
            c = object[n2];
            newChars.add(String.valueOf(c));
            ++n2;
        }
        try {
            Patch patch = DiffUtils.diff(oldChars, newChars);
            StringBuilder htmlBuilder = new StringBuilder();
            htmlBuilder.append("<html><body style='font-family: monospace;'>");
            if (!diffTypeHint.isEmpty()) {
                htmlBuilder.append("<div style='margin-bottom: 5px; padding: 3px; background-color: ").append(diffTypeColor).append("; border-radius: 3px;'>");
                htmlBuilder.append("<b>").append(MessageFormat.format(Messages.label_lineNumber, lineNumber)).append(" - ").append(diffTypeHint).append("</b>");
                htmlBuilder.append("</div>");
                htmlBuilder.append("<div style='margin-bottom: 5px;'><b>").append(Messages.label_lineDiffDetails).append("</b></div>");
            } else {
                htmlBuilder.append("<div style='margin-bottom: 5px; padding: 3px; background-color: #E6F3FF; border-radius: 3px;'>");
                htmlBuilder.append("<b>").append(MessageFormat.format(Messages.label_lineNumber, lineNumber)).append("</b>");
                htmlBuilder.append("</div>");
                htmlBuilder.append("<div style='margin-bottom: 5px;'><b>").append(Messages.label_noDifference).append("</b></div>");
            }
            if (isDeleted) {
                htmlBuilder.append("<div><b>&gt;&gt; ").append(Messages.label_newFileDeleted).append(":</b> ");
                object = oldChars.iterator();
                while (object.hasNext()) {
                    String c2 = (String)object.next();
                    htmlBuilder.append(CodePreview.escapeHtml(c2));
                }
                htmlBuilder.append("</div>");
            } else if (isAdded) {
                htmlBuilder.append("<div><b>&gt;&gt; ").append(Messages.label_newFileAdded).append(":</b> ");
                object = newChars.iterator();
                while (object.hasNext()) {
                    String c3 = (String)object.next();
                    htmlBuilder.append(CodePreview.escapeHtml(c3));
                }
                htmlBuilder.append("</div>");
            } else {
                htmlBuilder.append("<div><b>").append(CodePreview.escapeHtml(Messages.label_oldFilePrefix)).append("</b> ");
                int oldIndex = 0;
                for (AbstractDelta delta : patch.getDeltas()) {
                    int i = oldIndex;
                    while (i < delta.getSource().getPosition()) {
                        htmlBuilder.append(CodePreview.escapeHtml((String)oldChars.get(i)));
                        ++i;
                    }
                    htmlBuilder.append("<span style='background-color: #FF0000;'>");
                    for (String c4 : delta.getSource().getLines()) {
                        htmlBuilder.append(CodePreview.escapeHtml(c4));
                    }
                    htmlBuilder.append("</span>");
                    oldIndex = delta.getSource().getPosition() + delta.getSource().getLines().size();
                }
                int i = oldIndex;
                while (i < oldChars.size()) {
                    htmlBuilder.append(CodePreview.escapeHtml((String)oldChars.get(i)));
                    ++i;
                }
                htmlBuilder.append("</div>");
                htmlBuilder.append("<div><b>").append(CodePreview.escapeHtml(Messages.label_newFilePrefix)).append("</b> ");
                int newIndex = 0;
                for (AbstractDelta delta : patch.getDeltas()) {
                    int i2 = newIndex;
                    while (i2 < delta.getTarget().getPosition()) {
                        htmlBuilder.append(CodePreview.escapeHtml((String)newChars.get(i2)));
                        ++i2;
                    }
                    htmlBuilder.append("<span style='background-color: #FF0000;'>");
                    for (String c5 : delta.getTarget().getLines()) {
                        htmlBuilder.append(CodePreview.escapeHtml(c5));
                    }
                    htmlBuilder.append("</span>");
                    newIndex = delta.getTarget().getPosition() + delta.getTarget().getLines().size();
                }
                int i3 = newIndex;
                while (i3 < newChars.size()) {
                    htmlBuilder.append(CodePreview.escapeHtml((String)newChars.get(i3)));
                    ++i3;
                }
                htmlBuilder.append("</div>");
            }
            htmlBuilder.append("</body></html>");
            detailTextPane.setContentType("text/html");
            detailTextPane.setText(htmlBuilder.toString());
        }
        catch (Exception e) {
            detailTextPane.setContentType("text/plain");
            detailTextPane.setText(MessageFormat.format(Messages.error_failedToAnalyzeLineDiff, lineNumber));
            e.printStackTrace();
        }
    }

    private static String escapeHtml(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace(" ", "&nbsp;").replace("\t", "&nbsp;&nbsp;&nbsp;&nbsp;");
    }

    public static boolean isFileDifferent(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        File oldFile = new File(CodePreviewUtil.getFileOldPath(file.getName()));
        if (!oldFile.exists() || !oldFile.isFile()) {
            return false;
        }
        try {
            List<String> newFileLines = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
            List<String> oldFileLines = Files.readAllLines(oldFile.toPath(), StandardCharsets.UTF_8);
            Patch patch = DiffUtils.diff(oldFileLines, newFileLines);
            return !patch.getDeltas().isEmpty();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isNewFile(File file) {
        if (file == null || !file.exists() || !file.isFile()) {
            return false;
        }
        File oldFile = new File(CodePreviewUtil.getFileOldPath(file.getName()));
        return !oldFile.exists();
    }

    public static enum NormalViewEnmu {
        NORMAL,
        NOCOMPAREFILE,
        NODIFF;

    }
}

