/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.xmlparse;

import com.gigadevice.periconfigview.baseinfo.privilege.GroupInfo;
import com.gigadevice.periconfigview.baseinfo.privilege.PeriPrivilegeInfo;
import com.gigadevice.periconfigview.baseinfo.privilege.PrivilegeControl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PeriConfigPrivilegeXmlParse {
    public static boolean ParsePrivilegeXml(String filePath, Map<String, PeriPrivilegeInfo> PeriPrivilegeInfos) {
        List PerisList;
        block6: {
            File f;
            SAXReader saxReader;
            block5: {
                saxReader = new SAXReader();
                f = new File(filePath);
                if (f.exists()) break block5;
                return false;
            }
            Document document = saxReader.read(f);
            Element rootElm = document.getRootElement();
            PerisList = rootElm.elements("Peris");
            if (PerisList.size() != 0) break block6;
            return false;
        }
        try {
            int Num = 0;
            for (Element elmPeris : PerisList) {
                PeriConfigPrivilegeXmlParse.ParseConflictGroupNode(Num, elmPeris, PeriPrivilegeInfos);
                ++Num;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void ParseConflictGroupNode(int Num, Element elmPeris, Map<String, PeriPrivilegeInfo> PeriPrivilegeInfos) {
        String PeriStr = elmPeris.attributeValue("Name");
        String[] Peris = PeriStr.split(",");
        int i = 0;
        while (i < Peris.length) {
            HashMap<String, List<String>> UserGroupInfo = new HashMap();
            HashMap<String, GroupInfo> GroupMapInfo = new HashMap();
            String PeriName = Peris[i];
            if (PeriPrivilegeInfos.containsKey(PeriName)) {
                UserGroupInfo = PeriPrivilegeInfos.get(PeriName).getUserGroupInfo();
                GroupMapInfo = PeriPrivilegeInfos.get(PeriName).getGroupMapInfo();
            }
            List ConflictGroupList = elmPeris.elements("ConflictGroup");
            int num = 0;
            for (Element elmConflictGroup : ConflictGroupList) {
                PrivilegeControl PrivilegeControlObj = new PrivilegeControl();
                Iterator itAttribute = elmConflictGroup.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    PrivilegeControlObj.setAttrValue(attributeName, attributeValue);
                }
                Element elmRelation = elmConflictGroup.element("Relation");
                String TypeName = elmRelation.attributeValue("Name");
                String ControlUserGroup = String.valueOf(PeriName) + "Group" + String.valueOf(Num) + String.valueOf(num++);
                List<List<PrivilegeControl>> PrivilegeUserList = PeriConfigPrivilegeXmlParse.ParsePrivilegeInfosList(PeriName, elmRelation, ControlUserGroup, UserGroupInfo);
                GroupInfo GroupInfoObj = new GroupInfo();
                GroupInfoObj.setPrivilegeInfo(PrivilegeControlObj);
                GroupInfoObj.setType(TypeName);
                GroupInfoObj.setPrivilegeUserList(PrivilegeUserList);
                GroupMapInfo.put(ControlUserGroup, GroupInfoObj);
            }
            PeriPrivilegeInfo PeriPrivilegeInfoObj = new PeriPrivilegeInfo();
            if (PeriPrivilegeInfos.containsKey(PeriName)) {
                PeriPrivilegeInfoObj = PeriPrivilegeInfos.get(PeriName);
            }
            PeriPrivilegeInfoObj.setGroupMapInfo(GroupMapInfo);
            PeriPrivilegeInfoObj.setUserList(UserGroupInfo);
            PeriPrivilegeInfos.put(PeriName, PeriPrivilegeInfoObj);
            ++i;
        }
    }

    private static List<List<PrivilegeControl>> ParsePrivilegeInfosList(String PeriName, Element elmRelation, String UserGroup, Map<String, List<String>> UserGroupInfo) {
        ArrayList<List<PrivilegeControl>> UserList = new ArrayList<List<PrivilegeControl>>();
        List PrivilegeInfosList = elmRelation.elements("PrivilegeInfos");
        for (Element elmPrivilegeInfos : PrivilegeInfosList) {
            List PrivilegeUserList = elmPrivilegeInfos.elements("PrivilegeUser");
            ArrayList<PrivilegeControl> UList = new ArrayList<PrivilegeControl>();
            for (Element elmPrivilegeUser : PrivilegeUserList) {
                PrivilegeControl PrivilegeUserObj = new PrivilegeControl();
                PrivilegeUserObj.setPeriName(PeriName);
                PrivilegeUserObj.setControlType("Item");
                Iterator itAttribute = elmPrivilegeUser.attributeIterator();
                while (itAttribute.hasNext()) {
                    Attribute attribute = (Attribute)itAttribute.next();
                    String attributeName = attribute.getName();
                    String attributeValue = attribute.getText();
                    PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
                }
                String User = PeriConfigPrivilegeXmlParse.returnUserString(PeriName, PrivilegeUserObj);
                if (User == null) continue;
                if (UserGroupInfo.containsKey(User)) {
                    UserGroupInfo.get(User).add(UserGroup);
                } else {
                    ArrayList<String> tmp = new ArrayList<String>();
                    tmp.add(UserGroup);
                    UserGroupInfo.put(User, tmp);
                }
                UList.add(PrivilegeUserObj);
            }
            UserList.add(UList);
        }
        return UserList;
    }

    private static String returnUserString(String PeriName, PrivilegeControl PrivilegeUserObj) {
        String User = null;
        if (PrivilegeUserObj.getRelateFrom().equals("0")) {
            String ItemPath = "";
            if (PrivilegeUserObj.getControlType().equals("Item")) {
                ItemPath = "##" + PrivilegeUserObj.getItemName();
            }
            User = "0##" + PeriName + "##" + PrivilegeUserObj.getGroupName() + "##" + PrivilegeUserObj.getControlName() + ItemPath;
        } else if (PrivilegeUserObj.getRelateFrom().equals("1")) {
            String GroupPath = "";
            if (!PrivilegeUserObj.getGroupName().equals("")) {
                GroupPath = "##" + PrivilegeUserObj.getGroupName();
            }
            User = PrivilegeUserObj.getControlType().equals("Peri") ? "1##" + PeriName : (PrivilegeUserObj.getControlType().equals("Item") ? "1##" + PeriName + GroupPath + "##" + PrivilegeUserObj.getControlName() + "##" + PrivilegeUserObj.getItemName() : "1##" + PeriName + GroupPath + "##" + PrivilegeUserObj.getControlName());
        } else if (PrivilegeUserObj.getRelateFrom().equals("2")) {
            User = "2##" + PrivilegeUserObj.getControlName();
        }
        return User;
    }
}

