/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import com.gigadevice.periconfigview.privilege.PrivilegeInfoExecute;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import com.gigadevice.periconfigview.utils.GPIOConfigUtil;
import com.gigadevice.periconfigview.utils.GeneralPeriConfigUtil;
import com.gigadevice.periconfigview.utils.MDMAConfigUtil;
import com.gigadevice.periconfigview.utils.NVICConfigUtil;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.xmlparse.PeiConfigViewXmlParse;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerisConfigUtil {
    public static Map<String, String> PeriTypeMap = new HashMap<String, String>();
    public static List<String> CofigPeriList = new ArrayList<String>();
    public static List<GD32PinPad> AddPinList = new ArrayList<GD32PinPad>();
    public static List<GD32PinPad> DeletePinList = new ArrayList<GD32PinPad>();
    public static final int isText = 0;
    public static final int isCheckBox = 1;
    public static final int isComBox = 2;
    public static final String IOdevice = "I/O Device";
    public static final String Analog = "Analog";
    public static final String Internal = "Internal";
    public static final String Ticker = "Ticker";
    public static final String General = "General";

    public static void ClearAllGlobalVars() {
        GlobalVariables.PeriConfigViewObj = null;
        PrivilegeInfoExecute.PeriPrivilegeInfos.clear();
        AddPinList.clear();
        DeletePinList.clear();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(PrivilegeInfoExecute.PeriPrivilegeInfos);
            GeneralPeriConfigUtil.Serialize(out);
            DMAConfigUtil.Serialize(out);
            NVICConfigUtil.Serialize(out);
            GPIOConfigUtil.Serialize(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                PerisConfigUtil.DeSerializeV1(ins);
            }
        }
        GeneralPeriConfigUtil.DeSerialize(ins, version);
        DMAConfigUtil.DeSerialize(ins, version);
        NVICConfigUtil.DeSerialize(ins, version);
        GPIOConfigUtil.DeSerialize(ins, version);
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            CofigPeriList = (List)ins.readObject();
            PeriTypeMap = (Map)ins.readObject();
            PrivilegeInfoExecute.PeriPrivilegeInfos = (Map)ins.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void InitAllGlobalVars() {
        GlobalPathUtil.GlobalXmlPaths globalXmlPathsObj = GlobalPathUtil.getGlobalXmlPaths();
        GlobalVariables.PeriConfigViewObj = PeiConfigViewXmlParse.parsePeiConfigViewXml((String)globalXmlPathsObj.PeriConfigXmlPath);
    }

    public static void InitGeneralandSysPeriCofigInfo() {
        DMAConfigUtil.DMAXMLInfoParse();
        MDMAConfigUtil.MDMAXMLInfoParse();
        NVICConfigUtil.InitConfigInfo();
        GPIOConfigUtil.GPIOXMLInfoParse();
        GeneralPeriConfigUtil.CheckSpecialPeriPrivilege();
    }

    public static boolean CheckPeriParaValuesLegality(Map<String, Map<String, String>> periParaInvalidMap) {
        return GeneralPeriConfigUtil.CheckPeriConfigValuesLegality(periParaInvalidMap);
    }
}

