/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import com.gigadevice.clockconfigview.RCUTreeView;
import com.gigadevice.clockconfigview.utils.RCUTreeUtil;
import com.gigadevice.conflict.ConflictExecute;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.periconfigview.baseinfo.GeneralPeriParaObject;
import com.gigadevice.periconfigview.privilege.PrivilegeInfoExecute;
import com.gigadevice.periconfigview.utils.NVICConfigUtil;
import com.gigadevice.periconfigview.xmlparse.GeneralPeriParaXmlParse;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.PerisTreeStruct;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriVariables;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.baseinfo.jtreenode.JTreeCheckboxNode;
import com.gigadevice.venustool.baseinfo.jtreenode.JTreeComboxNode;
import com.gigadevice.venustool.baseinfo.jtreenode.JTreeTextNode;
import com.gigadevice.venustool.controlconflict.PeriParaTreeConflict;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigGroupStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigViewNodeStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigViewStruct;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GeneralPeriConfigUtil {
    public static PerisTreeStruct PeripheralTree;
    public static Map<String, GeneralPeriParaObject> GeneralPeriParaObjectList;
    public static Map<String, Map<String, String>> GeneralPeriParaConfigInfoList;
    public static final String STR_SERIALIZE = "GENERALCONGIG";

    static {
        GeneralPeriParaObjectList = new HashMap<String, GeneralPeriParaObject>();
        GeneralPeriParaConfigInfoList = new HashMap<String, Map<String, String>>();
    }

    public static String Serialize() {
        String out = "";
        GeneralPeriParaConfigInfoList.clear();
        GeneralPeriConfigUtil.StoreGeneralPeriParaConfigInfo();
        for (Map.Entry<String, Map<String, String>> entry : GeneralPeriParaConfigInfoList.entrySet()) {
            String PeriName = entry.getKey();
            for (Map.Entry<String, String> entry1 : entry.getValue().entrySet()) {
                String controlPath = entry1.getKey();
                controlPath = controlPath.replaceAll("\\.", "@2E@");
                String str = String.valueOf(String.join((CharSequence)".", STR_SERIALIZE, PeriName, controlPath)) + "=" + entry1.getValue() + System.getProperty("line.separator");
                out = String.valueOf(out) + str;
            }
        }
        return out;
    }

    public static void DeSerialize(String ins, int version) {
        switch (version) {
            case 1: {
                GeneralPeriConfigUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(String input) {
        GeneralPeriParaConfigInfoList.clear();
        GeneralPeriParaConfigInfoList = GlobalVariables.serializeStrClassification((String)input, (String)STR_SERIALIZE);
    }

    public static void StoreGeneralPeriParaConfigInfo() {
        long start = System.currentTimeMillis();
        GeneralPeriConfigUtil.CheckSpecialPeriPrivilege();
        long end = System.currentTimeMillis();
        System.out.println("Cost Time CheckPeriConfigPrivilege= " + (end - start));
        for (Map.Entry entry1 : GeneralPeriVariables.GeneralPeriParaObjectList.entrySet()) {
            String PeriName = (String)entry1.getKey();
            HashMap<String, String> periConfiInfo = new HashMap<String, String>();
            GeneralPeriConfigUtil.CompareGeneralPeriPara(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)entry1.getValue()).PeriParaTreeXml, ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)entry1.getValue()).PeriParaTreeApply, periConfiInfo);
            GeneralPeriParaConfigInfoList.put(PeriName, periConfiInfo);
        }
    }

    public static void CompareGeneralPeriPara(AbstractJTreeNode srcInfo, AbstractJTreeNode applyInfo, Map<String, String> diffInfo) {
        if (srcInfo == null || applyInfo == null) {
            return;
        }
        int i = srcInfo.getChildCount() - 1;
        while (i >= 0) {
            AbstractJTreeNode srcChildNode = (AbstractJTreeNode)srcInfo.getChildAt(i);
            AbstractJTreeNode applyChildNode = (AbstractJTreeNode)applyInfo.getChildAt(i);
            if (applyChildNode.isVisible()) {
                String srcValue = srcChildNode.getValue();
                String applyVlaue = applyChildNode.getValue();
                if (srcValue == null) {
                    srcValue = "";
                }
                if (applyVlaue == null) {
                    applyVlaue = "";
                }
                if (!srcValue.equals(applyVlaue)) {
                    String nodePath = "";
                    ArrayList<String> pathList = new ArrayList<String>();
                    pathList.add(applyChildNode.getName());
                    GeneralPeriConfigUtil.GetTreeNodeParentPath(applyChildNode, pathList);
                    int p = pathList.size() - 2;
                    while (p >= 0) {
                        String pathStr = (String)pathList.get(p);
                        if (p != 0) {
                            pathStr = String.valueOf((String)pathList.get(p)) + "##";
                        }
                        nodePath = String.valueOf(nodePath) + pathStr;
                        --p;
                    }
                    diffInfo.put(nodePath, applyChildNode.getValue());
                }
                GeneralPeriConfigUtil.CompareGeneralPeriPara(srcChildNode, applyChildNode, diffInfo);
            }
            --i;
        }
    }

    private static void GetTreeNodeParentPath(AbstractJTreeNode treeNode, List<String> path) {
        if (treeNode.getParent() != null && !treeNode.isRoot()) {
            AbstractJTreeNode parentNode = (AbstractJTreeNode)treeNode.getParent();
            path.add(parentNode.getName());
            GeneralPeriConfigUtil.GetTreeNodeParentPath(parentNode, path);
        }
    }

    public static void ClearUserConfigVars() {
        for (Map.Entry entry : GeneralPeriVariables.GeneralPeriParaObjectList.entrySet()) {
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)entry.getValue()).PeriParaTreeApply, ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)entry.getValue()).PeriParaTreeXml);
            if (!GlobalVariables.PeriParaTreeObj.containsKey(entry.getKey())) continue;
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI((AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(entry.getKey()), ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)entry.getValue()).PeriParaTreeXml);
        }
    }

    public static void ClearPeriUserConfigVars(String periName) {
        LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
        String moduleType = ((ModuleStruct)modules_map.get(periName)).getModuleType();
        if (moduleType.equals("MiddleWare")) {
            GeneralPeriConfigUtil.ClearPeriMiddleWarerUserConfigVars(periName);
            return;
        }
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(periName)) {
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)periName)).PeriParaTreeApply, ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)periName)).PeriParaTreeXml);
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI((AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(periName), ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)periName)).PeriParaTreeXml);
        }
    }

    public static void ClearAllGlobalVars() {
        GeneralPeriVariables.GeneralPeriParaObjectList.clear();
        GlobalVariables.PeriParaTreeObj.clear();
        GeneralPeriParaConfigInfoList.clear();
    }

    public static void ClearPeriAllGlobalVars(String periName) {
        LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
        String moduleType = ((ModuleStruct)modules_map.get(periName)).getModuleType();
        if (moduleType.equals("MiddleWare")) {
            GeneralPeriConfigUtil.ClearMiddleWareAllGlobalVars(periName);
            return;
        }
        GeneralPeriVariables.GeneralPeriParaObjectList.remove(periName);
        GlobalVariables.PeriParaTreeObj.remove(periName);
    }

    public static void InitAllGlobalVars() {
        LinkedHashMap modules = GlobalVariables.MCUObj.getModules();
        for (Map.Entry entry : modules.entrySet()) {
            String tempPeriNameString;
            Object value = entry.getValue();
            if (!(value instanceof ModuleStruct) || (tempPeriNameString = (String)entry.getKey()).equals("TIPS")) continue;
            GeneralPeriConfigUtil.InitPeriConfigInfo(tempPeriNameString);
        }
    }

    public static void LoadAllGlobalVars() {
        String PeriName;
        String spotRightStr;
        String keyStr;
        GeneralPeriConfigUtil.InitAllGlobalVars();
        for (Map.Entry entry : GlobalVariables.PeripheralConfigObjMap.entrySet()) {
            String PeriName2 = (String)entry.getKey();
            LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
            String moduleType = ((ModuleStruct)modules_map.get(PeriName2)).getModuleType();
            if (moduleType.equals("MiddleWare")) {
                LinkedHashMap periTypeGroupMap = GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap();
                PeriConfigGroupStruct periConfigGroupStruct = (PeriConfigGroupStruct)periTypeGroupMap.get("MiddleWare");
                LinkedHashMap NodeList2 = periConfigGroupStruct.getNodeList();
                PeriConfigViewNodeStruct periConfigViewNodeStruct = (PeriConfigViewNodeStruct)NodeList2.get(PeriName2);
                LinkedHashMap TabList = periConfigViewNodeStruct.getTabList();
                for (String key : TabList.keySet()) {
                    ConflictExecute.initPeriConfigConflict((String)key);
                }
            } else {
                ConflictExecute.initPeriConfigConflict((String)PeriName2);
            }
            if (!GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(PeriName2)) continue;
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName2)).PeriParaTreeApply, (AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(PeriName2));
        }
        if (!GlobalVariables.PeripheralConfigObjMap.containsKey("RCU")) {
            ConflictExecute.initPeriConfigConflict((String)"RCU");
        }
        for (Map.Entry<Object, Object> entry : GeneralPeriParaConfigInfoList.entrySet()) {
            keyStr = (String)entry.getKey();
            int index = keyStr.lastIndexOf(".");
            if (index == -1) continue;
            PeriName = spotRightStr = keyStr.substring(index + 1, keyStr.length());
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                String[] errorStr = new String[1];
                boolean ret = PeriParaTreeConflict.UpdatePeriConfigValue((String)PeriName, (String)((String)entry2.getKey()), (String)((String)entry2.getValue()), (String[])errorStr);
                if (ret) continue;
                LogManager.getInstance().error(PeriName, errorStr[0]);
            }
        }
        ConflictUtil.openUpdateValuePrivilege((boolean)false);
        for (Map.Entry<Object, Object> entry : GeneralPeriParaConfigInfoList.entrySet()) {
            keyStr = (String)entry.getKey();
            int index = keyStr.lastIndexOf(".");
            if (index == -1) continue;
            PeriName = spotRightStr = keyStr.substring(index + 1, keyStr.length());
            for (Map.Entry entryV : ((Map)entry.getValue()).entrySet()) {
                String itemName = (String)entryV.getValue();
                String key = (String)entryV.getKey();
                String[] parts = key.split("##");
                if (parts.length < 2) continue;
                String controlName = parts[parts.length - 1];
                StringBuilder groupNameBuilder = new StringBuilder();
                int i = 0;
                while (i < parts.length - 1) {
                    groupNameBuilder.append(parts[i]);
                    if (i < parts.length - 2) {
                        groupNameBuilder.append("##");
                    }
                    ++i;
                }
                String groupName = groupNameBuilder.toString();
                ConflictExecute.ConflictExecuteByPeriConfig((String)PeriName, (String)groupName, (String)controlName, (String)itemName, (boolean)true);
            }
            if (!GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(PeriName)) continue;
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName)).PeriParaTreeApply, (AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(PeriName));
        }
        ConflictUtil.openUpdateValuePrivilege((boolean)true);
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(GeneralPeriVariables.GeneralPeriParaObjectList);
            out.writeObject(GlobalVariables.PeriParaTreeObj);
            out.writeObject(GlobalVariables.PeriConfigViewObj);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                GeneralPeriConfigUtil.DeSerializeV1(ins);
            }
        }
        for (Map.Entry<String, GeneralPeriParaObject> entry : GeneralPeriParaObjectList.entrySet()) {
            com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject obj = new com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject(entry.getKey());
            obj.PeriParaTreeApply = (AbstractJTreeNode)GlobalVariables.cloneFrom((Object)entry.getValue().PeriParaTreeApply);
            GeneralPeriVariables.GeneralPeriParaObjectList.put(entry.getKey(), obj);
            GeneralPeriConfigUtil.NewInitPeriConfigInfo(entry.getKey());
            GlobalVariables.PeriParaTreeObj.put(entry.getKey(), obj.PeriParaTreeApply);
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            GeneralPeriParaObjectList = (Map)ins.readObject();
            GlobalVariables.PeriParaTreeObj = (Map)ins.readObject();
            GlobalVariables.PeriConfigViewObj = (PeriConfigViewStruct)ins.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void UpdatePeriConfigInfo(String PeriName) {
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(PeriName)) {
            if (!GlobalVariables.PeripheralTreeMap.containsKey(PeriName)) {
                GeneralPeriVariables.GeneralPeriParaObjectList.remove(PeriName);
            }
        } else if (GlobalVariables.PeripheralTreeMap.containsKey(PeriName)) {
            com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject object = new com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject(PeriName);
            GeneralPeriVariables.GeneralPeriParaObjectList.put(PeriName, object);
        }
    }

    public static void InitPeriConfigInfo(String PeriName) {
        LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
        if (!modules_map.containsKey(PeriName)) {
            return;
        }
        String moduleType = ((ModuleStruct)modules_map.get(PeriName)).getModuleType();
        if (moduleType.equals("MiddleWare")) {
            LinkedHashMap periTypeGroupMap = GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap();
            PeriConfigGroupStruct periConfigGroupStruct = (PeriConfigGroupStruct)periTypeGroupMap.get("MiddleWare");
            LinkedHashMap NodeList2 = periConfigGroupStruct.getNodeList();
            PeriConfigViewNodeStruct periConfigViewNodeStruct = (PeriConfigViewNodeStruct)NodeList2.get(PeriName);
            LinkedHashMap TabList = periConfigViewNodeStruct.getTabList();
            for (String key : TabList.keySet()) {
                GeneralPeriConfigUtil.PeriConfigInfo(key, PeriName);
            }
        } else if (moduleType.equals("Peripheral")) {
            GeneralPeriConfigUtil.PeriConfigInfo(PeriName, "");
        }
    }

    public static void NewInitPeriConfigInfo(String PeriName) {
        LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
        if (!modules_map.containsKey(PeriName)) {
            return;
        }
        String moduleType = ((ModuleStruct)modules_map.get(PeriName)).getModuleType();
        if (moduleType.equals("MiddleWare")) {
            LinkedHashMap periTypeGroupMap = GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap();
            PeriConfigGroupStruct periConfigGroupStruct = (PeriConfigGroupStruct)periTypeGroupMap.get("MiddleWare");
            LinkedHashMap NodeList2 = periConfigGroupStruct.getNodeList();
            PeriConfigViewNodeStruct periConfigViewNodeStruct = (PeriConfigViewNodeStruct)NodeList2.get(PeriName);
            LinkedHashMap TabList = periConfigViewNodeStruct.getTabList();
            for (String key : TabList.keySet()) {
                GeneralPeriParaXmlParse.ParseGeneralPeriXML(key, PeriName);
            }
        } else if (moduleType.equals("Peripheral")) {
            GeneralPeriParaXmlParse.ParseGeneralPeriXML(PeriName, "");
        }
    }

    public static void PeriConfigInfo(String PeriName, String middleWareName) {
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(PeriName)) {
            if (((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName)).PeriParaTreeApply == null) {
                GeneralPeriParaXmlParse.ParseGeneralPeriXML(PeriName, middleWareName);
            }
        } else {
            com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject object = new com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject(PeriName);
            GeneralPeriVariables.GeneralPeriParaObjectList.put(PeriName, object);
            if (((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName)).PeriParaTreeApply == null) {
                GeneralPeriParaXmlParse.ParseGeneralPeriXML(PeriName, middleWareName);
            }
        }
    }

    public static void traverseCopyTreeNodeNoUI(AbstractJTreeNode dstTreeNode, AbstractJTreeNode srcTreeNode) {
        if (dstTreeNode == null || srcTreeNode == null) {
            return;
        }
        int i = 0;
        while (i < srcTreeNode.getChildCount()) {
            AbstractJTreeNode srcChildNode = (AbstractJTreeNode)srcTreeNode.getChildAt(i);
            AbstractJTreeNode dstChildNode = (AbstractJTreeNode)dstTreeNode.getChildAt(i);
            srcChildNode.copyToTreeNodeNoUI(dstChildNode);
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(dstChildNode, srcChildNode);
            ++i;
        }
    }

    public static void CheckPeriConfigPrivilege() {
        ArrayList<String> MultiplePeriList = new ArrayList<String>();
        for (String key : GlobalVariables.PeripheralConfigObjMap.keySet()) {
            if (MultiplePeriList.contains(key = GlobalVariables.GetMultipleTreePeriName((String)key))) continue;
            MultiplePeriList.add(key);
            GeneralPeriConfigUtil.InitPeriConfigInfo(key);
            if (((ModuleStruct)GlobalVariables.MCUObj.getModules().get(key)).getModuleType().equals("Peripheral")) {
                ConflictExecute.initPeriConfigConflict((String)key);
                GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)key)).PeriParaTreeApply, (AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(key));
            }
            if (!((ModuleStruct)GlobalVariables.MCUObj.getModules().get(key)).getModuleType().equals("MiddleWare")) continue;
            LinkedHashMap periTypeGroupMap = GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap();
            PeriConfigGroupStruct periConfigGroupStruct = (PeriConfigGroupStruct)periTypeGroupMap.get("MiddleWare");
            LinkedHashMap NodeList2 = periConfigGroupStruct.getNodeList();
            PeriConfigViewNodeStruct periConfigViewNodeStruct = (PeriConfigViewNodeStruct)NodeList2.get(key);
            LinkedHashMap TabList = periConfigViewNodeStruct.getTabList();
            for (String keyTab : TabList.keySet()) {
                ConflictExecute.initPeriConfigConflict((String)keyTab);
                GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)keyTab)).PeriParaTreeApply, (AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(keyTab));
            }
        }
        GeneralPeriConfigUtil.InitPeriConfigInfo("RCU");
        RCUTreeView.UpdateView((boolean)false);
        ConflictExecute.initPeriConfigConflict((String)"RCU");
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey("RCU")) {
            GeneralPeriConfigUtil.CheckTreeNodePrivilege("RCU", ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)"RCU")).PeriParaTreeApply);
        }
    }

    public static void UpdateComboxValueAndDefaultValue(AbstractJTreeNode Root, String PeriName) {
        if (Root == null) {
            return;
        }
        if (Root.getChildCount() >= 0) {
            int i = Root.getChildCount() - 1;
            while (i >= 0) {
                AbstractJTreeNode ChildNode = (AbstractJTreeNode)Root.getChildAt(i);
                String GroupName = null;
                GroupName = GeneralPeriConfigUtil.GetGroupName(ChildNode, GroupName);
                if (ChildNode.getType() == 2) {
                    ((JTreeComboxNode)ChildNode).updateValueAndDefaultValue();
                }
                GeneralPeriConfigUtil.UpdateComboxValueAndDefaultValue(ChildNode, PeriName);
                --i;
            }
        }
    }

    public static void CheckTreeNodePrivilege(String PeriName, AbstractJTreeNode Root) {
        AbstractJTreeNode PeriParaTree = (AbstractJTreeNode)Root.getRoot();
        if (Root.getChildCount() >= 0) {
            int i = Root.getChildCount() - 1;
            while (i >= 0) {
                AbstractJTreeNode ChildNode = (AbstractJTreeNode)Root.getChildAt(i);
                String GroupName = null;
                GroupName = GeneralPeriConfigUtil.GetGroupName(ChildNode, GroupName);
                if (ChildNode.isVisible()) {
                    String ControlName = ChildNode.getName();
                    if (ChildNode.getType() == 1) {
                        if (((JTreeCheckboxNode)ChildNode).getJCheckBox().isSelected()) {
                            PrivilegeInfoExecute.ExecutePrivilege(0, PeriName, GroupName, ControlName, null, true, PeriParaTree);
                        }
                    } else if (ChildNode.getType() == 2) {
                        String ValueContent = ((JTreeComboxNode)ChildNode).getJComboBox().getSelectedItem().toString();
                        PrivilegeInfoExecute.ExecutePrivilege(0, PeriName, GroupName, ControlName, ValueContent, true, PeriParaTree);
                    } else {
                        ChildNode.getType();
                    }
                    GeneralPeriConfigUtil.CheckTreeNodePrivilege(PeriName, ChildNode);
                }
                --i;
            }
        }
    }

    public static String GetGroupName(AbstractJTreeNode Node2, String GroupName) {
        AbstractJTreeNode ParentNode = (AbstractJTreeNode)Node2.getParent();
        if (ParentNode.getParent() != null) {
            GroupName = GroupName == null ? ParentNode.getName() : String.valueOf(ParentNode.getName()) + "##" + GroupName;
            GroupName = GeneralPeriConfigUtil.GetGroupName(ParentNode, GroupName);
        }
        return GroupName;
    }

    public static String GetVarMacro(String RelateFrom, String PeriName, String ParentNode, String ControlName) {
        String DstMacro = null;
        if (RelateFrom.equals("2")) {
            DstMacro = GeneralPeriConfigUtil.GetVarMacrofromClockTree(ControlName);
        } else if (RelateFrom.equals("0")) {
            DstMacro = GeneralPeriConfigUtil.GetVarMacrofromPeriConfig(ParentNode, ControlName, ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName)).PeriParaTreeApply, false);
        } else if (RelateFrom.equals("4")) {
            DstMacro = NVICConfigUtil.GetVarMacro(PeriName, ParentNode, ControlName);
        }
        return DstMacro;
    }

    private static String GetVarMacrofromClockTree(String ControlName) {
        String DstMacro = RCUTreeUtil.GetControlMacrofromClockTree((String)ControlName);
        return DstMacro;
    }

    public static String GetVarMacrofromPeriConfig(String ParentPath, String ControlName, AbstractJTreeNode PeriParaTree, boolean IfContent) {
        AbstractJTreeNode tempNode;
        if (ControlName.contains("[*]")) {
            int index = ControlName.lastIndexOf("[");
            tempNode = GeneralPeriConfigUtil.GetTreeNodeDependNodePath(PeriParaTree, ParentPath, ControlName = ControlName.substring(0, index), true, IfContent);
            if (tempNode == null) {
                return "%InvalidValue%";
            }
        } else {
            tempNode = GeneralPeriConfigUtil.GetTreeNodeDependNodePath(PeriParaTree, ParentPath, ControlName, false, IfContent);
        }
        if (tempNode != null) {
            int type = tempNode.getType();
            String value = tempNode.getValue();
            if (type == ConstantsUtil.ControlType.Combox.ordinal()) {
                value = ((JTreeComboxNode)tempNode).getValueDependItemContent(value);
            }
            if (!tempNode.isVisible()) {
                value = "%InvalidValue%";
            } else if (!GeneralPeriConfigUtil.getNodeVisibleState(tempNode, tempNode.isVisible())) {
                value = "%InvalidValue%";
            }
            return value;
        }
        System.out.println(" Node null: " + ParentPath + " " + ControlName);
        return "";
    }

    private static boolean getNodeVisibleState(AbstractJTreeNode Node2, boolean NodeVisibleState) {
        AbstractJTreeNode parentNode = (AbstractJTreeNode)Node2.getParent();
        if (Node2.getParent() != null) {
            if (!parentNode.isVisible()) {
                return false;
            }
            return GeneralPeriConfigUtil.getNodeVisibleState(parentNode, NodeVisibleState);
        }
        return NodeVisibleState;
    }

    public static AbstractJTreeNode GetTreeNodeDependNodePath(AbstractJTreeNode RootNode, String ParentPath, String NodeName, boolean IfNeedVisible, boolean IfContent) {
        if (RootNode != null) {
            if (ParentPath == null || ParentPath.equals("")) {
                return GeneralPeriConfigUtil.GetTreeNodeDependNodeName(RootNode, NodeName, IfNeedVisible, IfContent);
            }
            AbstractJTreeNode parentNode = RootNode;
            String[] pathArray = ParentPath.split("##");
            int i = 0;
            while (i < pathArray.length) {
                AbstractJTreeNode pNode;
                parentNode = pNode = GeneralPeriConfigUtil.GetTreeNodeDependNodeName(parentNode, pathArray[i], IfNeedVisible, IfContent);
                ++i;
            }
            return GeneralPeriConfigUtil.GetTreeNodeDependNodeName(parentNode, NodeName, IfNeedVisible, IfContent);
        }
        return null;
    }

    public static AbstractJTreeNode GetTreeNodeDependNodePath(AbstractJTreeNode RootNode, String NodePath, boolean IfNeedVisible, boolean IfContent) {
        if (RootNode != null) {
            AbstractJTreeNode Node2 = RootNode;
            String[] pathArray = NodePath.split("##");
            int i = 0;
            while (i < pathArray.length) {
                AbstractJTreeNode pNode;
                Node2 = pNode = GeneralPeriConfigUtil.GetTreeNodeDependNodeName(Node2, pathArray[i], IfNeedVisible, IfContent);
                ++i;
            }
            return Node2;
        }
        return null;
    }

    public static AbstractJTreeNode GetTreeNodeDependNodeName(AbstractJTreeNode RootNode, String NodeName, boolean IfNeedVisible, boolean IfContent) {
        if (RootNode != null) {
            Enumeration e = RootNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                AbstractJTreeNode n = (AbstractJTreeNode)e.nextElement();
                if (IfContent) {
                    if (!(IfNeedVisible ? n.getContent().equals(NodeName) && n.isVisible() : n.getContent().equals(NodeName))) continue;
                    return n;
                }
                String NameMaster = n.getName();
                int i = NameMaster.length() - 1;
                while (i >= 0) {
                    if (!Character.isDigit(NameMaster.charAt(i))) {
                        NameMaster = NameMaster.substring(0, i + 1);
                        break;
                    }
                    --i;
                }
                if (IfNeedVisible) {
                    if (!n.isVisible()) continue;
                    if (n.getName().equals(NodeName)) {
                        return n;
                    }
                    if (!n.getName().contains(NodeName) || !NodeName.equals(NameMaster)) continue;
                    return n;
                }
                if (n.getName().equals(NodeName)) {
                    return n;
                }
                if (!n.getName().contains(NodeName) || !NodeName.equals(NameMaster)) continue;
                return n;
            }
        }
        return null;
    }

    public static String unescapeJavaString(String str) {
        StringBuilder sbuild = new StringBuilder(str.length());
        int length = str.length();
        int i = 0;
        while (i < length) {
            char ch = str.charAt(i);
            if (ch == '\\' && i < length) {
                char nextChar = str.charAt(i + 1);
                switch (nextChar) {
                    case '\\': {
                        sbuild.append('\\');
                        ++i;
                        break;
                    }
                    case 't': {
                        sbuild.append('\t');
                        ++i;
                        break;
                    }
                    case 'b': {
                        sbuild.append('\b');
                        ++i;
                        break;
                    }
                    case 'n': {
                        sbuild.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        sbuild.append('\r');
                        ++i;
                        break;
                    }
                    case 'f': {
                        sbuild.append('\f');
                        ++i;
                        break;
                    }
                    case '\'': {
                        sbuild.append('\'');
                        ++i;
                        break;
                    }
                    case '\"': {
                        sbuild.append('\"');
                        ++i;
                        break;
                    }
                    case 'u': {
                        if (i + 5 < length) {
                            String unicode = str.substring(i + 2, i + 6);
                            sbuild.append((char)Integer.parseInt(unicode, 16));
                            i += 5;
                            break;
                        }
                        sbuild.append(ch);
                        break;
                    }
                    default: {
                        sbuild.append(ch);
                        break;
                    }
                }
            } else {
                sbuild.append(ch);
            }
            ++i;
        }
        return sbuild.toString();
    }

    public static double convertStringToDouble(String str) {
        try {
            double value = Double.parseDouble(str);
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid string format for double conversion: " + str, e);
        }
    }

    public static int getDecimalPlaces(String value) throws NumberFormatException {
        Double.parseDouble(value);
        int index = value.indexOf(46);
        if (index >= 0) {
            return value.length() - index - 1;
        }
        return 0;
    }

    private static boolean isValidInteger(String value, String regex) {
        if (value.isEmpty()) {
            return false;
        }
        return value.matches(regex);
    }

    private static boolean isValidHexadecimal(String value, String regex) {
        return value.startsWith("0x") && value.substring(2).matches(regex);
    }

    private static boolean checkFractionDigits(String value, JTreeTextNode node) {
        try {
            if (node.ifHasFractionDigits()) {
                int requiredFractionDigits;
                int decimalPlaces = GeneralPeriConfigUtil.getDecimalPlaces(value);
                return decimalPlaces == (requiredFractionDigits = Integer.parseInt(node.getEditFractionDigits()));
            }
            if (node.ifHasMaxFractionDigits()) {
                int maxFractionDigits;
                int decimalPlaces = GeneralPeriConfigUtil.getDecimalPlaces(value);
                return decimalPlaces <= (maxFractionDigits = Integer.parseInt(node.getMaxEditFractionDigits()));
            }
            if (node.ifHasMinFractionDigits()) {
                int minFractionDigits;
                int decimalPlaces = GeneralPeriConfigUtil.getDecimalPlaces(value);
                return decimalPlaces >= (minFractionDigits = Integer.parseInt(node.getMinEditFractionDigits()));
            }
            if (node.ifHasMaxMinFractionDigits()) {
                int decimalPlaces = GeneralPeriConfigUtil.getDecimalPlaces(value);
                int minFractionDigits = Integer.parseInt(node.geMaxtMinEditFractionDigits()[0]);
                int maxFractionDigits = Integer.parseInt(node.geMaxtMinEditFractionDigits()[1]);
                return decimalPlaces >= minFractionDigits && decimalPlaces <= maxFractionDigits;
            }
            return node.ifHasValidFractionDigits();
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private static boolean isValidFloat(String value, String regex, JTreeTextNode node) {
        if (!value.matches(regex)) {
            return false;
        }
        return GeneralPeriConfigUtil.checkFractionDigits(value, node);
    }

    private static boolean matchesCustomRegex(String value, JTreeTextNode node) {
        if (node.ifHasRegExp()) {
            String dataRegex = GeneralPeriConfigUtil.unescapeJavaString(node.getEditRegex());
            return value.matches(dataRegex);
        }
        return true;
    }

    private static EditReturnType evaluateValueRange(String value, JTreeTextNode node) {
        try {
            if (GeneralPeriConfigUtil.checkEditValueRange(value, node)) {
                return EditReturnType.LEGITIMATE;
            }
            return EditReturnType.OUTOFRANGE;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return EditReturnType.ILLEGAL;
        }
    }

    private static EditReturnType handleHexValue(String value, JTreeTextNode node, String regex16) {
        if (value.toLowerCase().contains("0x") && value.startsWith("0x") && (value = value.substring(2)).matches(regex16)) {
            return GeneralPeriConfigUtil.evaluateValueRange(value, node);
        }
        return EditReturnType.ILLEGAL;
    }

    private static EditReturnType validateAndCheckRange(String value, JTreeTextNode node) {
        try {
            if (GeneralPeriConfigUtil.checkFractionDigits(value, node)) {
                return GeneralPeriConfigUtil.evaluateValueRange(value, node);
            }
            return EditReturnType.ILLEGAL;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return EditReturnType.ILLEGAL;
        }
    }

    public static EditReturnType checkEditLegality(String value, JTreeTextNode node) {
        String regexF;
        String regexI;
        String regexF_I;
        String regex16;
        String DefaultValue;
        block27: {
            String ControlType2;
            DefaultValue = node.getDefaultValue();
            regex16 = "[A-Fa-f0-9]+$";
            regexF_I = "^-?\\d+(\\.\\d+)?$";
            regexI = "^-?(?:[1-9]\\d*|0)$";
            regexF = "^-?\\d*\\.\\d+$";
            if (!node.ifHasControlType()) break block27;
            switch (ControlType2 = node.getControlType()) {
                case "Int-Dec": {
                    if (GeneralPeriConfigUtil.isValidInteger(value, regexI)) {
                        return GeneralPeriConfigUtil.evaluateValueRange(value, node);
                    }
                    return EditReturnType.ILLEGAL;
                }
                case "Int-Hex": {
                    if (GeneralPeriConfigUtil.isValidHexadecimal(value, regex16)) {
                        value = value.substring(2);
                        return GeneralPeriConfigUtil.evaluateValueRange(value, node);
                    }
                    return EditReturnType.ILLEGAL;
                }
                case "Float": {
                    if (GeneralPeriConfigUtil.isValidFloat(value, regexF_I, node)) {
                        return GeneralPeriConfigUtil.evaluateValueRange(value, node);
                    }
                    return EditReturnType.ILLEGAL;
                }
                case "String": {
                    if (GeneralPeriConfigUtil.matchesCustomRegex(value, node)) {
                        return GeneralPeriConfigUtil.evaluateValueRange(value, node);
                    }
                    return EditReturnType.ILLEGAL;
                }
            }
            return EditReturnType.OTHERILLEGAL;
        }
        if (DefaultValue.toLowerCase().contains("0x") && !node.ifHasRegExp()) {
            return GeneralPeriConfigUtil.handleHexValue(value, node, regex16);
        }
        if (node.ifHasRegExp()) {
            String dataRegex = GeneralPeriConfigUtil.unescapeJavaString(node.getEditRegex());
            if (DefaultValue.matches(dataRegex) && value.matches(dataRegex)) {
                return GeneralPeriConfigUtil.validateAndCheckRange(value, node);
            }
            return EditReturnType.ILLEGAL;
        }
        if (DefaultValue.matches(regexF)) {
            if (value.matches(regexF_I)) {
                return GeneralPeriConfigUtil.validateAndCheckRange(value, node);
            }
            return EditReturnType.ILLEGAL;
        }
        if (DefaultValue.matches(regexI)) {
            if (value.matches(regexI)) {
                return GeneralPeriConfigUtil.evaluateValueRange(value, node);
            }
            return EditReturnType.ILLEGAL;
        }
        return GeneralPeriConfigUtil.validateAndCheckRange(value, node);
    }

    public static boolean checkEditValueRange(String value, JTreeTextNode node) {
        int tempValueLength;
        if (value.isEmpty()) {
            return false;
        }
        BigDecimal tempValue = null;
        try {
            if (node.ifHasMax() || node.ifHasMin()) {
                tempValue = GeneralPeriConfigUtil.parseValueToBigDecimal(value, node.getDefaultValue().toLowerCase().contains("0x"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("\u93c3\u72b3\u7876\u704f\u55d7\u74e7\u7ed7\ufe3f\u8986\u7459\uff46\u703d\u6d93\u70d8\u669f\u934a\u7877\u7d30" + value + "\u951b\u5c7d\u76a2\u6769\u6d9c\ue511\u701b\u6943\ue0c1\u6d93\u67e5\u66b1\u6434\ufe3d\ue5c5\u93cc\u30e3\ufffd\ufffd");
            int tempValueLength2 = value.getBytes().length;
            return GeneralPeriConfigUtil.checkStringLengthRange(tempValueLength2, node);
        }
        int n = tempValueLength = value.toLowerCase().startsWith("0x") ? value.substring(2).getBytes().length : value.getBytes().length;
        if (tempValue != null) {
            return GeneralPeriConfigUtil.checkNumericRange(tempValue, node) && GeneralPeriConfigUtil.checkStringLengthRange(tempValueLength, node);
        }
        return GeneralPeriConfigUtil.checkStringLengthRange(tempValueLength, node);
    }

    private static BigDecimal parseValueToBigDecimal(String value, boolean isHex) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null or empty");
        }
        try {
            if (isHex) {
                if (value.toLowerCase().startsWith("0x")) {
                    value = value.substring(2);
                }
                return new BigDecimal(new BigInteger(value, 16));
            }
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number format for value: " + value, e);
        }
    }

    private static boolean checkNumericRange(BigDecimal tempValue, JTreeTextNode node) {
        if (tempValue == null) {
            throw new IllegalArgumentException("tempValue cannot be null");
        }
        BigDecimal editMax = null;
        BigDecimal editMin = null;
        try {
            String minStr;
            String maxStr;
            if (node.ifHasMax() && (maxStr = node.getMaxStr()) != null && !maxStr.isEmpty() && !maxStr.equals("/")) {
                editMax = GeneralPeriConfigUtil.parseValueToBigDecimal(maxStr, maxStr.trim().toLowerCase().startsWith("0x"));
            }
            if (node.ifHasMin() && (minStr = node.getMinStr()) != null && !minStr.isEmpty() && !minStr.equals("/")) {
                editMin = GeneralPeriConfigUtil.parseValueToBigDecimal(minStr, minStr.trim().toLowerCase().startsWith("0x"));
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error parsing range boundaries: " + e.getMessage());
            return false;
        }
        if (editMax != null && tempValue.compareTo(editMax) > 0) {
            return false;
        }
        return editMin == null || tempValue.compareTo(editMin) >= 0;
    }

    private static boolean checkStringLengthRange(int tempValueLength, JTreeTextNode node) {
        if (!node.ifHasValidStrLength()) {
            return false;
        }
        if (node.ifHasStrLength()) {
            int fixedLength = Integer.parseInt(node.getEditByteLength());
            if (tempValueLength != fixedLength) {
                return false;
            }
        } else if (node.ifHasMaxMinStrLength()) {
            String[] lengthBounds = node.geMaxtMinEditByteLength();
            int minByteLength = Integer.parseInt(lengthBounds[0]);
            int maxByteLength = Integer.parseInt(lengthBounds[1]);
            if (tempValueLength < minByteLength || tempValueLength > maxByteLength) {
                return false;
            }
        } else {
            Integer minByteLength;
            Integer maxByteLength = node.ifHasMaxStrLength() ? Integer.valueOf(Integer.parseInt(node.getMaxEditByteLength())) : null;
            Integer n = minByteLength = node.ifHasMinStrLength() ? Integer.valueOf(Integer.parseInt(node.getMinEditByteLength())) : null;
            if (maxByteLength != null && tempValueLength > maxByteLength || minByteLength != null && tempValueLength < minByteLength) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean CheckPeriConfigValuesLegality(Map<String, Map<String, String>> periParaInvalidMap) {
        boolean IfAllLegal = false;
        for (String key : GlobalVariables.PeriParaTreeObj.keySet()) {
            String peri = key;
            if (!GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(peri)) continue;
            AbstractJTreeNode PeriParaTree = ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)peri)).PeriParaTreeApply;
            HashMap<String, String> invalidMap = new HashMap<String, String>();
            GeneralPeriConfigUtil.DetectIllegalValuesTraverseTree(PeriParaTree, invalidMap);
            if (invalidMap.size() == 0) continue;
            periParaInvalidMap.put(peri, invalidMap);
        }
        if (periParaInvalidMap.size() == 0) {
            IfAllLegal = true;
        }
        return IfAllLegal;
    }

    public static void ClearMiddleWareAllGlobalVars(String periName) {
        LinkedHashMap periTypeGroupMap = GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap();
        PeriConfigGroupStruct periConfigGroupStruct = (PeriConfigGroupStruct)periTypeGroupMap.get("MiddleWare");
        LinkedHashMap NodeList2 = periConfigGroupStruct.getNodeList();
        PeriConfigViewNodeStruct periConfigViewNodeStruct = (PeriConfigViewNodeStruct)NodeList2.get(periName);
        LinkedHashMap TabList = periConfigViewNodeStruct.getTabList();
        for (String key : TabList.keySet()) {
            GeneralPeriVariables.GeneralPeriParaObjectList.remove(key);
            GlobalVariables.PeriParaTreeObj.remove(key);
        }
    }

    public static void ClearPeriMiddleWarerUserConfigVars(String periName) {
        LinkedHashMap periTypeGroupMap = GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap();
        PeriConfigGroupStruct periConfigGroupStruct = (PeriConfigGroupStruct)periTypeGroupMap.get("MiddleWare");
        LinkedHashMap NodeList2 = periConfigGroupStruct.getNodeList();
        PeriConfigViewNodeStruct periConfigViewNodeStruct = (PeriConfigViewNodeStruct)NodeList2.get(periName);
        LinkedHashMap TabList = periConfigViewNodeStruct.getTabList();
        for (String key : TabList.keySet()) {
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)key)).PeriParaTreeApply, ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)key)).PeriParaTreeXml);
            GeneralPeriConfigUtil.traverseCopyTreeNodeNoUI((AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(key), ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)key)).PeriParaTreeXml);
        }
    }

    private static void DetectIllegalValuesTraverseTree(AbstractJTreeNode periParaTree, Map<String, String> invalidMap) {
        if (periParaTree == null) {
            return;
        }
        if (periParaTree.getChildCount() >= 0) {
            int i = 0;
            while (i < periParaTree.getChildCount()) {
                AbstractJTreeNode ChildNode = (AbstractJTreeNode)periParaTree.getChildAt(i);
                if (ChildNode.isVisible()) {
                    boolean invalid = false;
                    String value = ChildNode.getValue();
                    if (ChildNode.getType() == ConstantsUtil.ControlType.Edit.ordinal()) {
                        if (GeneralPeriConfigUtil.checkEditLegality(value, (JTreeTextNode)ChildNode) != EditReturnType.LEGITIMATE || ChildNode.isError()) {
                            invalid = true;
                        }
                    } else if (ChildNode.isError()) {
                        invalid = true;
                    }
                    if (invalid) {
                        String GroupName = null;
                        GroupName = GeneralPeriConfigUtil.GetGroupName(ChildNode, GroupName);
                        String NodePath = String.valueOf(GroupName) + "##" + ChildNode.getName();
                        invalidMap.put(NodePath, value);
                    }
                    GeneralPeriConfigUtil.DetectIllegalValuesTraverseTree(ChildNode, invalidMap);
                }
                ++i;
            }
        }
    }

    public static void executeCrossPeriConflictBaseConfig(String periName) {
        HashMap<String, String> periConfiInfo = new HashMap<String, String>();
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey(periName) && GlobalVariables.PeriParaTreeObj.containsKey(periName)) {
            GeneralPeriConfigUtil.CompareGeneralPeriPara(((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)periName)).PeriParaTreeApply, (AbstractJTreeNode)GlobalVariables.PeriParaTreeObj.get(periName), periConfiInfo);
        }
        for (Map.Entry entry : periConfiInfo.entrySet()) {
            String itemName = (String)entry.getValue();
            String key = (String)entry.getKey();
            String[] parts = key.split("##");
            if (parts.length < 2) continue;
            String controlName = parts[parts.length - 1];
            StringBuilder groupNameBuilder = new StringBuilder();
            int i = 0;
            while (i < parts.length - 1) {
                groupNameBuilder.append(parts[i]);
                if (i < parts.length - 2) {
                    groupNameBuilder.append("##");
                }
                ++i;
            }
            String groupName = groupNameBuilder.toString();
            ConflictExecute.crossPeriConflictExecuteByPeriConfig((String)periName, (String)groupName, (String)controlName, (String)itemName, (boolean)true);
        }
    }

    public static void CheckSpecialPeriPrivilege() {
        RCUTreeView.UpdateView((boolean)false);
        ConflictExecute.initPeriConfigConflict((String)"RCU");
        if (GeneralPeriVariables.GeneralPeriParaObjectList.containsKey("RCU")) {
            GeneralPeriConfigUtil.CheckTreeNodePrivilege("RCU", ((com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)"RCU")).PeriParaTreeApply);
        }
    }

    public static enum EditReturnType {
        ILLEGAL(-1),
        OTHERILLEGAL(0),
        LEGITIMATE(1),
        OUTOFRANGE(2);

        private final int value;

        private EditReturnType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

