/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.periconfigview.baseinfo.systemperi.GPIOConfigCtrlStruct;
import com.gigadevice.periconfigview.baseinfo.systemperi.GPIOConfigInfo;
import com.gigadevice.periconfigview.baseinfo.systemperi.GPIORulesStruct;
import com.gigadevice.periconfigview.utils.NumberStringComparator;
import com.gigadevice.periconfigview.utils.PerisConfigUtil;
import com.gigadevice.periconfigview.xmlparse.GPIOConfigXMLParse;
import com.gigadevice.periconfigview.xmlparse.PeriConfigXMLParse;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.GD32PinPad;
import com.gigadevice.venustool.controlconflict.ControlConflict;
import com.gigadevice.venustool.gpio.GPIOInfoUtil;
import com.gigadevice.venustool.gpio.GPIOVariables;
import com.gigadevice.venustool.mcubasestruct.ItemStruct;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import com.gigadevice.venustool.mcubasestruct.WidgetNodeStruct;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class GPIOConfigUtil {
    public static Map<String, GPIOConfigInfo> GPIOXMLRegularMap = new HashMap<String, GPIOConfigInfo>();
    public static Map<String, String> GPIOXMLCodeDefineMap = new HashMap<String, String>();
    public static Map<String, Map<String, Vector<String>>> GPIORestoreConfigInfoMap = new HashMap<String, Map<String, Vector<String>>>();
    public static Map<String, Map<String, Vector<String>>> GPIOConfigInfoMapTemp = new HashMap<String, Map<String, Vector<String>>>();
    public static Map<String, List<String>> GPIOXMLRemapMap = new HashMap<String, List<String>>();
    public static Map<String, String> GPIOConfigPinOnCore = new HashMap<String, String>();
    public static List<GPIOConfigCtrlStruct> lstConfigControls = new ArrayList<GPIOConfigCtrlStruct>();
    private static Map<String, List<String>> ComboBoxItemsMap = new HashMap<String, List<String>>();
    public static Map<String, Map<String, List<String>>> PinComboBoxItemsMap = new HashMap<String, Map<String, List<String>>>();
    public static Map<String, Map<String, Map<String, String>>> mapPinUserConfig = new HashMap<String, Map<String, Map<String, String>>>();
    public static Map<String, Map<String, Map<String, String>>> mapPinUserConfigTemp = new HashMap<String, Map<String, Map<String, String>>>();
    private static Map<String, Map<String, String>> pinConfigObjDefault = new HashMap<String, Map<String, String>>();
    public static final String STR_SERIALIZE = "GPIOCONFIG";
    public static final String SERIALIZE_INFO = "CONFIGINFO";
    public static final String SERIALIZE_CORE = "MULTICORE";
    static Map<String, Map<String, String>> mapDecodingInfo = new HashMap<String, Map<String, String>>();

    public static void UpdatePeriConfigInfo() {
        if (GPIOXMLRegularMap.size() <= 0) {
            GPIOConfigUtil.GPIOXMLInfoParse();
            if (GPIOXMLRegularMap.size() <= 0) {
                return;
            }
        }
        for (GD32PinPad PinPad : PerisConfigUtil.DeletePinList) {
            Map<String, Map<String, String>> mapConfig;
            String strPinName;
            String strModuleName = "";
            strModuleName = PinPad.getPinUsedType() == 1 || PinPad.getPinUsedFunctionStr().contains("EXTI") || PinPad.getPinUsedFunctionStr().contains("IFRP") ? "GPIO" : PinPad.getPinUsedPeri().toUpperCase();
            if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strModuleName)) {
                Map TableData = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strModuleName);
                if (TableData.containsKey(strPinName = PinPad.getPinName())) {
                    TableData.remove(strPinName);
                }
                if (TableData.size() <= 0) {
                    GPIOInfoUtil.GPIOConfigInfoMap.remove(strModuleName);
                }
            }
            if (mapPinUserConfig.containsKey(strModuleName)) {
                mapConfig = mapPinUserConfig.get(strModuleName);
                if (mapConfig.containsKey(strPinName = PinPad.getPinName())) {
                    mapConfig.remove(strPinName);
                }
                if (mapConfig.size() <= 0) {
                    mapPinUserConfig.remove(strModuleName);
                }
            }
            if (!mapPinUserConfigTemp.containsKey(strModuleName)) continue;
            mapConfig = mapPinUserConfigTemp.get(strModuleName);
            if (mapConfig.containsKey(strPinName = PinPad.getPinName())) {
                mapConfig.remove(strPinName);
            }
            if (mapConfig.size() > 0) continue;
            mapPinUserConfigTemp.remove(strModuleName);
        }
        for (GD32PinPad PinPad : PerisConfigUtil.AddPinList) {
            if (GPIOVariables.GPIONoCodeSignal.size() == 0 && GPIOVariables.GPIONoCodePin.size() == 0 && GPIOVariables.GPIOSharePin.size() == 0) {
                GPIOVariables.GetGPIONoCodeInfo();
            }
            String strPinName = PinPad.getPinName();
            String strSignal = PinPad.getPinUsedFunctionStr();
            if (GPIOVariables.GPIONoCodeSignal.contains(strSignal) || GPIOVariables.GPIONoCodePin.contains(strPinName)) continue;
            String strModuleName = "";
            strModuleName = PinPad.getPinUsedType() == 1 || PinPad.getPinUsedFunctionStr().contains("EXTI") || PinPad.getPinUsedFunctionStr().contains("IFRP") ? "GPIO" : PinPad.getPinUsedPeri().toUpperCase();
            if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strModuleName)) {
                Vector<String> RowData = GPIOConfigUtil.GetTableRowData(PinPad, strModuleName);
                Map TableData = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strModuleName);
                TableData.put(strPinName, RowData);
                continue;
            }
            HashMap<String, Vector<String>> TableData = new HashMap<String, Vector<String>>();
            Vector<String> RowData = GPIOConfigUtil.GetTableRowData(PinPad, strModuleName);
            TableData.put(strPinName, RowData);
            GPIOInfoUtil.GPIOConfigInfoMap.put(strModuleName, TableData);
        }
        PerisConfigUtil.AddPinList.clear();
        PerisConfigUtil.DeletePinList.clear();
        GPIORestoreConfigInfoMap = (Map)GlobalVariables.cloneFrom((Object)GPIOInfoUtil.GPIOConfigInfoMap);
    }

    public static void GPIOXMLInfoParse() {
        GlobalPathUtil.SysPeriXmlPaths sysPeriXmlPathsObj = GlobalPathUtil.getSysPeriXmlPaths();
        String GPIOUIXmlPath = sysPeriXmlPathsObj.GPIOConfigUIXmlPath;
        String GPIOXmlPath = sysPeriXmlPathsObj.GPIOConfigXmlPath;
        String remapXmlPath = sysPeriXmlPathsObj.GPIORemapXmlPath;
        if (lstConfigControls.size() <= 0) {
            GPIOConfigXMLParse.parseGPIOUIXML(GPIOUIXmlPath);
        }
        if (GPIOXMLRegularMap.size() <= 0) {
            GPIOConfigXMLParse.parseGPIOXML(GPIOXmlPath, GPIOXMLRegularMap);
        }
        if (GlobalVariables.gd32mcuObj.getisRemap()) {
            PeriConfigXMLParse.parseGPIORemapXML(remapXmlPath, GPIOXMLRemapMap);
        }
    }

    public static void ClearUserConfigVars() {
        GPIOInfoUtil.GPIOConfigInfoMap.clear();
        GPIORestoreConfigInfoMap.clear();
        GPIOConfigInfoMapTemp.clear();
        mapPinUserConfig.clear();
        GPIOConfigPinOnCore.clear();
    }

    public static void ClearAllGlobalVars() {
        GPIOInfoUtil.GPIOConfigInfoMap.clear();
        GPIORestoreConfigInfoMap.clear();
        GPIOConfigInfoMapTemp.clear();
        GPIOXMLRegularMap.clear();
        GPIOXMLCodeDefineMap.clear();
        PinComboBoxItemsMap.clear();
        mapPinUserConfig.clear();
        GPIOConfigPinOnCore.clear();
        GPIOInfoUtil.mapGPIOConfigObjsIndex.clear();
        lstConfigControls.clear();
    }

    public static void InitAllGlobalVars() {
        GPIOConfigUtil.GPIOXMLInfoParse();
    }

    public static void LoadAllGlobalVars() {
        GPIOConfigUtil.pinConfigInfoDecodingV1();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(GPIOInfoUtil.GPIOConfigInfoMap);
            out.writeObject(GPIORestoreConfigInfoMap);
            out.writeObject(GPIOXMLRegularMap);
            out.writeObject(GPIOXMLCodeDefineMap);
            out.writeObject(PinComboBoxItemsMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                GPIOConfigUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            GPIOInfoUtil.GPIOConfigInfoMap = (Map)ins.readObject();
            GPIORestoreConfigInfoMap = (Map)ins.readObject();
            GPIOXMLRegularMap = (Map)ins.readObject();
            GPIOXMLCodeDefineMap = (Map)ins.readObject();
            PinComboBoxItemsMap = (Map)ins.readObject();
            GPIOConfigUtil.ConfigInfo2UserConfig();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String Serialize() {
        String out = "";
        out = String.valueOf(out) + GPIOConfigUtil.pinConfigInfoEncodingV1();
        out = String.valueOf(out) + GPIOConfigUtil.pinMultiCoreInfoEncodingV1();
        return out;
    }

    public static void DeSerialize(String ins, int version) {
        switch (version) {
            case 1: {
                GPIOConfigUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(String input) {
        mapDecodingInfo = GlobalVariables.serializeStrClassification((String)input, (String)String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_INFO));
    }

    private static String pinConfigInfoEncodingV1() {
        String out = "";
        for (String strPeri : mapPinUserConfig.keySet()) {
            Map<String, Map<String, String>> mapPinInfo = mapPinUserConfig.get(strPeri);
            for (String strPinName : mapPinInfo.keySet()) {
                Map<String, String> mapConfigInfo = mapPinInfo.get(strPinName);
                for (String strConfigObj : mapConfigInfo.keySet()) {
                    String strVal = mapConfigInfo.get(strConfigObj);
                    strPeri = strPeri.replaceAll("\\.", "@2E@");
                    strPinName = strPinName.replaceAll("\\.", "@2E@");
                    strConfigObj = strConfigObj.replaceAll("\\.", "@2E@");
                    String str = String.valueOf(String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_INFO, strPeri, strPinName, strConfigObj)) + "=" + strVal + System.getProperty("line.separator");
                    out = String.valueOf(out) + str;
                }
            }
        }
        return out;
    }

    private static void pinConfigInfoDecodingV1() {
        for (String strPeri : mapDecodingInfo.keySet()) {
            Map<String, String> mapConfigInfo = mapDecodingInfo.get(strPeri);
            for (String strConfigObj : mapConfigInfo.keySet()) {
                String strVal = mapConfigInfo.get(strConfigObj);
                String strPeriNoPrefix = strPeri.replace(String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_INFO, ""), "");
                ArrayList<String> lstPeriAndPin = new ArrayList<String>(Arrays.asList(strPeriNoPrefix.split("\\.")));
                if (lstPeriAndPin.size() == 2) {
                    String strPeriOnly = (String)lstPeriAndPin.get(0);
                    String strPinOnly = (String)lstPeriAndPin.get(1);
                    GPIOConfigUtil.updateGPIOConfigInfoMap(strPeriOnly, strPinOnly, strConfigObj, strVal);
                    GPIOConfigUtil.addSerialPinUserConfig(strPeriOnly, strPinOnly, strConfigObj, strVal);
                    continue;
                }
                LogManager.getInstance().error("<GPIOConfigContent>", "The format of the GPIO pin information is incorrect, the gdc file may have been manually modified. Serialize Error: " + strPeriNoPrefix);
            }
        }
    }

    private static String pinMultiCoreInfoEncodingV1() {
        String out = "";
        for (String strPinName : GPIOConfigPinOnCore.keySet()) {
            String strCore = GPIOConfigPinOnCore.get(strPinName);
            strPinName = strPinName.replaceAll("\\.", "@2E@");
            String str = String.valueOf(String.join((CharSequence)".", STR_SERIALIZE, SERIALIZE_CORE, strPinName)) + "=" + strCore + System.getProperty("line.separator");
            out = String.valueOf(out) + str;
        }
        return out;
    }

    private static void updateGPIOConfigInfoMap(String strPeri, String strPinName, String strConfigObj, String strVal) {
        if (GPIOInfoUtil.GPIOConfigInfoMap.containsKey(strPeri)) {
            Map mapRowData = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri);
            if (mapRowData.containsKey(strPinName)) {
                Vector RowData = (Vector)mapRowData.get(strPinName);
                int index = GPIOInfoUtil.getConfigColIndex((String)strConfigObj);
                RowData.setElementAt(strVal, index);
            } else {
                LogManager.getInstance().error("<GPIOConfigContent>", "The pin " + strPinName + " of peripheral " + strPeri + " does not exist in the change items. Serialize Error" + " Peri: " + strPeri + ", Pin: " + strConfigObj + ", ConfigObj: " + strConfigObj + ", Val: " + strVal + ".");
            }
        } else {
            LogManager.getInstance().error("<GPIOConfigContent>", "There are no changed pins for the peripheral " + strPeri + ". Serialize Error" + " Peri: " + strPeri + ", Pin: " + strConfigObj + ", ConfigObj: " + strConfigObj + ", Val: " + strVal + ".");
        }
        if (strConfigObj.equals("UserLabel")) {
            GlobalVariables.UpdatePinPadUserLabel((String)strPinName, (String)strVal);
        }
    }

    private static void addSerialPinUserConfig(String strPeri, String strPinName, String strConfigObj, String strVal) {
        if (mapPinUserConfig.containsKey(strPeri)) {
            Map<String, Map<String, String>> mapPinInfo = mapPinUserConfig.get(strPeri);
            if (mapPinInfo.containsKey(strPinName)) {
                Map<String, String> mapConfigInfo = mapPinInfo.get(strPinName);
                if (mapConfigInfo.containsKey(strConfigObj)) {
                    String strCurrentValue = mapConfigInfo.get(strConfigObj);
                    if (!strCurrentValue.equals(strVal)) {
                        mapConfigInfo.put(strConfigObj, strVal);
                    }
                } else {
                    mapConfigInfo.put(strConfigObj, strVal);
                }
            } else {
                HashMap<String, String> mapConfigInfo = new HashMap<String, String>();
                mapConfigInfo.put(strConfigObj, strVal);
                mapPinInfo.put(strPinName, mapConfigInfo);
            }
        } else {
            HashMap<String, String> mapConfigInfo = new HashMap<String, String>();
            mapConfigInfo.put(strConfigObj, strVal);
            HashMap<String, HashMap<String, String>> mapPinInfo = new HashMap<String, HashMap<String, String>>();
            mapPinInfo.put(strPinName, mapConfigInfo);
            mapPinUserConfig.put(strPeri, mapPinInfo);
        }
    }

    public static void updatePinUserConfig(String strPeri, String strPinName, String strConfigObj, String strVal) {
        Map<String, Vector<String>> mapConfig;
        if (mapPinUserConfigTemp.containsKey(strPeri)) {
            Map<Object, Object> mapConfigInfo;
            Map<String, Map<String, String>> mapPinInfo = mapPinUserConfigTemp.get(strPeri);
            if (mapPinInfo.containsKey(strPinName)) {
                mapConfigInfo = mapPinInfo.get(strPinName);
                if (mapConfigInfo.containsKey(strConfigObj)) {
                    if (GPIOConfigUtil.isDefaultValue(strPinName, strConfigObj, strVal)) {
                        mapConfigInfo.remove(strConfigObj);
                        if (mapConfigInfo.size() == 1 && mapConfigInfo.containsKey("ModifyFlag")) {
                            mapPinInfo.remove(strPinName);
                            if (mapPinInfo.size() == 0) {
                                mapPinUserConfigTemp.remove(strPeri);
                            }
                        }
                    } else {
                        mapConfigInfo.put(strConfigObj, strVal);
                        mapConfigInfo.put("ModifyFlag", "TRUE");
                    }
                } else {
                    mapConfigInfo.put(strConfigObj, strVal);
                    mapConfigInfo.put("ModifyFlag", "TRUE");
                }
            } else {
                mapConfigInfo = new HashMap();
                mapConfigInfo.put(strConfigObj, strVal);
                mapConfigInfo.put("ModifyFlag", "TRUE");
                mapPinInfo.put(strPinName, mapConfigInfo);
            }
        } else {
            HashMap<String, String> mapConfigInfo = new HashMap<String, String>();
            mapConfigInfo.put(strConfigObj, strVal);
            mapConfigInfo.put("ModifyFlag", "TRUE");
            HashMap<String, HashMap<String, String>> mapPinInfo = new HashMap<String, HashMap<String, String>>();
            mapPinInfo.put(strPinName, mapConfigInfo);
            mapPinUserConfigTemp.put(strPeri, mapPinInfo);
        }
        String state = GPIOConfigUtil.getModifyState(strPeri, strPinName);
        if (GPIOConfigInfoMapTemp.containsKey(strPeri) && (mapConfig = GPIOConfigInfoMapTemp.get(strPeri)).containsKey(strPinName)) {
            Vector<String> RowData = mapConfig.get(strPinName);
            int index = GPIOInfoUtil.getConfigColIndex((String)"ModifyFlag");
            RowData.setElementAt(state, index);
        }
    }

    private static boolean isDefaultValue(String strPinName, String strConfigObj, String strVal) {
        String valDefault;
        Map<String, String> mapConfigObjInfo;
        return pinConfigObjDefault.containsKey(strPinName) && (mapConfigObjInfo = pinConfigObjDefault.get(strPinName)).containsKey(strConfigObj) && (valDefault = mapConfigObjInfo.get(strConfigObj)).equals(strVal);
    }

    private static Vector<String> GetTableRowData(GD32PinPad PinPad, String strModuleName) {
        String strSignal;
        Vector<String> RowData = new Vector<String>();
        ComboBoxItemsMap = new HashMap<String, List<String>>();
        String strPinName = PinPad.getPinName();
        String strSignalOrig = strSignal = PinPad.getPinUsedFunctionStr();
        if (PinPad.getGPIOModel() == 1 && strSignal.contains(",")) {
            strSignal = "GPIO_Analog";
            strModuleName = "GPIO";
        }
        String strMode = GPIOConfigUtil.getMode(strModuleName, strSignal);
        HashMap<String, String> mapConfigObjInfo = new HashMap<String, String>();
        Iterator iterator = GPIOInfoUtil.mapGPIOConfigObjsIndex.keySet().iterator();
        while (iterator.hasNext()) {
            String strConfigObj;
            switch (strConfigObj = (String)iterator.next()) {
                case "PinName": {
                    RowData.add(strPinName);
                    break;
                }
                case "SignalOnPin": {
                    RowData.add(strSignalOrig);
                    break;
                }
                case "OutputLevel": {
                    String strLevel = GPIOConfigUtil.getConfigObjSettingInfo("OutputLevel", strModuleName, strMode, true);
                    RowData.add(strLevel);
                    mapConfigObjInfo.put("OutputLevel", strLevel);
                    break;
                }
                case "GPIOMode": {
                    RowData.add(strMode);
                    mapConfigObjInfo.put("GPIOMode", strMode);
                    break;
                }
                case "PullUpDown": {
                    String strPull = GPIOConfigUtil.getPullUpDown(strModuleName, strSignal);
                    RowData.add(strPull);
                    mapConfigObjInfo.put("PullUpDown", strPull);
                    break;
                }
                case "MaxSpeed": {
                    String strSpeed = GPIOConfigUtil.getSpeed(strModuleName, strSignal);
                    RowData.add(strSpeed);
                    mapConfigObjInfo.put("MaxSpeed", strSpeed);
                    break;
                }
                case "UserLabel": {
                    RowData.add("");
                    mapConfigObjInfo.put("UserLabel", "");
                }
                case "ModifyFlag": {
                    RowData.add("");
                    mapConfigObjInfo.put("ModifyFlag", "");
                    break;
                }
                case "InputFilterType": {
                    String strInputFilterType = GPIOConfigUtil.getConfigObjSettingInfo("InputFilterType", strModuleName, strMode, true);
                    RowData.add(strInputFilterType);
                    mapConfigObjInfo.put("InputFilterType", strInputFilterType);
                    break;
                }
                case "InputFilter": {
                    String strInputFilter = GPIOConfigUtil.getConfigObjSettingInfo("InputFilter", strModuleName, strMode, false);
                    RowData.add(strInputFilter);
                    mapConfigObjInfo.put("InputFilter", strInputFilter);
                    break;
                }
                default: {
                    RowData.add("");
                }
            }
        }
        pinConfigObjDefault.put(strPinName, mapConfigObjInfo);
        PinComboBoxItemsMap.put(strPinName, ComboBoxItemsMap);
        return RowData;
    }

    private static String getConfigObjSettingInfo(String strConfigObj, String strModuleName, String mStrMode, Boolean sortEnable) {
        Serializable temp;
        GPIOConfigInfo ConfigInfo = GPIOXMLRegularMap.get(strConfigObj);
        String strRet = ConfigInfo.getDefault();
        List<GPIORulesStruct> lstRules = ConfigInfo.getRules();
        int i = 0;
        while (i < lstRules.size()) {
            temp = lstRules.get(i);
            if (((GPIORulesStruct)temp).getModule().equals(strModuleName)) {
                List<String> items = ((GPIORulesStruct)temp).getItems();
                if (items.size() > 0) {
                    int j = 0;
                    while (j < items.size()) {
                        if (items.get(j).equals(mStrMode)) {
                            strRet = ((GPIORulesStruct)temp).getlstValue().get(0);
                            break;
                        }
                        ++j;
                    }
                } else {
                    strRet = ((GPIORulesStruct)temp).getlstValue().get(0);
                }
            }
            ++i;
        }
        List<String> lstItems = ConfigInfo.getSource();
        if (strRet.equals("N/A")) {
            temp = new ArrayList();
            ComboBoxItemsMap.put(strConfigObj, (List<String>)((Object)temp));
        } else {
            if (sortEnable.booleanValue()) {
                ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
                Collections.sort(sortedItems);
                ComboBoxItemsMap.put(strConfigObj, sortedItems);
            }
            ComboBoxItemsMap.put(strConfigObj, lstItems);
        }
        return strRet;
    }

    private static String getPullUpDown(String strModuleName, String mStrSignal) {
        ConflictGroupInfo GroupInfoObj;
        GPIORulesStruct temp;
        GPIOConfigInfo ConfigInfo = GPIOXMLRegularMap.get("PullUpDown");
        List<String> lstItems = ConfigInfo.getSource();
        String strRet = ConfigInfo.getDefault();
        List<GPIORulesStruct> lstRules = ConfigInfo.getRules();
        int i = 0;
        while (i < lstRules.size()) {
            temp = lstRules.get(i);
            if (temp.getModule().equals(strModuleName) && mStrSignal.equals(temp.getSignal())) {
                GroupInfoObj = temp.getGroupInfoObj();
                boolean flag = false;
                if (GroupInfoObj.getConditionType() == 0) {
                    if (GroupInfoObj.getConditionsList().size() > 0 && ConflictCheck.ConditionCheck((ConflictGroupInfo)GroupInfoObj)) {
                        flag = true;
                    }
                } else if ((GroupInfoObj.getNestConditionGroupObj().getConditionsList().size() > 0 || GroupInfoObj.getNestConditionGroupObj().getNestConditionGroupObj().size() > 0) && ConflictCheck.ConditionCheck((ConflictGroupInfo)GroupInfoObj)) {
                    flag = true;
                }
                if (flag) {
                    lstItems = temp.getlstValue();
                    strRet = lstItems.get(0);
                    ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
                    Collections.sort(sortedItems);
                    ComboBoxItemsMap.put("PullUpDown", sortedItems);
                    return strRet;
                }
            }
            ++i;
        }
        i = 0;
        while (i < lstRules.size()) {
            temp = lstRules.get(i);
            if (temp.getModule().equals(strModuleName)) {
                List<String> items;
                GroupInfoObj = temp.getGroupInfoObj();
                if (mStrSignal.equals(temp.getSignal()) && (items = temp.getItems()).size() == 0 && GroupInfoObj.getConditionsList().size() == 0) {
                    lstItems = temp.getlstValue();
                    strRet = lstItems.get(0);
                    ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
                    Collections.sort(sortedItems);
                    ComboBoxItemsMap.put("PullUpDown", sortedItems);
                    return strRet;
                }
            }
            ++i;
        }
        i = 0;
        while (i < lstRules.size()) {
            List<String> items;
            temp = lstRules.get(i);
            GroupInfoObj = temp.getGroupInfoObj();
            if (temp.getModule().equals(strModuleName) && (temp.getSignal().equals("") || mStrSignal.contains(temp.getSignal()) || GPIOConfigUtil.removeNum(mStrSignal).equals(temp.getSignal())) && (items = temp.getItems()).size() == 0 && GroupInfoObj.getConditionsList().size() == 0) {
                lstItems = temp.getlstValue();
                strRet = lstItems.get(0);
                ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
                Collections.sort(sortedItems);
                ComboBoxItemsMap.put("PullUpDown", sortedItems);
                return strRet;
            }
            ++i;
        }
        ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
        Collections.sort(sortedItems);
        ComboBoxItemsMap.put("PullUpDown", sortedItems);
        return strRet;
    }

    private static String getMode(String strModuleName, String mStrSignal) {
        String realModuleName;
        ConflictGroupInfo GroupInfoObj;
        GPIORulesStruct temp;
        GPIOConfigInfo ConfigInfo = GPIOXMLRegularMap.get("GPIOMode");
        List<Object> lstItems = new ArrayList();
        String strRet = ConfigInfo.getDefault();
        List<GPIORulesStruct> lstRules = ConfigInfo.getRules();
        int i = 0;
        while (i < lstRules.size()) {
            temp = lstRules.get(i);
            if (mStrSignal.equals(temp.getSignal())) {
                GroupInfoObj = temp.getGroupInfoObj();
                boolean flag = false;
                if (GroupInfoObj.getConditionType() == 0) {
                    if (GroupInfoObj.getConditionsList().size() > 0 && ConflictCheck.ConditionCheck((ConflictGroupInfo)GroupInfoObj)) {
                        flag = true;
                    }
                } else if ((GroupInfoObj.getNestConditionGroupObj().getConditionsList().size() > 0 || GroupInfoObj.getNestConditionGroupObj().getNestConditionGroupObj().size() > 0) && ConflictCheck.ConditionCheck((ConflictGroupInfo)GroupInfoObj)) {
                    flag = true;
                }
                if (flag) {
                    lstItems = temp.getlstValue();
                    strRet = (String)lstItems.get(0);
                    ArrayList<Object> sortedItems = new ArrayList<Object>(lstItems);
                    Collections.sort(sortedItems);
                    ComboBoxItemsMap.put("GPIOMode", sortedItems);
                    return strRet;
                }
            }
            ++i;
        }
        i = 0;
        while (i < lstRules.size()) {
            List<String> items;
            temp = lstRules.get(i);
            GroupInfoObj = temp.getGroupInfoObj();
            if (mStrSignal.equals(temp.getSignal()) && (items = temp.getItems()).size() == 0 && GroupInfoObj.getConditionsList().size() == 0) {
                lstItems = temp.getlstValue();
                strRet = (String)lstItems.get(0);
                ArrayList<Object> sortedItems = new ArrayList<Object>(lstItems);
                Collections.sort(sortedItems);
                ComboBoxItemsMap.put("GPIOMode", sortedItems);
                return strRet;
            }
            ++i;
        }
        i = 0;
        while (i < lstRules.size()) {
            List<String> items;
            temp = lstRules.get(i);
            GroupInfoObj = temp.getGroupInfoObj();
            if (temp.getModule().equals(strModuleName) && (temp.getSignal().equals("") || mStrSignal.contains(temp.getSignal()) || GPIOConfigUtil.removeNum(mStrSignal).equals(temp.getSignal())) && (items = temp.getItems()).size() == 0 && GroupInfoObj.getConditionsList().size() == 0) {
                lstItems = temp.getlstValue();
                strRet = (String)lstItems.get(0);
                ArrayList<Object> sortedItems = new ArrayList<Object>(lstItems);
                Collections.sort(sortedItems);
                ComboBoxItemsMap.put("GPIOMode", sortedItems);
                return strRet;
            }
            ++i;
        }
        if (strRet.equals("N/A") && lstItems.size() == 0 && (realModuleName = GPIOConfigUtil.getRealModuleName(mStrSignal)) != null && realModuleName != "") {
            int i2 = 0;
            while (i2 < lstRules.size()) {
                List<String> items;
                GPIORulesStruct temp2 = lstRules.get(i2);
                ConflictGroupInfo GroupInfoObj2 = temp2.getGroupInfoObj();
                if (temp2.getModule().equals(realModuleName) && (temp2.getSignal().equals("") || mStrSignal.contains(temp2.getSignal()) || GPIOConfigUtil.removeNum(mStrSignal).equals(temp2.getSignal())) && (items = temp2.getItems()).size() == 0 && GroupInfoObj2.getConditionsList().size() == 0) {
                    lstItems = temp2.getlstValue();
                    strRet = (String)lstItems.get(0);
                    ArrayList<Object> sortedItems = new ArrayList<Object>(lstItems);
                    Collections.sort(sortedItems);
                    ComboBoxItemsMap.put("GPIOMode", sortedItems);
                    return strRet;
                }
                ++i2;
            }
        }
        ArrayList sortedItems = new ArrayList(lstItems);
        Collections.sort(sortedItems);
        ComboBoxItemsMap.put("GPIOMode", sortedItems);
        return strRet;
    }

    private static String getSpeed(String strModuleName, String mStrSignal) {
        ConflictGroupInfo GroupInfoObj;
        GPIORulesStruct temp;
        int i;
        GPIOConfigInfo ConfigInfo = GPIOXMLRegularMap.get("MaxSpeed");
        String strRet = ConfigInfo.getDefault();
        List<String> lstItems = ConfigInfo.getSource();
        List<GPIORulesStruct> lstRules = ConfigInfo.getRules();
        int i2 = 0;
        while (i2 < lstRules.size()) {
            GPIORulesStruct temp2 = lstRules.get(i2);
            if (temp2.getModule().equals(strModuleName)) {
                List<String> items;
                ConflictGroupInfo GroupInfoObj2 = temp2.getGroupInfoObj();
                if (mStrSignal.equals(temp2.getSignal()) && (items = temp2.getItems()).size() == 0 && GroupInfoObj2.getConditionsList().size() == 0 && lstItems.contains(strRet = temp2.getlstValue().get(0))) {
                    ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
                    Collections.sort(sortedItems, new NumberStringComparator());
                    ComboBoxItemsMap.put("MaxSpeed", sortedItems);
                    return strRet;
                }
            }
            ++i2;
        }
        String realModuleName = GPIOConfigUtil.getRealModuleName(mStrSignal);
        if (realModuleName != null && realModuleName != "") {
            i = 0;
            while (i < lstRules.size()) {
                List<String> items;
                temp = lstRules.get(i);
                GroupInfoObj = temp.getGroupInfoObj();
                if (temp.getModule().equals(realModuleName) && (temp.getSignal().equals("") || mStrSignal.contains(temp.getSignal()) || GPIOConfigUtil.removeNum(mStrSignal).equals(temp.getSignal())) && (items = temp.getItems()).size() == 0 && GroupInfoObj.getConditionsList().size() == 0 && lstItems.contains(strRet = temp.getlstValue().get(0))) {
                    ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
                    Collections.sort(sortedItems, new NumberStringComparator());
                    ComboBoxItemsMap.put("MaxSpeed", sortedItems);
                    return strRet;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < lstRules.size()) {
                List<String> items;
                temp = lstRules.get(i);
                GroupInfoObj = temp.getGroupInfoObj();
                if (temp.getModule().equals(strModuleName) && (temp.getSignal().equals("") || mStrSignal.contains(temp.getSignal()) || GPIOConfigUtil.removeNum(mStrSignal).equals(temp.getSignal())) && (items = temp.getItems()).size() == 0 && GroupInfoObj.getConditionsList().size() == 0 && lstItems.contains(strRet = temp.getlstValue().get(0))) {
                    ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
                    Collections.sort(sortedItems, new NumberStringComparator());
                    ComboBoxItemsMap.put("MaxSpeed", sortedItems);
                    return strRet;
                }
                ++i;
            }
        }
        if (strRet.equals("N/A")) {
            ArrayList temp3 = new ArrayList();
            ComboBoxItemsMap.put("MaxSpeed", temp3);
        } else {
            ArrayList<String> sortedItems = new ArrayList<String>(lstItems);
            Collections.sort(sortedItems, new NumberStringComparator());
            ComboBoxItemsMap.put("MaxSpeed", sortedItems);
        }
        return strRet;
    }

    public static List<String> GetUsedGPIOPort() {
        HashMap<String, String> PinPortMap = new HashMap<String, String>();
        ArrayList<String> lstUsedPinPort = new ArrayList<String>();
        for (String key : GPIOInfoUtil.GPIOConfigInfoMap.keySet()) {
            Map GPIOTableDataMap = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(key);
            for (String PinName : GPIOTableDataMap.keySet()) {
                if (PinName.charAt(0) != 'P') continue;
                String strPort = PinName.substring(1, 2);
                String strPinPort = "GPIO" + strPort;
                PinPortMap.put(strPinPort, "");
            }
        }
        for (String PinPort : PinPortMap.keySet()) {
            lstUsedPinPort.add(PinPort);
        }
        return lstUsedPinPort;
    }

    public static void UnifyPinChange(String strPeri, String strPinName, String strConfigObj, String strVal) {
        for (String peri : GPIOConfigInfoMapTemp.keySet()) {
            if (strPeri.equalsIgnoreCase(peri)) continue;
            Map<String, Vector<String>> mapPinConfig = GPIOConfigInfoMapTemp.get(peri);
            for (String pinName : mapPinConfig.keySet()) {
                if (!pinName.equals(strPinName)) continue;
                Vector<String> RowData = mapPinConfig.get(pinName);
                int index = GPIOInfoUtil.getConfigColIndex((String)strConfigObj);
                RowData.setElementAt(strVal, index);
                GPIOConfigUtil.updatePinUserConfig(peri, pinName, strConfigObj, strVal);
            }
        }
    }

    private static String getModifyState(String strModuleName, String strPinName) {
        Map<String, Map<String, String>> mapPinInfo;
        if (mapPinUserConfigTemp.containsKey(strModuleName) && (mapPinInfo = mapPinUserConfigTemp.get(strModuleName)).containsKey(strPinName)) {
            return "TRUE";
        }
        return "";
    }

    private static void ConfigInfo2UserConfig() {
        for (String strPeri : GPIOInfoUtil.GPIOConfigInfoMap.keySet()) {
            Map mapPinConfig = (Map)GPIOInfoUtil.GPIOConfigInfoMap.get(strPeri);
            for (String strPinName : mapPinConfig.keySet()) {
                if (!pinConfigObjDefault.containsKey(strPinName)) continue;
                Vector RowDataCurrent = (Vector)mapPinConfig.get(strPinName);
                if (!((String)RowDataCurrent.get(2)).toString().equals(pinConfigObjDefault.get(strPinName).get("OutputLevel"))) {
                    GPIOConfigUtil.addSerialPinUserConfig(strPeri, strPinName, "OutputLevel", ((String)RowDataCurrent.get(2)).toString());
                }
                if (!((String)RowDataCurrent.get(3)).toString().equals(pinConfigObjDefault.get(strPinName).get("GPIOMode"))) {
                    GPIOConfigUtil.addSerialPinUserConfig(strPeri, strPinName, "GPIOMode", ((String)RowDataCurrent.get(3)).toString());
                }
                if (!((String)RowDataCurrent.get(4)).toString().equals(pinConfigObjDefault.get(strPinName).get("PullUpDown"))) {
                    GPIOConfigUtil.addSerialPinUserConfig(strPeri, strPinName, "PullUpDown", ((String)RowDataCurrent.get(4)).toString());
                }
                if (!((String)RowDataCurrent.get(5)).toString().equals(pinConfigObjDefault.get(strPinName).get("MaxSpeed"))) {
                    GPIOConfigUtil.addSerialPinUserConfig(strPeri, strPinName, "MaxSpeed", ((String)RowDataCurrent.get(5)).toString());
                }
                if (!((String)RowDataCurrent.get(6)).toString().equals(pinConfigObjDefault.get(strPinName).get("UserLabel"))) {
                    GPIOConfigUtil.addSerialPinUserConfig(strPeri, strPinName, "UserLabel", ((String)RowDataCurrent.get(6)).toString());
                }
                if (((String)RowDataCurrent.get(7)).toString().equals(pinConfigObjDefault.get(strPinName).get("ModifyFlag"))) continue;
                GPIOConfigUtil.addSerialPinUserConfig(strPeri, strPinName, "ModifyFlag", ((String)RowDataCurrent.get(7)).toString());
            }
        }
    }

    public static String removeNum(String input) {
        String result = input.replaceAll("\\d+_", "_");
        result = result.replaceAll("\\d+$", "");
        return result;
    }

    private static String getRealModuleName(String function) {
        ModuleStruct moduleStruct;
        List lstItemObj;
        String strName = "";
        if (GlobalVariables.FunctionPosInWidget.containsKey(function)) {
            lstItemObj = (List)GlobalVariables.FunctionPosInWidget.get(function);
            for (WidgetNodeStruct widgetNodeStruct : lstItemObj) {
                moduleStruct = ControlConflict.getModuleByNode((NodeStruct)((NodeStruct)widgetNodeStruct));
                if (moduleStruct == null) continue;
                return moduleStruct.getNodeName();
            }
        }
        if (GlobalVariables.FunctionPosInItem.containsKey(function)) {
            lstItemObj = (List)GlobalVariables.FunctionPosInItem.get(function);
            for (ItemStruct itemStruct : lstItemObj) {
                moduleStruct = ControlConflict.getModuleByItem((ItemStruct)itemStruct);
                if (moduleStruct == null) continue;
                return moduleStruct.getNodeName();
            }
        }
        return strName;
    }
}

