/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.privilege;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionFunc {
    public String CheckCRCPolynomialInput(String str) {
        String strRet = "true";
        String[] strSrc = new String[]{"X0", "X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8", "X9", "X10", "X11", "X12", "X13", "X14", "X15"};
        String[] strArray = str.split("\\+");
        int i = 0;
        while (i < strArray.length) {
            String strItem = strArray[i];
            if (!Arrays.asList(strSrc).contains(strItem)) {
                strRet = "false";
                break;
            }
            ++i;
        }
        return strRet;
    }

    public String GetCRCPolynomialCode(String str) {
        String strRet = "";
        int Sum = 0;
        List lstIndex = this.SearchAllIndex(str, "X");
        List lstNum = this.GetAllNum(str, lstIndex);
        int i = 0;
        while (i < lstNum.size()) {
            double a = 2.0;
            int b = (Integer)lstNum.get(i);
            Sum = (int)((double)Sum + Math.pow(a, b));
            ++i;
        }
        strRet = Integer.toString(Sum);
        return strRet;
    }

    public String Multiply(String a, String b) {
        String result = "";
        try {
            int aa = Integer.parseInt(a);
            int bb = Integer.parseInt(b);
            result = String.valueOf(aa * bb);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    private List SearchAllIndex(String str, String key) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int index = str.indexOf(key);
        while (index != -1) {
            lst.add(index);
            index = str.indexOf(key, index + 1);
        }
        return lst;
    }

    private List GetAllNum(String str, List allIndex) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int i = 0;
        while (i < allIndex.size()) {
            int Pos2;
            int tempPos = Pos2 = (Integer)allIndex.get(i) + 1;
            int len = 0;
            String strNum = "";
            while (tempPos <= str.length() - 1) {
                char c = str.charAt(tempPos);
                if (c < '0' || c > '9') break;
                ++len;
                ++tempPos;
            }
            strNum = str.substring(Pos2, Pos2 + len);
            lst.add(Integer.valueOf(strNum));
            ++i;
        }
        return lst;
    }

    public String GetBaudRate(String strPBxClock, String strPrescaler) {
        String strRet = "";
        if (strPBxClock.equals("") || strPrescaler.equals("")) {
            return strRet;
        }
        strPBxClock = strPBxClock.replaceAll("MHz", "");
        double douClock = Double.parseDouble(strPBxClock);
        double douPrescaler = Double.parseDouble(strPrescaler);
        double BaudRate = douClock / douPrescaler;
        strRet = String.format("%6f", BaudRate);
        strRet = String.valueOf(strRet) + " MBits/s";
        return strRet;
    }

    public String GetTimeQuantum(String strPCLK1, String strPrescaler) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double TimeQuantum = Prescaler / PCLK1;
        strRet = String.format("%.1f", TimeQuantum);
        strRet = String.valueOf(strRet) + " ns";
        return strRet;
    }

    public String GetTimeForOneBit(String strPCLK1, String strPrescaler, String strBTS1, String strBTS2) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("") || strBTS1.equals("") || strBTS2.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double BTS1 = Double.parseDouble(strBTS1.split(" ")[0]);
        double BTS2 = Double.parseDouble(strBTS2.split(" ")[0]);
        double TimeForOneBit = Prescaler / PCLK1 + BTS1 * Prescaler / PCLK1 + BTS2 * Prescaler / PCLK1;
        strRet = String.format("%.2f", TimeForOneBit);
        strRet = String.valueOf(strRet) + " ns";
        return strRet;
    }

    public String GetCanBaudRate(String strPCLK1, String strPrescaler, String strBTS1, String strBTS2) {
        String strRet = "";
        if (strPCLK1.equals("") || strPrescaler.equals("") || strBTS1.equals("") || strBTS2.equals("")) {
            return strRet;
        }
        double PCLK1 = Double.parseDouble(strPCLK1) * 1000000.0;
        double Prescaler = Double.parseDouble(strPrescaler) * 1.0E9;
        double BTS1 = Double.parseDouble(strBTS1.split(" ")[0]);
        double BTS2 = Double.parseDouble(strBTS2.split(" ")[0]);
        double TimeForOneBit = Prescaler / PCLK1 + BTS1 * Prescaler / PCLK1 + BTS2 * Prescaler / PCLK1;
        double CanBaudRate = 1.0 / TimeForOneBit * 1.0E9;
        strRet = String.format("%.0f", Math.floor(CanBaudRate));
        strRet = String.valueOf(strRet) + " bit/s";
        return strRet;
    }

    public String StringJudge(String strDefaultValue, String strInput) {
        String strRet = "";
        if ((strInput = strInput.replaceAll("+", "")).contains("X")) {
            String[] strArray = strInput.split("X");
            int i = 0;
            while (i < strArray.length) {
                String strItem = strArray[i];
                int Num = 0;
                try {
                    Num = Integer.parseInt(strItem);
                }
                catch (Exception exception) {
                    strRet = strDefaultValue;
                    break;
                }
                if (Num > 15 || Num < 0) {
                    strRet = strDefaultValue;
                    break;
                }
                ++i;
            }
        } else {
            strRet = strDefaultValue;
        }
        return strRet;
    }

    public boolean GetConditionsAND(String ... conditions) {
        String[] stringArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            String condition = stringArray[n2];
            if (!Boolean.parseBoolean(condition)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean GetConditionsAND(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3);
    }

    public boolean GetConditionsAND(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) && Boolean.parseBoolean(strbl2) && Boolean.parseBoolean(strbl3) && Boolean.parseBoolean(strbl4);
    }

    public boolean GetConditionsOR(String strbl1, String strbl2) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2);
    }

    public boolean GetConditionsOR(String strbl1, String strbl2, String strbl3, String strbl4) {
        return Boolean.parseBoolean(strbl1) || Boolean.parseBoolean(strbl2) || Boolean.parseBoolean(strbl3) || Boolean.parseBoolean(strbl4);
    }

    public boolean GetConditionOpposite(String strbl) {
        return !Boolean.parseBoolean(strbl);
    }

    public String GetAlarmMaskValue(String Alarm0DateMask, String Alarm0HoursMask, String Alarm0MinutesMask, String Alarm0SecondsMask) {
        String value = "";
        if (Alarm0DateMask.equals("Enable") && Alarm0HoursMask.equals("Enable") && Alarm0MinutesMask.equals("Enable") && Alarm0SecondsMask.equals("Enable")) {
            value = "HAL_RTC_ALARM_ALL_MASK";
        } else if (Alarm0DateMask.equals("Disable") && Alarm0HoursMask.equals("Disable") && Alarm0MinutesMask.equals("Disable") && Alarm0SecondsMask.equals("Disable")) {
            value = "HAL_RTC_ALARM_NONE_MASK";
        } else {
            if (Alarm0DateMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_DATE_MASK | ";
            }
            if (Alarm0HoursMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_HOUR_MASK | ";
            }
            if (Alarm0MinutesMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_MINUTE_MASK | ";
            }
            if (Alarm0SecondsMask.equals("Enable")) {
                value = String.valueOf(value) + "HAL_RTC_ALARM_SECOND_MASK | ";
            }
        }
        int i = value.length() - 1;
        while (i >= 0) {
            char v = value.charAt(i);
            if (v >= 'a' && v <= 'z' || v >= 'A' && v <= 'Z') {
                value = value.substring(0, i + 1);
                break;
            }
            --i;
        }
        return value;
    }

    public String TimeRegulate(String strY, String strM, String strD, String strHH, String strMM, String strSS) {
        String value = "";
        int month = 0;
        List<String> monthlist = Arrays.asList("HAL_RTC_JAN", "HAL_RTC_FEB", "HAL_RTC_MAR", "HAL_RTC_APR", "HAL_RTC_MAY", "HAL_RTC_JUN", "HAL_RTC_JUL", "HAL_RTC_AUG", "HAL_RTC_SEP", "HAL_RTC_OCT", "HAL_RTC_NOV", "HAL_RTC_DEC");
        int i = 0;
        while (i < monthlist.size()) {
            if (monthlist.get(i).compareTo(strM) == 0) {
                month = i;
                break;
            }
            ++i;
        }
        int year = Integer.parseInt(strY);
        int date = Integer.parseInt(strD);
        int hour = Integer.parseInt(strHH);
        int minute = Integer.parseInt(strMM);
        int second = Integer.parseInt(strSS);
        long unix_TimeStamp = 0L;
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 31;
        nArray2[2] = 60;
        nArray2[3] = 91;
        nArray2[4] = 121;
        nArray2[5] = 152;
        nArray2[6] = 182;
        nArray2[7] = 213;
        nArray2[8] = 244;
        nArray2[9] = 274;
        nArray2[10] = 305;
        nArray2[11] = 335;
        nArrayArray[1] = nArray2;
        int[][] Day_Count = nArrayArray;
        if (month > 0) {
            unix_TimeStamp = 10957 + year * 365 + (year + 3) / 4;
            unix_TimeStamp += (long)Day_Count[0][month - 1];
            if (year % 4 == 0 && month > 2) {
                ++unix_TimeStamp;
            }
            unix_TimeStamp = (unix_TimeStamp + (long)(date - 1)) * 24L;
            unix_TimeStamp = (unix_TimeStamp + (long)hour - 8L) * 3600L + (long)(minute * 60) + (long)second;
        } else {
            unix_TimeStamp = 1514779200L;
        }
        value = String.valueOf(unix_TimeStamp);
        return value;
    }
}

