/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.privilege;

import com.gigadevice.periconfigview.baseinfo.privilege.GroupInfo;
import com.gigadevice.periconfigview.baseinfo.privilege.PeriPrivilegeInfo;
import com.gigadevice.periconfigview.baseinfo.privilege.PrivilegeControl;
import com.gigadevice.periconfigview.utils.GeneralPeriConfigUtil;
import com.gigadevice.periconfigview.xmlparse.PeriConfigPrivilegeXmlParse;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.PerisItemsStruct;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriParaObject;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriVariables;
import com.gigadevice.venustool.baseinfo.jtreenode.AbstractJTreeNode;
import com.gigadevice.venustool.baseinfo.jtreenode.JTreeComboxNode;
import com.gigadevice.venustool.clockconfiginfo.RCUCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrivilegeInfoExecute {
    public static Map<String, PeriPrivilegeInfo> PeriPrivilegeInfos = new HashMap<String, PeriPrivilegeInfo>();

    public static void InitPrivilegeInfo(String PeriName) {
        PeriName = GlobalVariables.GetMultipleTreePeriName((String)PeriName);
        GlobalPathUtil.PeriConfigXmlPaths xmlPathsObj = GlobalPathUtil.getPeriConfigXmlPaths((String)PeriName);
        String PrivilegeXmlPath = xmlPathsObj.PeriConflictXmlPath;
        if (!PeriPrivilegeInfos.containsKey(PeriName) && !PeriConfigPrivilegeXmlParse.ParsePrivilegeXml(PrivilegeXmlPath, PeriPrivilegeInfos)) {
            PeriPrivilegeInfo PeriPrivilegeInfoObj = new PeriPrivilegeInfo();
            PeriPrivilegeInfos.put(PeriName, PeriPrivilegeInfoObj);
            return;
        }
    }

    public static void PeriTreePrivilegeExecute(String PeriName, String ControlName, String ItemName, boolean OperType) {
        String GroupName = null;
        String MultipleTreePeriName = null;
        MultipleTreePeriName = GlobalVariables.GetMultipleTreePeriName((String)PeriName);
        if (!PeriName.equals(MultipleTreePeriName)) {
            GroupName = PeriName;
            PeriName = MultipleTreePeriName;
        }
        AbstractJTreeNode PeriParaTreeApply = ((GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName)).PeriParaTreeApply;
        PrivilegeInfoExecute.ExecutePrivilege(1, PeriName, GroupName, ControlName, ItemName, OperType, PeriParaTreeApply);
    }

    public static void ExecutePrivilege(int SourceType, String PeriName, String GroupName, String ControlName, String ItemName, boolean OperType, AbstractJTreeNode PeriParaTree) {
        if (!PeriPrivilegeInfos.containsKey(PeriName)) {
            return;
        }
        Map<String, List<String>> UserGroupInfo = PeriPrivilegeInfos.get(PeriName).getUserGroupInfo();
        Map<String, GroupInfo> GroupMapInfo = PeriPrivilegeInfos.get(PeriName).getGroupMapInfo();
        if (UserGroupInfo == null) {
            return;
        }
        List<String> ConditionList = PrivilegeInfoExecute.GetConditionList(SourceType, PeriName, GroupName, ControlName, ItemName);
        int i = 0;
        while (i < ConditionList.size()) {
            String Condition = ConditionList.get(i);
            if (UserGroupInfo.containsKey(Condition)) {
                List<String> UserGroup = UserGroupInfo.get(Condition);
                PrivilegeInfoExecute.ExecuteGroupPrivilege(UserGroup, GroupMapInfo, OperType, PeriParaTree);
            }
            ++i;
        }
    }

    public static List<String> GetConditionList(int SourceType, String ParentName, String GroupName, String ControlName, String ItemName) {
        ArrayList<String> ConditionList = new ArrayList<String>();
        if (SourceType == 0) {
            String ConditionSource = "0##" + ParentName + "##" + GroupName + "##" + ControlName;
            ConditionList.add(ConditionSource);
            ConditionSource = String.valueOf(ConditionSource) + "##" + ItemName;
            ConditionList.add(ConditionSource);
        } else if (SourceType == 1) {
            String ConditionSource = "1##" + ParentName;
            ConditionList.add(ConditionSource);
            if (GroupName != null) {
                ConditionSource = String.valueOf(ConditionSource) + "##" + GroupName;
                ConditionList.add(ConditionSource);
            }
            ConditionSource = String.valueOf(ConditionSource) + "##" + ControlName;
            ConditionList.add(ConditionSource);
            ConditionSource = String.valueOf(ConditionSource) + "##" + ItemName;
            ConditionList.add(ConditionSource);
        }
        return ConditionList;
    }

    public static void CheckClockPrivilege(String PeriName) {
        if (!PeriPrivilegeInfos.containsKey(PeriName)) {
            return;
        }
        Map<String, List<String>> UserGroupInfo = PeriPrivilegeInfos.get(PeriName).getUserGroupInfo();
        Map<String, GroupInfo> GroupMapInfo = PeriPrivilegeInfos.get(PeriName).getGroupMapInfo();
        if (UserGroupInfo == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : UserGroupInfo.entrySet()) {
            String User = entry.getKey();
            if (!User.contains("2##")) continue;
            List<String> UserGroup = UserGroupInfo.get(User);
            PrivilegeInfoExecute.ExecuteGroupPrivilege(UserGroup, GroupMapInfo, true, ((GeneralPeriParaObject)GeneralPeriVariables.GeneralPeriParaObjectList.get((Object)PeriName)).PeriParaTreeApply);
        }
    }

    public static void ExecuteGroupPrivilege(List<String> UserGroup, Map<String, GroupInfo> GroupMapInfo, boolean type, AbstractJTreeNode PeriParaTree) {
        int i = 0;
        while (i < UserGroup.size()) {
            GroupInfo GroupInfoObj;
            String Type2;
            String Group = UserGroup.get(i);
            if (GroupMapInfo.containsKey(Group) && PrivilegeInfoExecute.PrivilegeCheck(Type2 = (GroupInfoObj = GroupMapInfo.get(Group)).getType(), GroupInfoObj.getPrivilegeUserList(), PeriParaTree) == type) {
                PrivilegeControl PrivilegeControlObj = GroupInfoObj.getPrivilegeInfo();
                String GroupName = PrivilegeControlObj.getGroupName();
                String ControlName = PrivilegeControlObj.getControlName();
                String ControlType2 = PrivilegeControlObj.getControlType();
                String Privilege = PrivilegeControlObj.getPrivilege();
                System.out.print("GroupName:  " + GroupName + System.lineSeparator());
                System.out.print("ControlName:  " + ControlName + System.lineSeparator());
                System.out.print("Privilege:  " + Privilege + System.lineSeparator());
                if (ControlType2.equals("Item")) {
                    String ItemName = PrivilegeControlObj.getItemName();
                    System.out.print("ItemName:  " + ItemName + System.lineSeparator());
                    PrivilegeInfoExecute.UpdateItemStatus(GroupName, ControlName, ItemName, Privilege, type, PeriParaTree);
                } else {
                    PrivilegeInfoExecute.UpdateControlStatus(GroupName, ControlName, Privilege, ControlType2, type, PeriParaTree);
                }
            }
            ++i;
        }
    }

    public static String GetControlValue(String GroupName, String ControlName, AbstractJTreeNode PeriParaTree) {
        AbstractJTreeNode ParaNode = GeneralPeriConfigUtil.GetTreeNodeDependNodePath(PeriParaTree, GroupName, ControlName, false, false);
        if (ParaNode == null) {
            return "";
        }
        String value = ParaNode.getValue();
        if (ParaNode.getType() == 2) {
            String content = ((JTreeComboxNode)ParaNode).getContentDependItemValue(value);
            return content;
        }
        return value;
    }

    public static void UpdateControlValue(String GroupName, String ControlName, String ValueContent, AbstractJTreeNode PeriParaTree) {
        AbstractJTreeNode ParaNode = GeneralPeriConfigUtil.GetTreeNodeDependNodePath(PeriParaTree, GroupName, ControlName, false, false);
        if (ParaNode == null) {
            return;
        }
        if (ParaNode.getType() == 2) {
            String value = ((JTreeComboxNode)ParaNode).getValueDependItemContent(ValueContent);
            ParaNode.setValue(value);
        } else {
            ParaNode.setValue(ValueContent);
        }
    }

    private static void UpdateControlStatus(String GroupName, String ControlName, String Privilege, String ControlType2, boolean type, AbstractJTreeNode PeriParaTree) {
    }

    private static void UpdateItemStatus(String GroupName, String ControlName, String ItemContent, String Privilege, boolean type, AbstractJTreeNode PeriParaTree) {
        AbstractJTreeNode ParaNode = GeneralPeriConfigUtil.GetTreeNodeDependNodePath(PeriParaTree, GroupName, ControlName, false, false);
        if (ParaNode == null) {
            return;
        }
        if (Privilege.equals("Visible") && type || Privilege.equals("NotVisible") && !type) {
            ((JTreeComboxNode)ParaNode).updateComboxItemVisible(ItemContent, true);
        } else if (Privilege.equals("NotVisible") && type || Privilege.equals("Visible") && !type) {
            ((JTreeComboxNode)ParaNode).updateComboxItemVisible(ItemContent, false);
        } else if (Privilege.equals("UpdateValue") && type) {
            String value = ((JTreeComboxNode)ParaNode).getValueDependItemContent(ItemContent);
            ParaNode.setValue(value);
        } else if (Privilege.equals("SetDefaultValue") && type) {
            ((JTreeComboxNode)ParaNode).updateComboxItemVisible(ItemContent, true);
            String value = ((JTreeComboxNode)ParaNode).getValueDependItemContent(ItemContent);
            ParaNode.setDefaultValue(value);
        }
    }

    private static boolean PrivilegeCheck(String Type2, List<List<PrivilegeControl>> UserList, AbstractJTreeNode PeriParaTree) {
        if (Type2.equals("OR")) {
            return PrivilegeInfoExecute.OR(UserList, PeriParaTree);
        }
        if (Type2.equals("AND")) {
            return PrivilegeInfoExecute.AND(UserList, PeriParaTree);
        }
        if (Type2.equals("OR_AND")) {
            return PrivilegeInfoExecute.OR_AND(UserList, PeriParaTree);
        }
        if (Type2.equals("AND_OR")) {
            return PrivilegeInfoExecute.AND_OR(UserList, PeriParaTree);
        }
        return false;
    }

    private static boolean OR(List<List<PrivilegeControl>> UserList, AbstractJTreeNode PeriParaTree) {
        int i = 0;
        while (i < UserList.size()) {
            int j = 0;
            while (j < UserList.get(i).size()) {
                PrivilegeControl User = UserList.get(i).get(j);
                if (PrivilegeInfoExecute.UserCheck(User, PeriParaTree)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static boolean AND(List<List<PrivilegeControl>> UserList, AbstractJTreeNode PeriParaTree) {
        int i = 0;
        while (i < UserList.size()) {
            int j = 0;
            while (j < UserList.get(i).size()) {
                PrivilegeControl User = UserList.get(i).get(j);
                if (!PrivilegeInfoExecute.UserCheck(User, PeriParaTree)) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private static boolean OR_AND(List<List<PrivilegeControl>> UserList, AbstractJTreeNode PeriParaTree) {
        boolean sign = false;
        int i = 0;
        while (i < UserList.size()) {
            sign = true;
            int j = 0;
            while (j < UserList.get(i).size()) {
                PrivilegeControl User = UserList.get(i).get(j);
                if (!PrivilegeInfoExecute.UserCheck(User, PeriParaTree)) {
                    sign = false;
                }
                ++j;
            }
            if (sign) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean AND_OR(List<List<PrivilegeControl>> UserList, AbstractJTreeNode PeriParaTree) {
        boolean sign = false;
        int i = 0;
        while (i < UserList.size()) {
            sign = false;
            int j = 0;
            while (j < UserList.get(i).size()) {
                PrivilegeControl User = UserList.get(i).get(j);
                if (PrivilegeInfoExecute.UserCheck(User, PeriParaTree)) {
                    sign = true;
                }
                ++j;
            }
            if (!sign) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean UserCheck(PrivilegeControl User, AbstractJTreeNode PeriParaTree) {
        String Oper = User.getOper();
        if (Oper.equals("Equal")) {
            return PrivilegeInfoExecute.Equal(User, PeriParaTree);
        }
        if (Oper.equals("NotEqual")) {
            return PrivilegeInfoExecute.NotEqual(User, PeriParaTree);
        }
        return false;
    }

    private static boolean Equal(PrivilegeControl User, AbstractJTreeNode PeriParaTree) {
        if (User.getRelateFrom().equals("0")) {
            String ConfigValue = PrivilegeInfoExecute.GetControlValue(User.getGroupName(), User.getControlName(), PeriParaTree);
            if (ConfigValue == null) {
                return false;
            }
            if (ConfigValue.equals(User.getItemName()) || !User.getControlType().equals("Item")) {
                return true;
            }
        } else if (User.getRelateFrom().equals("1")) {
            if (User.getItemName().toUpperCase().equals("DISABLE")) {
                if (!GlobalVariables.PeripheralTreeMap.containsKey(User.getPeriName())) {
                    return true;
                }
                if (!((Map)GlobalVariables.PeripheralTreeMap.get(User.getPeriName())).containsKey(User.getControlName())) {
                    return true;
                }
            }
            String key = User.getPeriName();
            if (!User.getGroupName().equals("")) {
                key = User.getGroupName();
            }
            if (GlobalVariables.PeripheralTreeMap.containsKey(key)) {
                PerisItemsStruct temp;
                String tempValue;
                Map tempMap = (Map)GlobalVariables.PeripheralTreeMap.get(key);
                if (User.getControlName().equals("")) {
                    return true;
                }
                if (tempMap.containsKey(User.getControlName()) && (tempValue = (temp = (PerisItemsStruct)tempMap.get(User.getControlName())).getValue()).equals(User.getItemName())) {
                    return true;
                }
            }
        } else if (User.getRelateFrom().equals("2") && RCUCondition.GetRCUControlState((String)User.getControlName())) {
            return true;
        }
        return false;
    }

    private static boolean NotEqual(PrivilegeControl User, AbstractJTreeNode PeriParaTree) {
        return !PrivilegeInfoExecute.Equal(User, PeriParaTree);
    }
}

