/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.baseinfo;

import com.gigadevice.periconfigview.baseinfo.PeriConfigItem;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PeriConfigPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String Name = "";
    private int Type = 0;
    private String Content;
    private String Value = "";
    private boolean isEnable = true;
    private String CommonPart = "";
    private int Row = 0;
    private int Col = 0;
    private String MinStr;
    private String MaxStr;
    private long Min = 0L;
    private long Max = 0L;
    private List<PeriConfigItem> IemList = new ArrayList<PeriConfigItem>();
    private int UILocation;
    private int valueFormat;
    private boolean hasMax;
    private boolean hasMin;
    private String valueValidTips;

    public PeriConfigPart() {
        this.setUILocation(DMAConfigUtil.UILocation.isTable.ordinal());
        this.hasMax = false;
        this.hasMin = false;
        this.valueFormat = 10;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String Name) {
        this.Name = Name;
    }

    public int getType() {
        return this.Type;
    }

    public void setType(int Type2) {
        this.Type = Type2;
    }

    public String getContent() {
        return this.Content;
    }

    public void setContent(String Content) {
        this.Content = Content;
    }

    public String getValue() {
        return this.Value;
    }

    public void setValue(String Value) {
        this.Value = Value;
        if (Value.toUpperCase().contains("0X")) {
            this.valueFormat = 16;
        }
    }

    public boolean getisEnable() {
        return this.isEnable;
    }

    public void setisEnable(boolean isEnable) {
        this.isEnable = isEnable;
    }

    public String getCommonPart() {
        return this.CommonPart;
    }

    public void setCommonPart(String CommonPart) {
        this.CommonPart = CommonPart;
    }

    public int getRow() {
        return this.Row;
    }

    public void setRow(int Row2) {
        this.Row = Row2;
    }

    public int getCol() {
        return this.Col;
    }

    public void setCol(int Col) {
        this.Col = Col;
    }

    public long getMin() {
        return this.Min;
    }

    public void setMin(long Min) {
        this.Min = Min;
    }

    public long getMax() {
        return this.Max;
    }

    public void setMax(long Max) {
        this.Max = Max;
    }

    public List<PeriConfigItem> getIemList() {
        return this.IemList;
    }

    public void setIemList(PeriConfigItem Item) {
        this.IemList.add(Item);
    }

    public int getIntegerByString(String Value) {
        if (Value.equals("")) {
            return 0;
        }
        long result = -1L;
        try {
            result = Long.parseLong(Value);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return (int)result;
    }

    public long getLongByString(String Value) {
        if (Value.equals("")) {
            return 0L;
        }
        long result = -1L;
        try {
            if (Value.toUpperCase().contains("0X")) {
                if (DMAConfigUtil.isValidHexadecimal(Value)) {
                    result = Long.parseLong(Value.substring(2), 16);
                }
            } else {
                result = Long.parseLong(Value);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setAttrValue(String key, String Value) {
        switch (key) {
            case "name": {
                this.setName(Value);
                break;
            }
            case "value": {
                this.setValue(Value);
                break;
            }
            case "commonPart": {
                this.setCommonPart(Value);
                break;
            }
            case "type": {
                this.setType(this.getIntegerByString(Value));
                break;
            }
            case "row": {
                this.setRow(this.getIntegerByString(Value));
                break;
            }
            case "col": {
                this.setCol(this.getIntegerByString(Value));
                break;
            }
            case "minValue": {
                this.setMin(this.getLongByString(Value));
                this.setMinStr(Value);
                this.setHasMax(true);
                break;
            }
            case "maxValue": {
                this.setMax(this.getLongByString(Value));
                this.setMaxStr(Value);
                this.setHasMin(true);
            }
        }
    }

    public int getUILocation() {
        return this.UILocation;
    }

    public void setUILocation(int uILocation) {
        this.UILocation = uILocation;
    }

    public boolean isHasMax() {
        return this.hasMax;
    }

    public void setHasMax(boolean hasMax) {
        this.hasMax = hasMax;
    }

    public boolean isHasMin() {
        return this.hasMin;
    }

    public void setHasMin(boolean hasMin) {
        this.hasMin = hasMin;
    }

    public int getValueFormat() {
        return this.valueFormat;
    }

    public void setValueFormat(int valueFormat) {
        this.valueFormat = valueFormat;
    }

    public String getValueValidTips() {
        String format = "decimal";
        if (this.valueFormat == 16) {
            format = "hexadecimal";
        }
        String messageInfo = "The input format should be " + format + ", and the input range should be [" + this.MinStr + "," + this.MaxStr + "].";
        return messageInfo;
    }

    public void setValueValidTips(String valueValidTips) {
        this.valueValidTips = valueValidTips;
    }

    public String getMinStr() {
        return this.MinStr;
    }

    public void setMinStr(String minStr) {
        this.MinStr = minStr;
    }

    public String getMaxStr() {
        return this.MaxStr;
    }

    public void setMaxStr(String maxStr) {
        this.MaxStr = maxStr;
    }
}

