/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.periconfigview.PeriConfigFrame;
import com.gigadevice.periconfigview.utils.PerisConfigUtil;
import com.gigadevice.venustool.ConstantsUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.mcubasestruct.ModuleStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigGroupStruct;
import com.gigadevice.venustool.periconfigbasestruct.PeriConfigViewNodeStruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class PeriConfigurationView {
    public static JPanel panel;
    private static JPanel FilterPanel;
    private static JPanel PeriConfigPanel;
    private static ButtonGroup RadioGroup;
    private static Map<String, List<String>> FilterConditons;

    public static JComponent createPartControl() {
        panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(Color.white);
        JScrollPane ScrollPane = new JScrollPane(panel, 20, 30);
        ScrollPane.getVerticalScrollBar().setUnitIncrement(15);
        ScrollPane.getHorizontalScrollBar().setUnitIncrement(15);
        JViewport viewport = ScrollPane.getViewport();
        viewport.setBackground(Color.white);
        FilterPanel = new JPanel();
        FilterPanel.setPreferredSize(new Dimension(1000, 200));
        FilterPanel.setBackground(Color.white);
        JPanel panelSOUTH = new JPanel();
        panelSOUTH.setPreferredSize(new Dimension(1000, 100));
        panelSOUTH.setBackground(Color.white);
        JPanel panelEAST = new JPanel();
        panelEAST.setPreferredSize(new Dimension(100, 100));
        panelEAST.setBackground(Color.white);
        JPanel panelWEST = new JPanel();
        panelWEST.setPreferredSize(new Dimension(100, 100));
        panelWEST.setBackground(Color.white);
        panel.add((Component)FilterPanel, "North");
        panel.add((Component)panelSOUTH, "South");
        panel.add((Component)panelEAST, "East");
        panel.add((Component)panelWEST, "West");
        PeriConfigPanel = new JPanel();
        PeriConfigPanel.setBackground(Color.white);
        FlowLayout f = (FlowLayout)PeriConfigPanel.getLayout();
        f.setHgap(50);
        panel.add((Component)PeriConfigPanel, "Center");
        PerisConfigUtil.InitAllGlobalVars();
        PeriConfigurationView.InitPanel();
        PeriConfigurationView.UpdatePeriConfigPanel();
        JScrollPane scrollPane = new JScrollPane(panel);
        return scrollPane;
    }

    public static void InitPanel() {
        PeriConfigurationView.InitFilterPanel();
        PeriConfigurationView.InitPeriConfigPanel();
    }

    public static void UpdatePeriConfigPanel() {
        int PeriTypeGroupCount = PeriConfigPanel.getComponentCount();
        int g = 0;
        while (g < PeriTypeGroupCount) {
            JPanel PeriTypePanel = (JPanel)PeriConfigPanel.getComponent(g);
            String PeriTypeName = PeriTypePanel.getName();
            if (GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap().containsKey(PeriTypeName)) {
                PeriTypePanel.removeAll();
                PeriConfigGroupStruct PeriGroupObj = (PeriConfigGroupStruct)GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap().get(PeriTypeName);
                LinkedHashMap PeriList = PeriGroupObj.getNodeList();
                int PeriIndex = 0;
                for (Map.Entry PeriEntry : PeriList.entrySet()) {
                    String PeriName = (String)PeriEntry.getKey();
                    boolean state = false;
                    if (GlobalVariables.PeripheralConfigObjMap.containsKey(PeriName)) {
                        state = PeriConfigurationView.getPeriState(PeriName);
                        if (((PeriConfigViewNodeStruct)PeriEntry.getValue()).getState() == 2) {
                            state = false;
                        }
                    } else if (((PeriConfigViewNodeStruct)PeriEntry.getValue()).getState() == 0) {
                        state = true;
                    } else if (((PeriConfigViewNodeStruct)PeriEntry.getValue()).getState() == 2) {
                        state = false;
                    }
                    if (!state) continue;
                    final JButton jButton = new JButton();
                    jButton.setText(PeriName);
                    jButton.setName(PeriName);
                    jButton.setBackground(new Color(176, 226, 255));
                    jButton.setPreferredSize(new Dimension(160, 30));
                    Font f = new Font("Arial", 1, 15);
                    jButton.setFont(f);
                    PeriTypePanel.add((Component)jButton, PeriIndex);
                    ++PeriIndex;
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PeriConfigFrame frame = new PeriConfigFrame(jButton.getText());
                            frame.setTitle(jButton.getText());
                            frame.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                            frame.setAlwaysOnTop(true);
                            frame.setLocationRelativeTo(null);
                            frame.setResizable(true);
                            frame.setVisible(true);
                            frame.setLayout(new BorderLayout());
                        }
                    });
                }
            }
            ++g;
        }
    }

    private static void InitFilterPanel() {
        FilterConditons = new HashMap<String, List<String>>();
        RadioGroup = new ButtonGroup();
        FilterConditons.clear();
        for (Map.Entry entry : GlobalVariables.PeriConfigViewObj.getFilterGroupMap().entrySet()) {
            PeriConfigGroupStruct FilterGroupObj = (PeriConfigGroupStruct)entry.getValue();
            String FilterGroupContent = FilterGroupObj.getContent();
            LinkedHashMap ControlList = FilterGroupObj.getNodeList();
            int controlNum = ControlList.size();
            final String ActionType = FilterGroupObj.getActionType();
            JPanel FilterObj = new JPanel();
            FilterObj.setLayout(new GridLayout(1, controlNum, 10, 20));
            FilterObj.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(5, 104, 176), 2), FilterGroupContent, 1, 2, new Font("Arial", 0, 15)));
            FilterObj.setBackground(Color.white);
            FilterPanel.add(FilterObj);
            for (Map.Entry entryCtl : ControlList.entrySet()) {
                PeriConfigViewNodeStruct Control2 = (PeriConfigViewNodeStruct)entryCtl.getValue();
                int ControlType2 = Control2.getType();
                String ControlContent = Control2.getContent();
                final String ControlName = Control2.getName();
                final String Action2 = Control2.getAction();
                if (ControlType2 == ConstantsUtil.ControlType.CheckBox.ordinal()) {
                    final JCheckBox CheckBox = new JCheckBox();
                    CheckBox.setText(ControlContent);
                    CheckBox.setFont(new Font("Arial", 0, 25));
                    CheckBox.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (Action2.equals("True")) {
                                if (CheckBox.isSelected()) {
                                    PeriConfigurationView.addFilterConditons(ActionType, ControlName);
                                } else {
                                    PeriConfigurationView.removeFilterConditons(ActionType, ControlName);
                                }
                                PeriConfigurationView.UpdatePeriConfigPanel();
                            }
                        }
                    });
                    FilterObj.add(CheckBox);
                    continue;
                }
                if (ControlType2 != ConstantsUtil.ControlType.Radio.ordinal()) continue;
                final JRadioButton Radio = new JRadioButton();
                Radio.setText(ControlContent);
                if (Control2.getState() != 0) {
                    Radio.setSelected(true);
                }
                Radio.setFont(new Font("Arial", 0, 25));
                Radio.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        if (Action2.equals("True")) {
                            if (Radio.isSelected()) {
                                PeriConfigurationView.addFilterConditons(ActionType, ControlName);
                            } else {
                                PeriConfigurationView.removeFilterConditons(ActionType, ControlName);
                            }
                            PeriConfigurationView.UpdatePeriConfigPanel();
                        }
                    }
                });
                RadioGroup.add(Radio);
                FilterObj.add(Radio);
            }
        }
    }

    public static void InitPeriConfigPanel() {
        PeriConfigPanel.removeAll();
        new HashMap();
        LinkedHashMap PeriTypeGroupMap = GlobalVariables.PeriConfigViewObj.getPeriTypeGroupMap();
        int PeriTypeGroupIndex = 0;
        for (Map.Entry entry : PeriTypeGroupMap.entrySet()) {
            String PeriTypeGroupName = (String)entry.getKey();
            if (PeriTypeGroupName.equals("MiddleWare") && !PeriConfigurationView.hasMiddleWares()) continue;
            JPanel panelobj = new JPanel();
            panelobj.setLayout(new GridLayout(10, 1, 20, 10));
            panelobj.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(5, 104, 176), 2), PeriTypeGroupName, 2, 2, new Font("Arial", 0, 25)));
            panelobj.setBackground(Color.white);
            panelobj.setName(PeriTypeGroupName);
            PeriConfigPanel.add((Component)panelobj, PeriTypeGroupIndex);
            ++PeriTypeGroupIndex;
        }
    }

    private static boolean getPeriState(String Name) {
        boolean state = true;
        for (Map.Entry<String, List<String>> entry : FilterConditons.entrySet()) {
            String ActionType = entry.getKey();
            List<String> controlList = entry.getValue();
            int i = 0;
            while (i < controlList.size()) {
                boolean conditon = ConflictCheck.conditionCheckByExtentNode((String)Name, (String)ActionType, (String)controlList.get(i));
                state &= conditon;
                ++i;
            }
        }
        return state &= GlobalVariables.PeripheralConfigObjMap.containsKey(Name);
    }

    private static void addFilterConditons(String ActionType, String Value) {
        if (FilterConditons.containsKey(ActionType)) {
            List<String> valueList = FilterConditons.get(ActionType);
            valueList.add(Value);
            FilterConditons.remove(ActionType);
            FilterConditons.put(ActionType, valueList);
        } else {
            ArrayList<String> value = new ArrayList<String>();
            value.add(Value);
            FilterConditons.put(ActionType, value);
        }
    }

    private static void removeFilterConditons(String ActionType, String Value) {
        if (FilterConditons.containsKey(ActionType)) {
            List<String> valueList = FilterConditons.get(ActionType);
            int removeIndex = 0;
            boolean exist = false;
            int i = 0;
            while (i < valueList.size()) {
                if (valueList.get(i).compareTo(Value) == 0) {
                    removeIndex = i;
                    exist = true;
                }
                ++i;
            }
            if (exist) {
                valueList.remove(removeIndex);
            }
            FilterConditons.remove(ActionType);
            FilterConditons.put(ActionType, valueList);
        }
    }

    private static boolean hasMiddleWares() {
        boolean ifMiddleWares = false;
        LinkedHashMap modules_map = GlobalVariables.MCUObj.getModules();
        for (String key : GlobalVariables.MCUObj.getModules().keySet()) {
            int state = ((ModuleStruct)modules_map.get(key)).getState();
            int res = state >> 6 & 1;
            if (!((ModuleStruct)modules_map.get(key)).getModuleType().equals("MiddleWare") || res == 1) continue;
            ifMiddleWares = true;
        }
        return ifMiddleWares;
    }

    public static void UpdatePanel() {
    }
}

