/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.DMAConflictExecute;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.ControlStateInfo;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.periconfigview.baseinfo.PeriConfigItem;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.baseinfo.systemperi.DMAEventStruct;
import com.gigadevice.periconfigview.model.JComboBoxCellEditor;
import com.gigadevice.periconfigview.model.MyEvent;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.dma.DMAConfigInfo;
import com.gigadevice.venustool.baseinfo.mComboBox;
import com.gigadevice.venustool.mcubasestruct.NodeStruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class DMAConfigView {
    private JPanel panel;
    private JScrollPane scrollPane;
    private JTable table_DMA;
    private DefaultTableModel model_DMA;
    private JPanel panel_DMAReqSet;
    private JButton btn_Add;
    private JButton btn_Delete;
    private JPanel buttonPanel;
    private JPanel topPanel;
    private int width = 0;
    private int height = 0;
    private int dmaRequestColumn = -1;
    private int channelColumn = -1;
    Vector<Object> headVector;
    String ConfigPeriName = "";
    private List<String> DMARequestList = new ArrayList<String>();
    private static final Insets insets = new Insets(0, 0, 0, 0);
    private Map<Integer, JComboBoxCellEditor> ComboBoxEditorMap;
    private Map<String, Component> requestComponentMap = new HashMap<String, Component>();

    public DMAConfigView(String PeriName) {
        this.ConfigPeriName = PeriName;
        this.initPeriDMARequest();
        ConflictUtil.InitPrivilegeXmlInfo((String)"DMA");
    }

    private void initPeriDMARequest() {
        if ("DMA".equals(this.ConfigPeriName)) {
            this.AddPeriDMARequest("DMA");
            for (Map.Entry entry : GlobalVariables.PeripheralConfigObjMap.entrySet()) {
                this.AddPeriDMARequest((String)entry.getKey());
            }
        } else if ("MEMTOMEM".equals(this.ConfigPeriName)) {
            this.DMARequestList.add("MEMTOMEM");
        } else {
            this.AddPeriDMARequest(this.ConfigPeriName);
        }
    }

    private void AddPeriDMARequest(String PeriNameStr) {
        if (DMAConfigUtil.dmaAllInfo.getPeriModeEventInfo().size() == 0) {
            if (!DMAConfigUtil.dmaAllInfo.getConfigInfoMap().containsKey(PeriNameStr)) {
                return;
            }
            Map<String, List<PeriConfigPart>> DMAConfigInfoMap = DMAConfigUtil.dmaAllInfo.getConfigInfoMap().get(PeriNameStr);
            for (Map.Entry<String, List<PeriConfigPart>> entry : DMAConfigInfoMap.entrySet()) {
                String requestName = entry.getKey();
                if (DMAConfigUtil.dmaAllInfo.getRequestConditionMap().containsKey(requestName)) {
                    ConflictGroupInfo ConflictGroupObj = DMAConfigUtil.dmaAllInfo.getRequestConditionMap().get(requestName);
                    if (!ConflictCheck.ConditionCheck((ConflictGroupInfo)ConflictGroupObj)) continue;
                    this.DMARequestList.add(requestName);
                    continue;
                }
                this.DMARequestList.add(requestName);
            }
            return;
        }
        if (!DMAConfigUtil.dmaAllInfo.getPeriModeEventInfo().containsKey(PeriNameStr)) {
            return;
        }
        Map<String, DMAEventStruct> ModeEventInfo = DMAConfigUtil.dmaAllInfo.getPeriModeEventInfo().get(PeriNameStr);
        Map NodeMap = (Map)GlobalVariables.PeripheralConfigObjMap.get(PeriNameStr);
        block1: for (Map.Entry<String, DMAEventStruct> entry : ModeEventInfo.entrySet()) {
            String ModeName = entry.getKey();
            if (ModeName.equals("")) {
                this.DMARequestList.addAll(entry.getValue().getEventSet());
                continue;
            }
            if (NodeMap == null) {
                return;
            }
            int Type2 = entry.getValue().getType();
            if (Type2 == 1) {
                for (Map.Entry NodeMapEntry : NodeMap.entrySet()) {
                    NodeStruct NodeObj = (NodeStruct)NodeMapEntry.getValue();
                    String ItemName = NodeObj.getValue();
                    if (!ModeName.equals(ItemName)) continue;
                    this.DMARequestList.addAll(entry.getValue().getEventSet());
                    continue block1;
                }
                continue;
            }
            if (Type2 != 0 || !NodeMap.containsKey(ModeName)) continue;
            this.DMARequestList.addAll(entry.getValue().getEventSet());
        }
    }

    public void setSize(int arg0, int arg1) {
        this.width = arg0;
        this.height = arg1;
        if (this.panel != null) {
            this.updateLayout();
        }
    }

    private void updateLayout() {
        if (this.panel == null) {
            return;
        }
        int currentWidth = this.panel.getWidth();
        int currentHeight = this.panel.getHeight();
        if (currentWidth > 0 && currentHeight > 0) {
            this.width = currentWidth;
            this.height = currentHeight;
        }
        if (this.topPanel != null) {
            int topHeight = Math.max(150, this.height / 3);
            this.topPanel.setPreferredSize(new Dimension(this.width, topHeight));
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    public void refreshLayout() {
        this.updateLayout();
    }

    public JPanel returnDMAConfigPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.topPanel.add((Component)this.scrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.btn_Delete = new JButton("Delete");
        this.btn_Add = new JButton("Add");
        this.buttonPanel.add(this.btn_Delete);
        this.buttonPanel.add(this.btn_Add);
        this.topPanel.add((Component)this.buttonPanel, "South");
        this.panel.add((Component)this.topPanel, "North");
        GridBagLayout layout = new GridBagLayout();
        this.panel_DMAReqSet = new JPanel(layout);
        this.panel.add((Component)this.panel_DMAReqSet, "Center");
        this.btn_Add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DMAConfigView.this.addInitDMATableRow();
            }
        });
        this.btn_Delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = DMAConfigView.this.table_DMA.getSelectedRow();
                if (row >= 0) {
                    GlobalVariables.isDirtyFlag = true;
                    DMAConfigView.this.DeleteDMATableRow(row);
                    DMAConfigView.this.ReloadDMAConfigPanel();
                }
            }
        });
        this.panel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DMAConfigView.this.updateLayout();
            }
        });
        this.InitDMATableModel();
        this.LoadDMAConfigInfo();
        this.updateLayout();
        return this.panel;
    }

    public void UpdateView() {
        this.ReloadDMAConfigPanel();
        this.updateLayout();
    }

    public void RestoreDMAConfigInfo() {
        int i = this.model_DMA.getRowCount() - 1;
        while (i >= 0) {
            this.DeleteDMATableRow(i);
            --i;
        }
        this.ReloadDMAConfigPanel();
    }

    public void ReloadDMAConfigPanel() {
        this.panel_DMAReqSet.removeAll();
        this.InitDMATableModel();
        this.LoadDMAConfigInfo();
        this.updateLayout();
        this.panel.updateUI();
    }

    public void InitDMATableModel() {
        this.model_DMA = new DefaultTableModel();
        this.headVector = new Vector();
        if (DMAConfigUtil.dmaAllInfo.getConfigInfoMap().size() == 0) {
            return;
        }
        List<PeriConfigPart> periConfigs = DMAConfigUtil.dmaAllInfo.getConfigInfoMap().get("ColumnInfos").get("ColumnInfos");
        int i = 0;
        while (i < periConfigs.size()) {
            PeriConfigPart PeriConfigObj = periConfigs.get(i);
            this.headVector.add(PeriConfigObj.getName());
            ++i;
        }
        this.model_DMA.setDataVector(null, this.headVector);
        this.table_DMA = new JTable(this.model_DMA);
        this.table_DMA.getTableHeader().setReorderingAllowed(false);
        JTableHeader head = this.table_DMA.getTableHeader();
        head.setFont(new Font("Arial", 1, 15));
        this.table_DMA.setFont(new Font("Arial", 1, 15));
        this.table_DMA.setRowHeight(25);
        this.table_DMA.setShowHorizontalLines(true);
        this.table_DMA.setShowVerticalLines(true);
        this.scrollPane.setViewportView(this.table_DMA);
        this.ComboBoxEditorMap = new HashMap<Integer, JComboBoxCellEditor>();
        int i2 = 0;
        while (i2 < periConfigs.size()) {
            final PeriConfigPart PeriConfigObj = periConfigs.get(i2);
            if (PeriConfigObj.getName().equals("DMA Request")) {
                this.dmaRequestColumn = PeriConfigObj.getCol();
            }
            if (PeriConfigObj.getName().equals("Channel")) {
                this.channelColumn = PeriConfigObj.getCol();
            }
            if (PeriConfigObj.getType() == 2) {
                final JComboBoxCellEditor JComboBoxCellEditor2 = new JComboBoxCellEditor();
                this.table_DMA.getColumnModel().getColumn(PeriConfigObj.getCol()).setCellEditor(JComboBoxCellEditor2);
                this.ComboBoxEditorMap.put(PeriConfigObj.getCol(), JComboBoxCellEditor2);
                MyEvent e = new MyEvent(){

                    @Override
                    public void invoke(ItemEvent e) {
                        JComboBox ComboBoxObj = (JComboBox)e.getSource();
                        int rowIndex = JComboBoxCellEditor2.getSelectedIndex();
                        String comboxCurrentStr = ComboBoxObj.getSelectedItem().toString();
                        if (PeriConfigObj.getCol() == DMAConfigView.this.dmaRequestColumn) {
                            DMAConfigView.this.DMARequestSelectedUpdateTabel(comboxCurrentStr);
                        } else {
                            DMAConfigView.this.tableRowComboxChanged(rowIndex, PeriConfigObj.getCol(), PeriConfigObj.getName(), comboxCurrentStr);
                        }
                    }
                };
                JComboBoxCellEditor2.SetEvent(e);
            }
            ++i2;
        }
        this.table_DMA.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = DMAConfigView.this.table_DMA.getSelectedRow();
                if (rowIndex < 0) {
                    return;
                }
                String DMARequest = DMAConfigView.this.model_DMA.getValueAt(rowIndex, 0).toString();
                if (rowIndex >= 0 && !DMARequest.equals("Selected")) {
                    String ChannelName = DMAConfigView.this.model_DMA.getValueAt(rowIndex, DMAConfigView.this.channelColumn).toString();
                    DMAConfigView.this.InitDMARequestSettingPanel(DMAConfigUtil.GetDMAConfigInfo(ChannelName));
                    DMAConfigView.this.panel.updateUI();
                }
            }
        });
    }

    public void LoadDMAConfigInfo() {
        if (this.ConfigPeriName.equals("DMA")) {
            for (Map.Entry<String, LinkedHashMap<String, DMAConfigInfo>> entry0 : DMAConfigUtil.TemDMAConfigInfo.entrySet()) {
                for (Map.Entry<String, DMAConfigInfo> entry : entry0.getValue().entrySet()) {
                    this.AddTableRow(entry.getValue());
                }
            }
        } else if (this.ConfigPeriName.equals("MEMTOMEM")) {
            if (!DMAConfigUtil.TemDMAConfigInfo.containsKey("DMA")) {
                return;
            }
            Map DMAConfigInfoMap = DMAConfigUtil.TemDMAConfigInfo.get("DMA");
            for (Map.Entry entry1 : DMAConfigInfoMap.entrySet()) {
                this.AddTableRow((DMAConfigInfo)entry1.getValue());
            }
        } else {
            if (!DMAConfigUtil.TemDMAConfigInfo.containsKey(this.ConfigPeriName)) {
                return;
            }
            Map DMAConfigInfoMap = DMAConfigUtil.TemDMAConfigInfo.get(this.ConfigPeriName);
            for (Map.Entry entry1 : DMAConfigInfoMap.entrySet()) {
                this.AddTableRow((DMAConfigInfo)entry1.getValue());
            }
        }
    }

    public void addInitDMATableRow() {
        this.DMARequestList.clear();
        this.initPeriDMARequest();
        if (this.model_DMA.getRowCount() > 0 && this.model_DMA.getValueAt(this.model_DMA.getRowCount() - 1, this.dmaRequestColumn).toString().equals("Selected")) {
            return;
        }
        ArrayList<String> RequestItemList = new ArrayList<String>();
        RequestItemList.add("Selected");
        Collections.sort(this.DMARequestList);
        RequestItemList.addAll(this.DMARequestList);
        int i = 0;
        while (i < this.model_DMA.getRowCount()) {
            String DMARequestStr = this.model_DMA.getValueAt(i, this.dmaRequestColumn).toString();
            if (!DMARequestStr.equals("MEMTOMEM")) {
                RequestItemList.remove(DMARequestStr);
            }
            ++i;
        }
        this.ComboBoxEditorMap.get(this.dmaRequestColumn).setItem(RequestItemList, this.model_DMA.getRowCount());
        this.model_DMA.addRow(new Object[]{RequestItemList.get(0), "", "", ""});
        this.model_DMA.fireTableDataChanged();
    }

    public void AddTableRow(DMAConfigInfo DMAConfigInfoObj) {
        String DMARequest = DMAConfigInfoObj.getDMARequest();
        Map ContorlInfoMap = DMAConfigInfoObj.getContorlInfoMap();
        Object[] object = new Object[ContorlInfoMap.size() + 1];
        object[this.dmaRequestColumn] = DMARequest;
        for (Map.Entry entry : ContorlInfoMap.entrySet()) {
            String ContorlName = (String)entry.getKey();
            int Col = this.getCol(ContorlName);
            if (Col == -1) continue;
            object[Col] = entry.getValue();
        }
        this.model_DMA.addRow(object);
        ArrayList<String> DMARequestlList = new ArrayList<String>();
        DMARequestlList.add(DMARequest);
        this.ComboBoxEditorMap.get(this.dmaRequestColumn).setItem(DMARequestlList, this.model_DMA.getRowCount() - 1);
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : DMAConfigUtil.dmaAllInfo.getConfigInfoMap().entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(DMARequest)) continue;
            List<PeriConfigPart> PartList = PartsMap.get(DMARequest);
            int i = 0;
            while (i < PartList.size()) {
                PeriConfigPart partObj = PartList.get(i);
                if (partObj.getCol() != this.dmaRequestColumn) {
                    ArrayList<String> comboxItemList = new ArrayList<String>();
                    List<PeriConfigItem> IemList = partObj.getIemList();
                    int j = 0;
                    while (j < IemList.size()) {
                        if (partObj.getCol() == this.channelColumn) {
                            String Channel2 = IemList.get(j).getName();
                            if (!DMAConfigUtil.UsedChannelList.contains(Channel2) || object[this.channelColumn].equals(Channel2)) {
                                comboxItemList.add(Channel2);
                            }
                        } else {
                            comboxItemList.add(IemList.get(j).getName());
                        }
                        ++j;
                    }
                    this.ComboBoxEditorMap.get(partObj.getCol()).setItem(comboxItemList, this.model_DMA.getRowCount() - 1);
                }
                ++i;
            }
        }
    }

    public void DeleteDMATableRow(int row) {
        this.table_DMA.clearSelection();
        String ChannelName = this.model_DMA.getValueAt(row, this.channelColumn).toString();
        this.model_DMA.removeRow(row);
        DMAConfigUtil.UsedChannelList.remove(ChannelName);
        DMAConfigUtil.DeleteDMAConfigInfo(ChannelName);
        this.panel_DMAReqSet.removeAll();
    }

    public void DMARequestSelectedUpdateTabel(String DMARequestName) {
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : DMAConfigUtil.dmaAllInfo.getConfigInfoMap().entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(DMARequestName)) continue;
            List<PeriConfigPart> PartList = PartsMap.get(DMARequestName);
            ArrayList<String> DMARequestList = new ArrayList<String>();
            DMARequestList.add(DMARequestName);
            this.ComboBoxEditorMap.get(this.dmaRequestColumn).setItem(DMARequestList, this.model_DMA.getRowCount() - 1);
            Object[] object = new Object[PartList.size()];
            object[this.dmaRequestColumn] = DMARequestName;
            DMAConfigInfo dmaConfigInfo = new DMAConfigInfo();
            dmaConfigInfo.setDMARequest(DMARequestName);
            int i = 0;
            while (i < PartList.size()) {
                PeriConfigPart partObj = PartList.get(i);
                if (partObj.getUILocation() == DMAConfigUtil.UILocation.isTable.ordinal() && partObj.getCol() != this.dmaRequestColumn) {
                    int t;
                    ArrayList<String> comboxItemList = new ArrayList<String>();
                    List<PeriConfigItem> IemList = partObj.getIemList();
                    if (partObj.getCol() == this.channelColumn) {
                        t = 0;
                        while (t < IemList.size()) {
                            String ChannelName = IemList.get(t).getName();
                            dmaConfigInfo.setChannelList(ChannelName);
                            if (!DMAConfigUtil.UsedChannelList.contains(ChannelName)) {
                                comboxItemList.add(ChannelName);
                            }
                            ++t;
                        }
                        if (comboxItemList.size() == 0) {
                            Frame frame = new Frame();
                            frame.setAlwaysOnTop(true);
                            Object[] options = new Object[]{"OK"};
                            JOptionPane.showOptionDialog(frame, "No channel can be assigned!", "Message", -1, -1, null, options, options[0]);
                            this.model_DMA.removeRow(this.model_DMA.getRowCount() - 1);
                            this.ReloadDMAConfigPanel();
                            return;
                        }
                    } else {
                        t = 0;
                        while (t < IemList.size()) {
                            comboxItemList.add(IemList.get(t).getName());
                            ++t;
                        }
                    }
                    object[partObj.getCol()] = comboxItemList.get(0);
                    dmaConfigInfo.setContorlValue(partObj.getName(), (String)comboxItemList.get(0));
                    this.ComboBoxEditorMap.get(partObj.getCol()).setItem(comboxItemList, this.model_DMA.getRowCount() - 1);
                }
                ++i;
            }
            this.model_DMA.removeRow(this.model_DMA.getRowCount() - 1);
            this.model_DMA.insertRow(this.model_DMA.getRowCount(), object);
            this.InitDMARequestSettingPanel(dmaConfigInfo);
            DMAConfigUtil.UsedChannelList.add(object[this.channelColumn].toString());
            DMAConfigUtil.AddDMAConfigInfo(dmaConfigInfo);
            this.UpdateChannelColumnCombox(this.channelColumn, object[this.channelColumn].toString(), this.model_DMA.getRowCount() - 1);
            this.table_DMA.updateUI();
            return;
        }
    }

    private void tableRowComboxChanged(int row, int column, String ContorlName, String SelectedValue) {
        if (row < 0) {
            return;
        }
        if (column == this.dmaRequestColumn) {
            return;
        }
        if (column == this.channelColumn) {
            String formChannel = this.model_DMA.getValueAt(row, this.channelColumn).toString();
            if (formChannel.equals(SelectedValue)) {
                return;
            }
            DMAConfigUtil.UsedChannelList.remove(formChannel);
            DMAConfigUtil.UsedChannelList.add(SelectedValue);
            this.model_DMA.setValueAt(SelectedValue, row, this.channelColumn);
            DMAConfigUtil.ChannelSwitchtoInfoUpdate(formChannel, SelectedValue);
            this.UpdateChannelColumnCombox(ChannelOp.ChannelSwitch.ordinal(), SelectedValue, row);
        } else {
            String ChannelName = this.model_DMA.getValueAt(row, this.channelColumn).toString();
            this.model_DMA.setValueAt(SelectedValue, row, column);
            DMAConfigUtil.GetDMAConfigInfo(ChannelName).setContorlValue(ContorlName, SelectedValue);
        }
    }

    private void UpdateChannelColumnCombox(int channelOp, String SeletedChannel, int row) {
        int i = 0;
        while (i < this.model_DMA.getRowCount()) {
            ArrayList<String> SelectChannelList = new ArrayList<String>();
            String Channel2 = this.model_DMA.getValueAt(i, this.channelColumn).toString();
            String DMARequest = this.model_DMA.getValueAt(i, this.dmaRequestColumn).toString();
            List<String> ChannelList = DMAConfigUtil.ReturnChannelList(DMARequest);
            int j = 0;
            while (j < ChannelList.size()) {
                if (!DMAConfigUtil.UsedChannelList.contains(ChannelList.get(j))) {
                    SelectChannelList.add(ChannelList.get(j));
                } else if (row == i && channelOp == ChannelOp.ChannelSwitch.ordinal() && SeletedChannel.equals(ChannelList.get(j))) {
                    SelectChannelList.add(SeletedChannel);
                } else if (channelOp == ChannelOp.ChannelRelease.ordinal() && SeletedChannel.equals(ChannelList.get(j))) {
                    SelectChannelList.add(SeletedChannel);
                } else if (this.model_DMA.getValueAt(i, 1).equals(ChannelList.get(j))) {
                    SelectChannelList.add(ChannelList.get(j));
                }
                ++j;
            }
            this.ComboBoxEditorMap.get(this.channelColumn).setItem(SelectChannelList, i);
            DMAConfigUtil.GetDMAConfigInfo(Channel2).setChannelList(SelectChannelList);
            ++i;
        }
    }

    private int getCol(String ColName) {
        int i = 0;
        while (i < this.headVector.size()) {
            if (this.headVector.get(i).equals(ColName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void InitDMARequestSettingPanel(DMAConfigInfo dmaConfigInfo) {
        this.panel_DMAReqSet.removeAll();
        if (dmaConfigInfo == null) {
            return;
        }
        this.panel_DMAReqSet.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        int col = 0;
        for (Map.Entry<String, List<PeriConfigPart>> entry : DMAConfigUtil.dmaAllInfo.getRequsteInfoMap().entrySet()) {
            String groupName = entry.getKey();
            List<PeriConfigPart> parts = entry.getValue();
            GridBagLayout layout = new GridBagLayout();
            JPanel panel = new JPanel(layout);
            panel.setBorder(new TitledBorder(null, groupName, 4, 2, null, null));
            panel.setToolTipText("");
            JScrollPane scrollConfig = new JScrollPane(panel);
            scrollConfig.setBorder(null);
            constraints.gridx = 0;
            constraints.gridy = col++;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.fill = 1;
            constraints.anchor = 11;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.panel_DMAReqSet.add((Component)scrollConfig, constraints);
            this.addDMARequestGroupControl(panel, dmaConfigInfo, parts);
            panel.revalidate();
            scrollConfig.revalidate();
        }
        this.updateAllControlState(dmaConfigInfo);
        this.panel_DMAReqSet.revalidate();
        this.panel_DMAReqSet.repaint();
    }

    private void addDMARequestGroupControl(JPanel panel, DMAConfigInfo dmaConfigInfo, List<PeriConfigPart> parts) {
        int i = 0;
        while (i < parts.size()) {
            JComponent component;
            String Name;
            PeriConfigPart periConfigPart;
            block14: {
                int Type2;
                block16: {
                    PeriConfigPart specConfigPartObj;
                    block15: {
                        block13: {
                            periConfigPart = new PeriConfigPart();
                            periConfigPart = parts.get(i);
                            Type2 = periConfigPart.getType();
                            String value = periConfigPart.getValue();
                            Name = periConfigPart.getName();
                            specConfigPartObj = DMAConfigUtil.getSpecialControl(dmaConfigInfo.getDMARequest(), Name, DMAConfigUtil.dmaAllInfo.getConfigInfoMap());
                            if (specConfigPartObj != null) {
                                value = specConfigPartObj.getValue();
                            }
                            if (dmaConfigInfo.getContorlValue(Name) != null) {
                                value = dmaConfigInfo.getContorlValue(Name);
                            } else {
                                dmaConfigInfo.setContorlValue(Name, value);
                            }
                            component = null;
                            if (Type2 != ControlStyle.isLable.ordinal()) break block13;
                            value = " " + value;
                            component = new JLabel(value);
                            break block14;
                        }
                        if (Type2 != ControlStyle.isCheckBox.ordinal()) break block15;
                        component = new JCheckBox("");
                        this.InitCheckBoxControl(component, periConfigPart, dmaConfigInfo);
                        break block14;
                    }
                    if (Type2 != ControlStyle.isComBox.ordinal()) break block16;
                    List<PeriConfigItem> PeriConfigItemList = periConfigPart.getIemList();
                    ArrayList<String> ItemList = new ArrayList<String>();
                    int k = 0;
                    while (k < PeriConfigItemList.size()) {
                        block18: {
                            List<String> DisableList;
                            block17: {
                                if (specConfigPartObj == null) break block17;
                                List<PeriConfigItem> spItemList = specConfigPartObj.getIemList();
                                boolean sign = false;
                                for (PeriConfigItem spItemObj : spItemList) {
                                    if (!spItemObj.getName().equals(PeriConfigItemList.get(k).getName())) continue;
                                    sign = true;
                                    break;
                                }
                                if (!sign) break block18;
                            }
                            if (!(DisableList = PeriConfigItemList.get(k).getDisableList()).contains(dmaConfigInfo.getDMARequest())) {
                                ItemList.add(PeriConfigItemList.get(k).getName());
                            }
                        }
                        ++k;
                    }
                    String[] Options = ItemList.toArray(new String[ItemList.size()]);
                    component = new mComboBox(Options);
                    this.InitComBoxControl(component, periConfigPart, dmaConfigInfo);
                    break block14;
                }
                if (Type2 == ControlStyle.isEdit.ordinal()) {
                    component = new JTextField();
                    this.InitEditControl(component, periConfigPart, dmaConfigInfo);
                }
            }
            if (component != null) {
                this.requestComponentMap.put(Name, component);
                int FontSize = 11;
                if (parts.size() > 12) {
                    FontSize = 10;
                }
                ((Component)component).setFont(new Font("Arial", 1, FontSize));
                DMAConfigView.addComponent(panel, component, periConfigPart.getRow(), periConfigPart.getCol(), 1, 1, 17, 2);
            }
            ++i;
        }
    }

    public void InitCheckBoxControl(Component component, PeriConfigPart periConfigPart, final DMAConfigInfo dmaConfigInfo) {
        final String Name = periConfigPart.getName();
        final JCheckBox checkBox = (JCheckBox)component;
        String value = "";
        if (dmaConfigInfo.getContorlValue(Name) != null) {
            value = dmaConfigInfo.getContorlValue(Name);
        } else {
            value = periConfigPart.getValue();
            dmaConfigInfo.setContorlValue(Name, value);
        }
        if ("True".equals(value)) {
            checkBox.setSelected(true);
            dmaConfigInfo.setContorlValue(Name, "True");
        } else if ("False".equals(value)) {
            checkBox.setSelected(false);
            dmaConfigInfo.setContorlValue(Name, "False");
        }
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (checkBox.isSelected()) {
                    dmaConfigInfo.setContorlValue(Name, "True");
                } else {
                    dmaConfigInfo.setContorlValue(Name, "False");
                }
                GlobalVariables.isDirtyFlag = true;
                DMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }
        });
    }

    public void InitComBoxControl(Component component, PeriConfigPart periConfigPart, final DMAConfigInfo dmaConfigInfo) {
        final mComboBox comboBox = (mComboBox)component;
        final String Name = periConfigPart.getName();
        String value = "";
        if (dmaConfigInfo.getContorlValue(Name) != null) {
            value = dmaConfigInfo.getContorlValue(Name);
        }
        comboBox.setSelectedItem((Object)value);
        String selectedItem = comboBox.getSelectedItem().toString();
        dmaConfigInfo.setContorlValue(Name, selectedItem);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String selectedItem = comboBox.getSelectedItem().toString();
                dmaConfigInfo.setContorlValue(Name, selectedItem);
                GlobalVariables.isDirtyFlag = true;
                DMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }
        });
    }

    public void InitEditControl(Component component, PeriConfigPart periConfigPart, final DMAConfigInfo dmaConfigInfo) {
        final String Name = periConfigPart.getName();
        final JTextField txtfield = (JTextField)component;
        String value = "";
        if (dmaConfigInfo.getContorlValue(Name) != null) {
            value = dmaConfigInfo.getContorlValue(Name);
        } else {
            value = periConfigPart.getValue();
            dmaConfigInfo.setContorlValue(Name, value);
        }
        txtfield.setText(value);
        dmaConfigInfo.setContorlValue(Name, value);
        txtfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeriConfigPart partObj;
                String text = txtfield.getText();
                if (!DMAConfigUtil.checkEditValid(text, partObj = DMAConfigUtil.getControlObj("", Name, DMAConfigUtil.dmaAllInfo.getRequsteInfoMap()))) {
                    String messageInfo = "The input value for control " + Name + " is invalid. " + partObj.getValueValidTips();
                    Frame frame = new Frame();
                    frame.setAlwaysOnTop(true);
                    Object[] options = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(frame, messageInfo, "Message", -1, -1, null, options, options[0]);
                    txtfield.setText(dmaConfigInfo.getContorlValue(Name));
                    return;
                }
                dmaConfigInfo.setContorlValue(Name, text);
                GlobalVariables.isDirtyFlag = true;
                DMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }
        });
        txtfield.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                PeriConfigPart partObj;
                String text = txtfield.getText();
                if (!DMAConfigUtil.checkEditValid(text, partObj = DMAConfigUtil.getControlObj("", Name, DMAConfigUtil.dmaAllInfo.getRequsteInfoMap()))) {
                    String messageInfo = "The input value for control " + Name + " is invalid. " + partObj.getValueValidTips();
                    Frame frame = new Frame();
                    frame.setAlwaysOnTop(true);
                    Object[] options = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(frame, messageInfo, "Message", -1, -1, null, options, options[0]);
                    txtfield.setText(dmaConfigInfo.getContorlValue(Name));
                    return;
                }
                dmaConfigInfo.setContorlValue(Name, text);
                GlobalVariables.isDirtyFlag = true;
                DMAConfigView.this.updateAllControlState(dmaConfigInfo);
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
    }

    private static void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        GridBagConstraints gbc = new GridBagConstraints(gridy, gridx, gridwidth, gridheight, 1.0, 1.0, anchor, fill, insets, 0, 0);
        container.add(component, gbc);
    }

    private void updateAllControlState(DMAConfigInfo dmaConfigInfo) {
        for (Map.Entry<String, List<PeriConfigPart>> entry : DMAConfigUtil.dmaAllInfo.getRequsteInfoMap().entrySet()) {
            String groupName = entry.getKey();
            List<PeriConfigPart> parts = entry.getValue();
            int i = 0;
            while (i < parts.size()) {
                PeriConfigPart periConfigPart = parts.get(i);
                String controlName = periConfigPart.getName();
                int controlType = periConfigPart.getType();
                ControlStateInfo controlState = DMAConflictExecute.getDMAControlState((String)groupName, (String)controlName, (String)"", (Map)dmaConfigInfo.getContorlInfoMap());
                this.updateDMARequestControl(controlName, "", controlState, controlType);
                Component component = this.requestComponentMap.get(controlName);
                if (component == null) {
                    return;
                }
                if (controlType == ControlStyle.isComBox.ordinal()) {
                    mComboBox comboBox = (mComboBox)component;
                    ComboBoxModel model = comboBox.getModel();
                    int j = 0;
                    while (j < model.getSize()) {
                        String option = (String)model.getElementAt(j);
                        controlState = DMAConflictExecute.getDMAControlState((String)groupName, (String)controlName, (String)option, (Map)dmaConfigInfo.getContorlInfoMap());
                        this.updateDMARequestControl(controlName, option, controlState, controlType);
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    private void updateDMARequestControl(String controlName, String itemName, ControlStateInfo controlState, int controlType) {
        Component component = this.requestComponentMap.get(controlName);
        if (component == null) {
            return;
        }
        boolean enable = controlState.isEnable();
        boolean visble = controlState.isVisible();
        if (itemName.equals("")) {
            component.setEnabled(enable);
            component.setVisible(visble);
            if ((controlState.getState() >> 2 & 1) != 0) {
                String value = controlState.getValue();
                if (controlType == ControlStyle.isCheckBox.ordinal()) {
                    JCheckBox checkBox = (JCheckBox)component;
                    if (value.toUpperCase().equals("TRUE")) {
                        checkBox.setSelected(true);
                    } else {
                        checkBox.setSelected(false);
                    }
                } else if (controlType == ControlStyle.isComBox.ordinal()) {
                    mComboBox comboBox = (mComboBox)component;
                    if (comboBox.getSelectedItem().equals(value)) {
                        return;
                    }
                    comboBox.setSelectedItem((Object)value);
                } else if (controlType == ControlStyle.isEdit.ordinal()) {
                    JTextField txtfield = (JTextField)component;
                    if (txtfield.getText().equals(value)) {
                        return;
                    }
                    txtfield.setText(value);
                }
            }
        } else if (controlType == ControlStyle.isComBox.ordinal()) {
            mComboBox comboBox = (mComboBox)component;
            if (!enable) {
                comboBox.disableItem((Object)itemName);
            } else {
                comboBox.removeItem((Object)itemName);
            }
        }
    }

    static enum ChannelOp {
        ChannelAdd,
        ChannelSwitch,
        ChannelRelease;

    }

    static enum ControlStyle {
        isLable,
        isCheckBox,
        isComBox,
        isEdit;

    }
}

