/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.xmlparse;

import com.gigadevice.conflict.baseinfo.ConditionInfo;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.periconfigview.baseinfo.PeriConfigItem;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.baseinfo.systemperi.DMAEventStruct;
import com.gigadevice.periconfigview.baseinfo.systemperi.NVICCommonPartStruct;
import com.gigadevice.periconfigview.baseinfo.systemperi.NVICConfigXmlInfoStruct;
import com.gigadevice.periconfigview.utils.NVICConfigUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PeriConfigXMLParse {
    public static void parsePeriConfigXML(String filePath, Map<String, String> PerisCofigMap) {
        try {
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            NodeList PeriList = doc.getElementsByTagName("Peri");
            if (PeriList == null) {
                return;
            }
            int i = 0;
            while (i < PeriList.getLength()) {
                Node PeriNode = PeriList.item(i);
                if (PeriNode != null && PeriNode.getNodeType() == 1) {
                    String PeriName = PeriNode.getAttributes().getNamedItem("Name").getNodeValue();
                    String PeriType = PeriNode.getParentNode().getAttributes().getNamedItem("Name").getNodeValue();
                    PerisCofigMap.put(PeriName, PeriType);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parseNVICXML(String filePath, NVICConfigXmlInfoStruct NVICXmlInfo, Map<String, Map<String, String>> NVICCodeDefineMap) {
        try {
            NodeList ConfigurationList;
            NodeList CommonPartsList;
            NodeList PeriTypeNodeList;
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            doc.getDocumentElement();
            NodeList Actions = doc.getElementsByTagName("Action");
            if (Actions != null) {
                PeriConfigXMLParse.parseAction(NVICXmlInfo, Actions);
            }
            if ((PeriTypeNodeList = doc.getElementsByTagName("PeriType")) != null) {
                int i = 0;
                while (i < PeriTypeNodeList.getLength()) {
                    Node PeriTypeNodes = PeriTypeNodeList.item(i);
                    if (PeriTypeNodes != null && PeriTypeNodes.getNodeType() == 1) {
                        String PeriTypeName = PeriTypeNodes.getAttributes().getNamedItem("name").getNodeValue();
                        NodeList PeriNodeList = PeriTypeNodes.getChildNodes();
                        HashMap<String, List<List<PeriConfigPart>>> PerisInfo = new HashMap<String, List<List<PeriConfigPart>>>();
                        PeriConfigXMLParse.parsePeriNodeListNode(PeriNodeList, PerisInfo, NVICCodeDefineMap, NVICXmlInfo.getHeadColumns());
                        if (PeriTypeName.contains(",")) {
                            String[] peris = PeriTypeName.split(",");
                            int p = 0;
                            while (p < peris.length) {
                                NVICXmlInfo.putNVICInfoMap(peris[p], PerisInfo);
                                ++p;
                            }
                        } else {
                            NVICXmlInfo.putNVICInfoMap(PeriTypeName, PerisInfo);
                        }
                    }
                    ++i;
                }
            }
            if ((CommonPartsList = doc.getElementsByTagName("CommonParts")) != null) {
                PeriConfigXMLParse.parseCommonPartNode(CommonPartsList, NVICXmlInfo, NVICCodeDefineMap);
            }
            if ((ConfigurationList = doc.getElementsByTagName("Configuration")) != null) {
                PeriConfigXMLParse.parseConfigurationNodeList(ConfigurationList, NVICXmlInfo, NVICCodeDefineMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseAction(NVICConfigXmlInfoStruct NVICXmlInfo, NodeList Actions) {
        int i = 0;
        while (i < Actions.getLength()) {
            Node ActionNode = Actions.item(i);
            if (ActionNode != null && ActionNode.getNodeType() == 1) {
                String ActionType = ActionNode.getAttributes().getNamedItem("Type").getNodeValue();
                NodeList Nodes = ActionNode.getChildNodes();
                if (Nodes == null) {
                    return;
                }
                HashMap<String, String> ActionNodesInfo = new HashMap<String, String>();
                int j = 0;
                while (j < Nodes.getLength()) {
                    Node ANode = Nodes.item(j);
                    if (ANode != null && ANode.getNodeType() == 1) {
                        String PeriType = ANode.getAttributes().getNamedItem("PeriType").getNodeValue();
                        String ActionValue = ANode.getAttributes().getNamedItem("ActionValue").getNodeValue();
                        ActionNodesInfo.put(PeriType, ActionValue);
                    }
                    ++j;
                }
                NVICXmlInfo.setActionInfos(ActionType, ActionNodesInfo);
            }
            ++i;
        }
    }

    private static void parsePeriNodeListNode(NodeList PeriNodeList, Map<String, List<List<PeriConfigPart>>> PeisInfo, Map<String, Map<String, String>> NVICCodeDefineMap, HashMap<String, Integer> HeadInfo) {
        int i = 0;
        while (i < PeriNodeList.getLength()) {
            Node PeriNodes = PeriNodeList.item(i);
            if (PeriNodes != null && PeriNodes.getNodeType() == 1) {
                String PeriName = PeriNodes.getAttributes().getNamedItem("name").getNodeValue();
                HashMap<String, ConflictGroupInfo> ConflictGroupInfo2 = new HashMap<String, ConflictGroupInfo>();
                NodeList PartsNodeList = PeriNodes.getChildNodes();
                if (PartsNodeList == null) {
                    return;
                }
                ArrayList PartsList = new ArrayList();
                int j = 0;
                while (j < PartsNodeList.getLength()) {
                    Node PartsNode = PartsNodeList.item(j);
                    if (PartsNode != null && PartsNode.getNodeType() == 1) {
                        NodeList PartNodeList = PartsNode.getChildNodes();
                        ArrayList<PeriConfigPart> PartList = new ArrayList<PeriConfigPart>();
                        int k = 0;
                        while (k < PartNodeList.getLength()) {
                            Node PartNode = PartNodeList.item(k);
                            if (PartNode != null && PartNode.getNodeType() == 1) {
                                if (PartNode.getNodeName().contains("Part")) {
                                    PeriConfigPart periConfigPart = PeriConfigXMLParse.parsePeriConfigPartNode(PartNode);
                                    if (!HeadInfo.containsKey(periConfigPart.getName())) {
                                        HeadInfo.put(periConfigPart.getName(), periConfigPart.getType());
                                    }
                                    PeriConfigXMLParse.UpdateNVICCodeInfo(periConfigPart, NVICCodeDefineMap);
                                    PartList.add(periConfigPart);
                                }
                                if (PartNode.getNodeName().contains("Relation")) {
                                    String interrupt = "";
                                    String TypeName = PartNode.getAttributes().item(0).getNodeValue();
                                    ConflictGroupInfo GroupInfoObj = new ConflictGroupInfo();
                                    GroupInfoObj.setType(TypeName);
                                    PeriConfigXMLParse.ParsePrivilegeInfosList(PeriName, PartNode, GroupInfoObj);
                                    int p = 0;
                                    while (p < PartList.size()) {
                                        if (((PeriConfigPart)PartList.get(p)).getName().equals("Interrupt Table")) {
                                            interrupt = ((PeriConfigPart)PartList.get(p)).getContent();
                                            break;
                                        }
                                        ++p;
                                    }
                                    ConflictGroupInfo2.put(interrupt, GroupInfoObj);
                                }
                            }
                            ++k;
                        }
                        if (!PartList.isEmpty()) {
                            PartsList.add(PartList);
                        }
                    }
                    ++j;
                }
                if (!PartsList.isEmpty()) {
                    PeisInfo.put(PeriName, PartsList);
                }
                NVICConfigUtil.NVICPartsConditionMap.put(PeriName, ConflictGroupInfo2);
            }
            ++i;
        }
    }

    private static void parseCommonPartNode(NodeList CommonPartsList, NVICConfigXmlInfoStruct NVICXmlInfo, Map<String, Map<String, String>> NVICCodeDefineMap) {
        int i = 0;
        while (i < CommonPartsList.getLength()) {
            Node CommonPartsNode = CommonPartsList.item(i);
            if (CommonPartsNode != null && CommonPartsNode.getNodeType() == 1) {
                NodeList CommonPartNodeList = CommonPartsNode.getChildNodes();
                if (CommonPartNodeList == null) {
                    return;
                }
                int j = 0;
                while (j < CommonPartNodeList.getLength()) {
                    Node CommonPartNode = CommonPartNodeList.item(j);
                    if (CommonPartNode != null && CommonPartNode.getNodeType() == 1) {
                        NVICCommonPartStruct NVICCommonPartStructObj = new NVICCommonPartStruct();
                        String Name = CommonPartNode.getAttributes().getNamedItem("name").getNodeValue();
                        NVICCommonPartStructObj.putName(Name);
                        NodeList ChildNodeList = CommonPartNode.getChildNodes();
                        int k = 0;
                        while (k < ChildNodeList.getLength()) {
                            Node ChildNode = ChildNodeList.item(k);
                            if (ChildNode != null && ChildNode.getNodeType() == 1) {
                                if (ChildNode.getNodeName().equals("Part")) {
                                    PeriConfigPart periConfigPart = PeriConfigXMLParse.parsePeriConfigPartNode(ChildNode);
                                    periConfigPart.setName(Name);
                                    PeriConfigXMLParse.UpdateNVICCodeInfo(periConfigPart, NVICCodeDefineMap);
                                    NVICCommonPartStructObj.putPeriConfigPartNode(periConfigPart);
                                } else if (ChildNode.getNodeName().equals("Condition")) {
                                    int Attributeslength = ChildNode.getAttributes().getLength();
                                    int n = 0;
                                    while (n < Attributeslength) {
                                        if (ChildNode.getAttributes().item(n).getNodeName().equals("Oper")) {
                                            NVICCommonPartStructObj.putOper(ChildNode.getAttributes().getNamedItem("Oper").getNodeValue());
                                        } else if (ChildNode.getAttributes().item(n).getNodeName().equals("ParentNode")) {
                                            NVICCommonPartStructObj.putParentNode(ChildNode.getAttributes().getNamedItem("ParentNode").getNodeValue());
                                        } else if (ChildNode.getAttributes().item(n).getNodeName().equals("Node")) {
                                            NVICCommonPartStructObj.putNode(ChildNode.getAttributes().getNamedItem("Node").getNodeValue());
                                        } else if (ChildNode.getAttributes().item(n).getNodeName().equals("NodeItem")) {
                                            NVICCommonPartStructObj.putNodeItem(ChildNode.getAttributes().getNamedItem("NodeItem").getNodeValue());
                                        }
                                        ++n;
                                    }
                                }
                            }
                            ++k;
                        }
                        NVICXmlInfo.putCommonPartList(NVICCommonPartStructObj);
                    }
                    ++j;
                }
                return;
            }
            ++i;
        }
    }

    private static void parseConfigurationNodeList(NodeList ConfigurationNodeList, NVICConfigXmlInfoStruct NVICXmlInfo, Map<String, Map<String, String>> NVICCodeDefineMap) {
        int i = 0;
        while (i < ConfigurationNodeList.getLength()) {
            Node ConfigurationNode = ConfigurationNodeList.item(i);
            if (ConfigurationNode != null && ConfigurationNode.getNodeType() == 1) {
                NodeList PartNodeList = ConfigurationNode.getChildNodes();
                int k = 0;
                while (k < PartNodeList.getLength()) {
                    Node PartNode = PartNodeList.item(k);
                    if (PartNode != null && PartNode.getNodeType() == 1) {
                        PeriConfigPart periConfigPart = PeriConfigXMLParse.parsePeriConfigPartNode(PartNode);
                        NVICXmlInfo.putConfigurationPartList(periConfigPart);
                    }
                    ++k;
                }
                return;
            }
            ++i;
        }
    }

    private static void ParsePrivilegeInfosList(String PeriName, Node Relation, ConflictGroupInfo GroupInfoObj) {
        List UserList = GroupInfoObj.getConditionsList();
        NodeList PrivilegeInfosList = Relation.getChildNodes();
        int p = 0;
        while (p < PrivilegeInfosList.getLength()) {
            Node PrivilegeInfos = PrivilegeInfosList.item(p);
            if (PrivilegeInfos != null && PrivilegeInfos.getNodeType() == 1) {
                NodeList PrivilegeUserList = PrivilegeInfos.getChildNodes();
                ArrayList<ConditionInfo> UList = new ArrayList<ConditionInfo>();
                int u = 0;
                while (u < PrivilegeUserList.getLength()) {
                    Node itPrivilegeUser = PrivilegeUserList.item(u);
                    if (itPrivilegeUser != null && itPrivilegeUser.getNodeType() == 1) {
                        ConditionInfo PrivilegeUserObj = new ConditionInfo();
                        PrivilegeUserObj.setPeriName(PeriName);
                        PrivilegeUserObj.setType("Item");
                        int Attributeslength = itPrivilegeUser.getAttributes().getLength();
                        int n = 0;
                        while (n < Attributeslength) {
                            String attributeName = itPrivilegeUser.getAttributes().item(n).getNodeName();
                            String attributeValue = itPrivilegeUser.getAttributes().item(n).getNodeValue();
                            if (!attributeValue.equals("")) {
                                PrivilegeUserObj.setAttrValue(attributeName, attributeValue);
                            }
                            ++n;
                        }
                        UList.add(PrivilegeUserObj);
                    }
                    ++u;
                }
                UserList.add(UList);
            }
            ++p;
        }
        GroupInfoObj.setConditionsList(UserList);
    }

    private static PeriConfigPart parsePeriConfigPartNode(Node PartNode) {
        PeriConfigPart periConfigPart = new PeriConfigPart();
        String Type2 = "";
        String Name = "";
        String Content = "";
        String Value = "";
        String EnableStr = "";
        int Min = 0;
        int Max = 0;
        int Attributeslength = PartNode.getAttributes().getLength();
        int n = 0;
        while (n < Attributeslength) {
            String tmp;
            if (PartNode.getAttributes().item(n).getNodeName().equals("type")) {
                Type2 = PartNode.getAttributes().getNamedItem("type").getNodeValue();
            } else if (PartNode.getAttributes().item(n).getNodeName().equals("name")) {
                Name = PartNode.getAttributes().getNamedItem("name").getNodeValue();
            } else if (PartNode.getAttributes().item(n).getNodeName().equals("content")) {
                Content = PartNode.getAttributes().getNamedItem("content").getNodeValue();
            } else if (PartNode.getAttributes().item(n).getNodeName().equals("value")) {
                Value = PartNode.getAttributes().getNamedItem("value").getNodeValue();
            } else if (PartNode.getAttributes().item(n).getNodeName().equals("enable")) {
                EnableStr = PartNode.getAttributes().getNamedItem("enable").getNodeValue();
            } else if (PartNode.getAttributes().item(n).getNodeName().equals("CommonPart")) {
                String CommonPart = PartNode.getAttributes().getNamedItem("CommonPart").getNodeValue();
                periConfigPart.setCommonPart(CommonPart);
            } else if (PartNode.getAttributes().item(n).getNodeName().equals("min")) {
                tmp = PartNode.getAttributes().getNamedItem("min").getNodeValue();
                try {
                    Min = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            } else if (PartNode.getAttributes().item(n).getNodeName().equals("max")) {
                tmp = PartNode.getAttributes().getNamedItem("max").getNodeValue();
                try {
                    Max = Integer.parseInt(tmp);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            ++n;
        }
        periConfigPart.setName(Name);
        int ControlType2 = -1;
        try {
            ControlType2 = Integer.parseInt(Type2);
            periConfigPart.setType(ControlType2);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (ControlType2 == 2) {
            Node ItemNode = PartNode.getFirstChild();
            while (ItemNode != null) {
                if (ItemNode.getNodeType() == 1) {
                    PeriConfigItem ItemObj = new PeriConfigItem();
                    String ItemName = "";
                    String ItemValue = "";
                    NamedNodeMap subattribute = ItemNode.getAttributes();
                    if (subattribute.getLength() > 0) {
                        int n2 = 0;
                        while (n2 < subattribute.getLength()) {
                            if (subattribute.item(n2).getNodeName().equals("name")) {
                                ItemName = subattribute.item(n2).getNodeValue();
                                ItemObj.setName(ItemName);
                            } else if (subattribute.item(n2).getNodeName().equals("value")) {
                                ItemValue = subattribute.item(n2).getNodeValue();
                                ItemObj.setValue(ItemValue);
                            }
                            ++n2;
                        }
                    }
                    periConfigPart.setIemList(ItemObj);
                }
                ItemNode = ItemNode.getNextSibling();
            }
        }
        periConfigPart.setContent(Content);
        periConfigPart.setValue(Value);
        if (EnableStr.equals("true")) {
            periConfigPart.setisEnable(true);
        } else {
            periConfigPart.setisEnable(false);
        }
        periConfigPart.setMin(Min);
        periConfigPart.setMax(Max);
        return periConfigPart;
    }

    private static void UpdateNVICCodeInfo(PeriConfigPart periConfigPart, Map<String, Map<String, String>> NVICCodeDefineMap) {
        if (periConfigPart.getType() == 0) {
            PeriConfigXMLParse.AddXMLCodeDefine(periConfigPart.getName(), periConfigPart.getContent(), periConfigPart.getValue(), NVICCodeDefineMap);
        } else if (periConfigPart.getType() == 2) {
            List<PeriConfigItem> IemList = periConfigPart.getIemList();
            int i = 0;
            while (i < IemList.size()) {
                PeriConfigXMLParse.AddXMLCodeDefine(periConfigPart.getName(), IemList.get(i).getName(), IemList.get(i).getValue(), NVICCodeDefineMap);
                ++i;
            }
        }
    }

    public static void parseDMAXML(String filePath, Map<String, Map<String, List<PeriConfigPart>>> DMAInfoMap, List<PeriConfigPart> DMARequsteSetList, Map<String, Map<String, String>> DMAXMLCodeDefineMap) {
        try {
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            doc.getDocumentElement();
            Node DMARequesterNode = doc.getElementsByTagName("DMARequester").item(0);
            NodeList ReqPartNodeList = DMARequesterNode.getChildNodes();
            PeriConfigXMLParse.ParseDMAReqSet(ReqPartNodeList, DMARequsteSetList, DMAXMLCodeDefineMap);
            NodeList PeriNodeList = doc.getElementsByTagName("Peri");
            if (PeriNodeList == null) {
                return;
            }
            int i = 0;
            while (i < PeriNodeList.getLength()) {
                Node PeriNodes = PeriNodeList.item(i);
                if (PeriNodes != null && PeriNodes.getNodeType() == 1) {
                    String PeriName = PeriNodes.getAttributes().getNamedItem("name").getNodeValue();
                    NodeList PartsNodeList = PeriNodes.getChildNodes();
                    if (PartsNodeList == null) {
                        return;
                    }
                    HashMap PartsMap = new HashMap();
                    int j = 0;
                    while (j < PartsNodeList.getLength()) {
                        Node PartsNode = PartsNodeList.item(j);
                        if (PartsNode != null && PartsNode.getNodeType() == 1) {
                            String PartsName = PartsNode.getAttributes().getNamedItem("name").getNodeValue();
                            NodeList PartNodeList = PartsNode.getChildNodes();
                            ArrayList<PeriConfigPart> PartList = new ArrayList<PeriConfigPart>();
                            int k = 0;
                            while (k < PartNodeList.getLength()) {
                                Node PartNode = PartNodeList.item(k);
                                if (PartNode != null && PartNode.getNodeType() == 1) {
                                    PeriConfigPart periConfigPart = new PeriConfigPart();
                                    String Type2 = PartNode.getAttributes().getNamedItem("type").getNodeValue();
                                    String Name = PartNode.getAttributes().getNamedItem("name").getNodeValue();
                                    String Value = PartNode.getAttributes().getNamedItem("value").getNodeValue();
                                    periConfigPart.setName(Name);
                                    int ControlType2 = -1;
                                    try {
                                        ControlType2 = Integer.parseInt(Type2);
                                        periConfigPart.setType(ControlType2);
                                    }
                                    catch (NumberFormatException e) {
                                        e.printStackTrace();
                                    }
                                    if (ControlType2 == 2) {
                                        Node ItemNode = PartNode.getFirstChild();
                                        while (ItemNode != null) {
                                            if (ItemNode.getNodeType() == 1) {
                                                PeriConfigItem ItemObj = new PeriConfigItem();
                                                int n = 0;
                                                while (n < ItemNode.getAttributes().getLength()) {
                                                    if (ItemNode.getAttributes().item(n).getNodeName().equals("name")) {
                                                        String name = ItemNode.getAttributes().getNamedItem("name").getNodeValue();
                                                        ItemObj.setName(name);
                                                    } else if (ItemNode.getAttributes().item(n).getNodeName().equals("value")) {
                                                        String value = ItemNode.getAttributes().getNamedItem("value").getNodeValue();
                                                        ItemObj.setValue(value);
                                                    }
                                                    ++n;
                                                }
                                                if (ItemObj.getValue() != null) {
                                                    PeriConfigXMLParse.AddXMLCodeDefine(Name, ItemObj.getName(), ItemObj.getValue(), DMAXMLCodeDefineMap);
                                                }
                                                periConfigPart.setIemList(ItemObj);
                                            }
                                            ItemNode = ItemNode.getNextSibling();
                                        }
                                    }
                                    periConfigPart.setValue(Value);
                                    PartList.add(periConfigPart);
                                }
                                ++k;
                            }
                            if (!PartList.isEmpty()) {
                                PartsMap.put(PartsName, PartList);
                            }
                        }
                        ++j;
                    }
                    if (!PartsMap.isEmpty()) {
                        DMAInfoMap.put(PeriName, PartsMap);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void ParseDMAReqSet(NodeList PartNodeList, List<PeriConfigPart> DMARequsteSetList, Map<String, Map<String, String>> DMAXMLCodeDefineMap) {
        if (PartNodeList == null) {
            return;
        }
        int i = 0;
        while (i < PartNodeList.getLength()) {
            Node PartNode = PartNodeList.item(i);
            if (PartNode != null && PartNode.getNodeType() == 1) {
                PeriConfigPart periConfigPart = new PeriConfigPart();
                String Type2 = PartNode.getAttributes().getNamedItem("type").getNodeValue();
                String Name = PartNode.getAttributes().getNamedItem("name").getNodeValue();
                String Value = PartNode.getAttributes().getNamedItem("value").getNodeValue();
                String Row2 = PartNode.getAttributes().getNamedItem("row").getNodeValue();
                String Col = PartNode.getAttributes().getNamedItem("col").getNodeValue();
                periConfigPart.setName(Name);
                periConfigPart.setValue(Value);
                int ControlType2 = -1;
                try {
                    ControlType2 = Integer.parseInt(Type2);
                    periConfigPart.setType(ControlType2);
                    periConfigPart.setRow(Integer.parseInt(Row2));
                    periConfigPart.setCol(Integer.parseInt(Col));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                if (ControlType2 != 0) {
                    Node ItemNode = PartNode.getFirstChild();
                    while (ItemNode != null) {
                        if (ItemNode.getNodeType() == 1) {
                            PeriConfigItem ItemObj = new PeriConfigItem();
                            int Attributeslength = ItemNode.getAttributes().getLength();
                            int j = 0;
                            while (j < Attributeslength) {
                                if (ItemNode.getAttributes().item(j).getNodeName().equals("name")) {
                                    String ItemName = ItemNode.getAttributes().getNamedItem("name").getNodeValue();
                                    ItemObj.setName(ItemName);
                                } else if (ItemNode.getAttributes().item(j).getNodeName().equals("value")) {
                                    String ItemValue = ItemNode.getAttributes().getNamedItem("value").getNodeValue();
                                    ItemObj.setValue(ItemValue);
                                } else if (ItemNode.getAttributes().item(j).getNodeName().equals("disable")) {
                                    String DisableStr = ItemNode.getAttributes().getNamedItem("disable").getNodeValue();
                                    ItemObj.setDisableList(DisableStr);
                                }
                                ++j;
                            }
                            if (ItemObj.getValue() != null) {
                                PeriConfigXMLParse.AddXMLCodeDefine(Name, ItemObj.getName(), ItemObj.getValue(), DMAXMLCodeDefineMap);
                            }
                            periConfigPart.setIemList(ItemObj);
                        }
                        ItemNode = ItemNode.getNextSibling();
                    }
                }
                DMARequsteSetList.add(periConfigPart);
            }
            ++i;
        }
    }

    public static void AddXMLCodeDefine(String ControlName, String ItemName, String ItemValue, Map<String, Map<String, String>> XMLCodeDefineMap) {
        if (XMLCodeDefineMap.containsKey(ControlName)) {
            if (XMLCodeDefineMap.get(ControlName).containsKey(ItemName)) {
                return;
            }
            XMLCodeDefineMap.get(ControlName).put(ItemName, ItemValue);
        } else {
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put(ItemName, ItemValue);
            XMLCodeDefineMap.put(ControlName, tmp);
        }
    }

    public static void parseDMAPeriModeEventInfoXML(String filePath, Map<String, Map<String, DMAEventStruct>> DMAPeriModeEventInfo) {
        try {
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            NodeList PeriNodeList = doc.getElementsByTagName("Peri");
            if (PeriNodeList == null) {
                return;
            }
            int i = 0;
            while (i < PeriNodeList.getLength()) {
                Node PeriNodes = PeriNodeList.item(i);
                if (PeriNodes != null && PeriNodes.getNodeType() == 1) {
                    String PeriName = PeriNodes.getAttributes().getNamedItem("name").getNodeValue();
                    NodeList ModeNodeList = PeriNodes.getChildNodes();
                    if (ModeNodeList == null) {
                        return;
                    }
                    HashMap<String, DMAEventStruct> ModeMap = new HashMap<String, DMAEventStruct>();
                    int j = 0;
                    while (j < ModeNodeList.getLength()) {
                        Node ModeNode = ModeNodeList.item(j);
                        if (ModeNode != null && ModeNode.getNodeType() == 1) {
                            String ModeName = ModeNode.getAttributes().getNamedItem("name").getNodeValue();
                            String tmpType = ModeNode.getAttributes().getNamedItem("type").getNodeValue();
                            DMAEventStruct DMAEventObj = new DMAEventStruct();
                            DMAEventObj.setMode(ModeName);
                            try {
                                int ModeType = Integer.parseInt(tmpType);
                                DMAEventObj.setType(ModeType);
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                            NodeList EventNodeList = ModeNode.getChildNodes();
                            new ArrayList();
                            int k = 0;
                            while (k < EventNodeList.getLength()) {
                                Node EventNode = EventNodeList.item(k);
                                if (EventNode != null && EventNode.getNodeType() == 1) {
                                    String EventName = EventNode.getAttributes().getNamedItem("name").getNodeValue();
                                    DMAEventObj.setEventSet(EventName);
                                }
                                ++k;
                            }
                            if (DMAEventObj.getEventSet().size() > 0) {
                                ModeMap.put(ModeName, DMAEventObj);
                            }
                        }
                        ++j;
                    }
                    if (ModeMap.size() > 0) {
                        DMAPeriModeEventInfo.put(PeriName, ModeMap);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void parseGPIORemapXML(String filePath, Map<String, List<String>> GPIORemapMap) {
        if (filePath.isEmpty() || filePath.endsWith("")) {
            return;
        }
        try {
            File f = new File(filePath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(f);
            NodeList RemapConfigList = doc.getElementsByTagName("RemapConfig");
            if (RemapConfigList == null) {
                return;
            }
            int GPIORemapNodeNum = RemapConfigList.getLength();
            int i = 0;
            while (i < GPIORemapNodeNum) {
                Node GPIORemap = RemapConfigList.item(i);
                if (GPIORemap != null) {
                    PeriConfigXMLParse.removeTextNode(GPIORemap);
                    if (GPIORemap != null && GPIORemap.getNodeType() == 1) {
                        NodeList lstRemapNode = GPIORemap.getChildNodes();
                        int RemapNodesNum = lstRemapNode.getLength();
                        int j = 0;
                        while (j < RemapNodesNum) {
                            Node Remap = lstRemapNode.item(j);
                            if (Remap != null) {
                                PeriConfigXMLParse.removeTextNode(Remap);
                                if (Remap != null && Remap.getNodeType() == 1) {
                                    String RemapStr = Remap.getAttributes().getNamedItem("Name").getNodeValue();
                                    NodeList lstPinNode = Remap.getChildNodes();
                                    int PinNodesNum = lstPinNode.getLength();
                                    int k = 0;
                                    while (k < PinNodesNum) {
                                        Node Pin = lstPinNode.item(k);
                                        ArrayList<String> lstPin = new ArrayList<String>();
                                        String strPin = Pin.getTextContent();
                                        String[] strArry = strPin.split(",");
                                        int m = 0;
                                        while (m < strArry.length) {
                                            lstPin.add(strArry[m]);
                                            ++m;
                                        }
                                        GPIORemapMap.put(RemapStr, lstPin);
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeTextNode(Node root) {
        if (root.hasChildNodes()) {
            NodeList children = root.getChildNodes();
            int count = children.getLength();
            int i = count - 1;
            while (i >= 0) {
                Node child = children.item(i);
                if (child.getNodeType() == 3) {
                    child.getParentNode().removeChild(child);
                }
                --i;
            }
        }
    }
}

