/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.xmlparse;

import com.gigadevice.venustool.baseinfo.nvic.NVICConfigStruct;
import com.gigadevice.venustool.baseinfo.nvic.NVICParameterGroupNode;
import com.gigadevice.venustool.baseinfo.nvic.ParameterNode;
import com.gigadevice.venustool.periconfigbasestruct.GeneralPariParaNodeItemStruct;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class NVICConfigXMLParse {
    private static final String XML_PARAMETEREGROUPNODE = "ParameterGroup";
    private static final String XML_PARAMETERENODE = "Parameter";
    private static final String ADDXML_KEY = "key";
    private static final String ATTRIBUTES_PERINAME = "PeriName";
    private static final String ATTRIBUTES_CONTENT = "Content";
    private static final String ATTRIBUTES_DEFAULTVALUE = "DefaultValue";
    private static final String ATTRIBUTES_MAX = "Max";
    private static final String ATTRIBUTES_MIN = "Min";
    private static final String ATTRIBUTES_GROUPNAME = "GroupName";
    private static final String ATTRIBUTES_NAME = "Name";
    private static final String ATTRIBUTES_TYPE = "Type";
    private static final String ATTRIBUTES_VALUE = "Value";
    private static final String XML_POSSIBLEVALUENODE = "PossibleValue";
    private static final String ATTRIBUTES_REF = "Ref";
    private static Element addInfoXmlRootNode = null;
    private static boolean xmlHasAddInfo = false;

    public static NVICConfigStruct parseNVICConfigXML(String filePath) {
        NVICConfigStruct NVICObj = new NVICConfigStruct();
        File files = new File(filePath);
        if (!files.exists()) {
            return NVICObj;
        }
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(new File(filePath));
            Element rootElm = document.getRootElement();
            NVICConfigXMLParse.initAddInfoXmlInfo(rootElm, filePath);
            List ParameterGroupNodeList = rootElm.elements(XML_PARAMETEREGROUPNODE);
            NVICConfigXMLParse.PraseParameterGroup(NVICObj, ParameterGroupNodeList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return NVICObj;
    }

    private static void PraseParameterGroup(NVICConfigStruct nVICObj, List<Element> lstNode) {
        Iterator<Element> it = lstNode.iterator();
        while (it.hasNext()) {
            String Content;
            String Min;
            String Max;
            String DefauleValue;
            String ParameterGroupName;
            Element elmRef;
            NVICParameterGroupNode ParameterGroupObj = new NVICParameterGroupNode();
            Element elm = it.next();
            String ref = elm.attributeValue(ATTRIBUTES_REF);
            if (ref != null && (elmRef = NVICConfigXMLParse.getRefParaGroupInAddInfo(ref)) != null) {
                elm = elmRef;
            }
            if ((ParameterGroupName = elm.attributeValue(ATTRIBUTES_NAME)) == null) continue;
            ParameterGroupObj.setName(ParameterGroupName);
            List ParameterNodeList = elm.elements(XML_PARAMETERENODE);
            NVICConfigXMLParse.PraseParameter(ParameterGroupObj, ParameterNodeList);
            String PeriName = elm.attributeValue(ATTRIBUTES_PERINAME);
            if (ParameterGroupName != null && PeriName != null) {
                if (PeriName.contains(",")) {
                    String[] str = PeriName.split(",");
                    int x = 0;
                    while (x < str.length) {
                        ParameterGroupObj.putPeriNameList(str[x]);
                        ++x;
                    }
                } else {
                    ParameterGroupObj.putPeriNameList(PeriName);
                }
            }
            if ((DefauleValue = elm.attributeValue(ATTRIBUTES_DEFAULTVALUE)) != null) {
                ParameterGroupObj.setDefaultValue(DefauleValue);
                ParameterGroupObj.setValue(DefauleValue);
            }
            if ((Max = elm.attributeValue(ATTRIBUTES_MAX)) != null) {
                ParameterGroupObj.setMax(Integer.parseInt(Max));
            }
            if ((Min = elm.attributeValue(ATTRIBUTES_MIN)) != null) {
                ParameterGroupObj.setMin(Integer.parseInt(Min));
            }
            if ((Content = elm.attributeValue(ATTRIBUTES_CONTENT)) != null) {
                ParameterGroupObj.setContent(Content);
            } else {
                ParameterGroupObj.setContent(ParameterGroupName);
            }
            nVICObj.putNVICParameterGroupInfo(ParameterGroupName, ParameterGroupObj);
        }
    }

    private static void PraseParameter(NVICParameterGroupNode parameterGroupObj, List lstNode) {
        Iterator it = lstNode.iterator();
        while (it.hasNext()) {
            String Type2;
            String DefauleValue;
            String Content;
            Element elmRef;
            ParameterNode Parameter = new ParameterNode();
            Element elm = (Element)it.next();
            String ref = elm.attributeValue(ATTRIBUTES_REF);
            if (ref != null && (elmRef = NVICConfigXMLParse.getRefParaInAddInfo(ref)) != null) {
                elm = elmRef;
            }
            if ((Content = elm.attributeValue(ATTRIBUTES_CONTENT)) != null) {
                Parameter.setContent(Content);
            }
            if ((DefauleValue = elm.attributeValue(ATTRIBUTES_DEFAULTVALUE)) != null) {
                Parameter.setDefaultValue(DefauleValue);
                Parameter.setValue(DefauleValue);
            }
            Parameter.setGroupName(parameterGroupObj.getName());
            String Name = elm.attributeValue(ATTRIBUTES_NAME);
            if (Name != null) {
                Parameter.setName(Name);
            }
            if ((Type2 = elm.attributeValue(ATTRIBUTES_TYPE)) != null) {
                Parameter.setType(Integer.parseInt(Type2));
            }
            List PossibleValueNodeList = elm.elements(XML_POSSIBLEVALUENODE);
            NVICConfigXMLParse.ParsePossibleValue(Parameter.getPossibleValueList(), PossibleValueNodeList);
            parameterGroupObj.putNVICParameterInfo(Parameter);
        }
    }

    private static void ParsePossibleValue(LinkedHashMap<String, GeneralPariParaNodeItemStruct> possibleValueList, List lstNode) {
        Iterator it = lstNode.iterator();
        while (it.hasNext()) {
            String Value;
            GeneralPariParaNodeItemStruct PossibleValue = new GeneralPariParaNodeItemStruct();
            Element elm = (Element)it.next();
            String Content = elm.attributeValue(ATTRIBUTES_CONTENT);
            if (Content != null) {
                PossibleValue.setContent(Content);
            }
            if ((Value = elm.attributeValue(ATTRIBUTES_VALUE)) != null) {
                PossibleValue.setValue(Value);
            }
            PossibleValue.setState(0);
            possibleValueList.put(Content, PossibleValue);
        }
    }

    private static void initAddInfoXmlInfo(Element root, String filePath) {
        addInfoXmlRootNode = null;
        xmlHasAddInfo = false;
        String addInfo = root.attributeValue("addInfo");
        if (addInfo != null && addInfo.equals("true")) {
            xmlHasAddInfo = true;
            String xmlAddInfoPath = filePath.replace(".xml", "AddInfo.xml");
            NVICConfigXMLParse.parseAddInfoXml(xmlAddInfoPath);
        }
    }

    private static void parseAddInfoXml(String xmlPath) {
        File file = new File(xmlPath);
        if (!file.exists()) {
            return;
        }
        SAXReader saxReader = new SAXReader();
        try {
            Document document = saxReader.read(file);
            addInfoXmlRootNode = document.getRootElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Element getRefParaGroupInAddInfo(String key) {
        if (!xmlHasAddInfo) {
            return null;
        }
        if (addInfoXmlRootNode == null) {
            return null;
        }
        List NodeList2 = addInfoXmlRootNode.elements(ADDXML_KEY);
        for (Element elm : NodeList2) {
            List List2;
            Iterator itr;
            String Name = elm.attributeValue(ATTRIBUTES_NAME);
            if (Name == null || !Name.equals(key) || !(itr = (List2 = elm.elements(XML_PARAMETEREGROUPNODE)).iterator()).hasNext()) continue;
            return (Element)itr.next();
        }
        return null;
    }

    private static Element getRefParaInAddInfo(String key) {
        if (!xmlHasAddInfo) {
            return null;
        }
        if (addInfoXmlRootNode == null) {
            return null;
        }
        List NodeList2 = addInfoXmlRootNode.elements(ADDXML_KEY);
        for (Element elm : NodeList2) {
            List List2;
            Iterator itr;
            String Name = elm.attributeValue(ATTRIBUTES_NAME);
            if (Name == null || !Name.equals(key) || !(itr = (List2 = elm.elements(XML_PARAMETERENODE)).iterator()).hasNext()) continue;
            return (Element)itr.next();
        }
        return null;
    }
}

