/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import com.gigadevice.periconfigview.utils.SeriesProcessor;
import com.gigadevice.periconfigview.utils.processors.GD32G5x3Processor;
import com.gigadevice.venustool.GlobalVariables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SeriesProcessorManager {
    private static List<SeriesProcessor> processors = new ArrayList<SeriesProcessor>();
    private static Map<String, Map<String, Boolean>> visibilityCache = new HashMap<String, Map<String, Boolean>>();

    static {
        processors.add(new GD32G5x3Processor());
    }

    public static boolean isConfigItemVisible(String configItem, String moduleName, String signal) {
        Map<String, Boolean> seriesCache;
        String seriesPath = GlobalVariables.SeriesPath;
        String cacheKey = String.valueOf(seriesPath) + ":" + moduleName + ":" + signal + ":" + configItem;
        if (visibilityCache.containsKey(seriesPath) && (seriesCache = visibilityCache.get(seriesPath)).containsKey(cacheKey)) {
            return seriesCache.get(cacheKey);
        }
        for (SeriesProcessor processor : processors) {
            if (!processor.isApplicable(seriesPath)) continue;
            boolean isVisible = processor.isConfigItemVisible(configItem, moduleName, signal);
            if (!visibilityCache.containsKey(seriesPath)) {
                visibilityCache.put(seriesPath, new HashMap());
            }
            visibilityCache.get(seriesPath).put(cacheKey, isVisible);
            return isVisible;
        }
        return true;
    }

    public static void clearCache() {
        visibilityCache.clear();
    }
}

