/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview.utils;

import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.periconfigview.baseinfo.MDMAInfo;
import com.gigadevice.periconfigview.baseinfo.PeriConfigPart;
import com.gigadevice.periconfigview.baseinfo.systemperi.DMAEventStruct;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import com.gigadevice.periconfigview.xmlparse.DMAConfigXMLParse;
import com.gigadevice.venustool.GlobalPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.dma.MDMAConfigGroupInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAConfigInfo;
import com.gigadevice.venustool.baseinfo.dma.MDMAInfoUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MDMAConfigUtil {
    public static final String STR_SERIALIZE = "MDMA";
    public static MDMAInfo mdmaAllInfo = new MDMAInfo();
    private static LinkedHashMap<String, Map<String, String>> mdmaDeSerializeMap = new LinkedHashMap();
    public static List<String> mdmaUsedChannelList = new ArrayList<String>();
    public static LinkedHashMap<String, LinkedHashMap<String, MDMAConfigGroupInfo>> temMDMAConfigInfo = new LinkedHashMap();

    public static void ClearUserConfigVars() {
        MDMAInfoUtil.mDMAConfigInfo.clear();
        mdmaUsedChannelList.clear();
        temMDMAConfigInfo.clear();
    }

    public static void ClearAllGlobalVars() {
        MDMAInfoUtil.mDMAConfigInfo.clear();
        mdmaUsedChannelList.clear();
        temMDMAConfigInfo.clear();
        mdmaAllInfo.clearAllInfo();
    }

    public static void InitAllGlobalVars() {
    }

    public static void LoadAllGlobalVars() {
        MDMAInfoUtil.mDMAConfigInfo.clear();
        for (Map.Entry<String, Map<String, String>> entry : mdmaDeSerializeMap.entrySet()) {
            String key = entry.getKey();
            ArrayList<String> strList = new ArrayList<String>(Arrays.asList(key.split("\\.")));
            if (strList.size() < 4) {
                LogManager.getInstance().error("<MDMAConfigContent>", "The format of the MDMA information is incorrect, the gdc file may have been manually modified. Serialize Error: " + key);
                continue;
            }
            String periName = (String)strList.get(1);
            String channel = (String)strList.get(2);
            String requestName = (String)strList.get(3);
            Map<String, String> map = entry.getValue();
            MDMAConfigInfo DMAConfigObj = new MDMAConfigInfo();
            ArrayList<String> ChannelList = new ArrayList<String>();
            ChannelList.add(channel);
            DMAConfigObj.setChannelList(ChannelList);
            for (Map.Entry<String, String> entry1 : map.entrySet()) {
                DMAConfigObj.setContorlValue(entry1.getKey(), entry1.getValue());
                if (!entry1.getKey().equals("MDMA Request")) continue;
                DMAConfigObj.setMDMARequest(entry1.getValue());
            }
            LinkedHashMap mDMAConfigInfos = new LinkedHashMap();
            MDMAConfigGroupInfo mDMAConfigObj = new MDMAConfigGroupInfo();
            if (MDMAInfoUtil.mDMAConfigInfo.containsKey(periName) && (mDMAConfigInfos = (LinkedHashMap)MDMAInfoUtil.mDMAConfigInfo.get(periName)).containsKey(channel)) {
                mDMAConfigObj = (MDMAConfigGroupInfo)mDMAConfigInfos.get(channel);
            }
            mDMAConfigObj.addMDMAInfoMap(DMAConfigObj, requestName);
            mDMAConfigInfos.put(channel, mDMAConfigObj);
            MDMAInfoUtil.mDMAConfigInfo.put(periName, mDMAConfigInfos);
        }
        mdmaDeSerializeMap.clear();
    }

    public static void Serialize(ObjectOutputStream out) {
        try {
            out.writeObject(MDMAInfoUtil.mDMAConfigInfo);
            out.writeObject(mdmaAllInfo.getConfigInfoMap());
            out.writeObject(mdmaAllInfo.getCodeDefineMap());
            out.writeObject(mdmaAllInfo.getRequsteInfoMap());
            out.writeObject(mdmaAllInfo.getRequestConditionMap());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void DeSerialize(ObjectInputStream ins, String version) {
        switch (version) {
            case "1.1": {
                MDMAConfigUtil.DeSerializeV1(ins);
            }
        }
    }

    private static void DeSerializeV1(ObjectInputStream ins) {
        try {
            temMDMAConfigInfo = (LinkedHashMap)ins.readObject();
            Map mDMAInfoMap = (Map)ins.readObject();
            mdmaAllInfo.setConfigInfoMap(mDMAInfoMap);
            Map mDMAXMLCodeDefineMap = (Map)ins.readObject();
            mdmaAllInfo.setCodeDefineMap(mDMAXMLCodeDefineMap);
            LinkedHashMap mDMARequsteSetMap = (LinkedHashMap)ins.readObject();
            mdmaAllInfo.setRequsteInfoMap(mDMARequsteSetMap);
            Map mDMAEventConditionMap = (Map)ins.readObject();
            mdmaAllInfo.setRequestConditionMap(mDMAEventConditionMap);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static String Serialize() {
        String output = "";
        for (Map.Entry entry : MDMAInfoUtil.mDMAConfigInfo.entrySet()) {
            String periName = (String)entry.getKey();
            Map mDMAConfigInfoMap = (Map)entry.getValue();
            for (Map.Entry entry1 : mDMAConfigInfoMap.entrySet()) {
                String Channel2 = (String)entry1.getKey();
                MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry1.getValue();
                LinkedHashMap DMAInfoMap = mDMAConfigObj.getMDMAInfoMap();
                for (String key : mDMAConfigObj.getMDMAInfoSort()) {
                    if (!DMAInfoMap.containsKey(key)) continue;
                    String requestName = key;
                    Map ContorlInfoMap = ((MDMAConfigInfo)DMAInfoMap.get(key)).getContorlInfoMap();
                    for (Map.Entry entry3 : ContorlInfoMap.entrySet()) {
                        String str = String.valueOf(String.join((CharSequence)".", STR_SERIALIZE, periName, Channel2, requestName, (CharSequence)entry3.getKey())) + "=" + (String)entry3.getValue() + System.lineSeparator();
                        output = String.valueOf(output) + str;
                    }
                }
            }
        }
        return output;
    }

    public static void DeSerialize(String input, int version) {
        switch (version) {
            case 1: {
                MDMAConfigUtil.DeSerializeV1(input);
            }
        }
    }

    private static void DeSerializeV1(String input) {
        mdmaDeSerializeMap = GlobalVariables.serializeStrClassification((String)input, (String)STR_SERIALIZE);
    }

    public static void MDMAXMLInfoParse() {
        if (mdmaAllInfo.getConfigInfoMap().size() <= 0) {
            GlobalPathUtil.SysPeriXmlPaths sysPeriXmlPathsObj = GlobalPathUtil.getSysPeriXmlPaths();
            String mDMAConfigXmlPath = sysPeriXmlPathsObj.MDMAConfigXmlPath;
            DMAConfigXMLParse.parseDMAXML(mDMAConfigXmlPath, mdmaAllInfo);
        }
    }

    public static void LoadUserConfigInfo() {
        temMDMAConfigInfo.clear();
        temMDMAConfigInfo = (LinkedHashMap)GlobalVariables.cloneFrom((Object)MDMAInfoUtil.mDMAConfigInfo);
        mdmaUsedChannelList.clear();
        mdmaUsedChannelList = new ArrayList<String>(temMDMAConfigInfo.keySet());
        for (Map.Entry<String, LinkedHashMap<String, MDMAConfigGroupInfo>> entry : temMDMAConfigInfo.entrySet()) {
            Map mDMAConfigInfoMap = entry.getValue();
            for (Map.Entry entry1 : mDMAConfigInfoMap.entrySet()) {
                MDMAConfigGroupInfo mDMAConfigInfoObj = (MDMAConfigGroupInfo)entry1.getValue();
                for (Map.Entry entry2 : mDMAConfigInfoObj.getMDMAInfoMap().entrySet()) {
                    MDMAConfigInfo mdmaConfigObj = (MDMAConfigInfo)entry2.getValue();
                    String requestName = mdmaConfigObj.getMDMARequest();
                    String removeSuffix = requestName.split("%")[0];
                    List<String> publicControlNameList = MDMAConfigUtil.getTablePublicControlNameListByRequest(removeSuffix);
                    if (publicControlNameList == null) continue;
                    for (String publicControlName : publicControlNameList) {
                        if (mdmaConfigObj.getContorlValue(publicControlName) == null) continue;
                        mDMAConfigInfoObj.setContorlValue(publicControlName, mdmaConfigObj.getContorlValue(publicControlName));
                    }
                }
            }
        }
    }

    public static void UpdatePeriConfigInfo(String PeriName) {
        if (MDMAInfoUtil.mDMAConfigInfo.size() <= 0) {
            return;
        }
        if (!MDMAInfoUtil.mDMAConfigInfo.containsKey(STR_SERIALIZE)) {
            return;
        }
        ArrayList<String> deleteChannel = new ArrayList<String>();
        for (Map.Entry entry : ((LinkedHashMap)MDMAInfoUtil.mDMAConfigInfo.get(STR_SERIALIZE)).entrySet()) {
            String channelStr = (String)entry.getKey();
            MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)entry.getValue();
            LinkedHashMap MDMAInfoMap = mDMAConfigObj.getMDMAInfoMap();
            ArrayList strList = new ArrayList(MDMAInfoMap.keySet());
            int i = 0;
            while (i < strList.size()) {
                String DMARequest = (String)strList.get(i);
                String removeSuffix = DMARequest.split("%")[0];
                String peri = MDMAConfigUtil.ReturnRequestPeri(removeSuffix);
                if (peri.equals(PeriName)) {
                    if (!MDMAConfigUtil.DMAReqisValid(removeSuffix, PeriName)) {
                        MDMAInfoMap.remove(DMARequest);
                    }
                    if (MDMAInfoMap.size() <= 0) {
                        deleteChannel.add(channelStr);
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < deleteChannel.size()) {
            ((LinkedHashMap)MDMAInfoUtil.mDMAConfigInfo.get(STR_SERIALIZE)).remove(deleteChannel.get(i));
            mdmaUsedChannelList.remove(deleteChannel.get(i));
            ++i;
        }
        if (((LinkedHashMap)MDMAInfoUtil.mDMAConfigInfo.get(STR_SERIALIZE)).size() <= 0) {
            MDMAInfoUtil.mDMAConfigInfo.remove(STR_SERIALIZE);
        }
    }

    public static MDMAConfigInfo GetMDMAConfigInfo(String ChannelName, String RequestName) {
        for (Map.Entry<String, LinkedHashMap<String, MDMAConfigGroupInfo>> entry : temMDMAConfigInfo.entrySet()) {
            Map mDMAConfigInfoMap = entry.getValue();
            if (!mDMAConfigInfoMap.containsKey(ChannelName)) continue;
            MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)mDMAConfigInfoMap.get(ChannelName);
            return mDMAConfigObj.getMDMAInfo(RequestName);
        }
        return null;
    }

    public static MDMAConfigGroupInfo GetMDMAGroupInfo(String ChannelName) {
        for (Map.Entry<String, LinkedHashMap<String, MDMAConfigGroupInfo>> entry : temMDMAConfigInfo.entrySet()) {
            Map mDMAConfigInfoMap = entry.getValue();
            if (!mDMAConfigInfoMap.containsKey(ChannelName)) continue;
            MDMAConfigGroupInfo mDMAConfigObj = (MDMAConfigGroupInfo)mDMAConfigInfoMap.get(ChannelName);
            return mDMAConfigObj;
        }
        return null;
    }

    public static void ChannelSwitchtoInfoUpdate(String formChannel, String ChannelName) {
        for (Map.Entry<String, LinkedHashMap<String, MDMAConfigGroupInfo>> entry : temMDMAConfigInfo.entrySet()) {
            Map mDMAConfigInfoMap = entry.getValue();
            for (Map.Entry entry1 : mDMAConfigInfoMap.entrySet()) {
                String Channel2 = (String)entry1.getKey();
                if (!formChannel.equals(Channel2)) continue;
                MDMAConfigGroupInfo mDMAConfigInfoObj = (MDMAConfigGroupInfo)entry1.getValue();
                MDMAConfigUtil.DeleteDMAConfigInfo(formChannel);
                mDMAConfigInfoObj.updateChannelName(ChannelName);
                MDMAConfigUtil.addMDMAConfigInfo(mDMAConfigInfoObj);
                return;
            }
        }
    }

    public static String ReturnRequestPeri(String Request) {
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : mdmaAllInfo.getConfigInfoMap().entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(Request)) continue;
            return entry.getKey();
        }
        return STR_SERIALIZE;
    }

    public static List<PeriConfigPart> getControlListByRequest(String Request) {
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : mdmaAllInfo.getConfigInfoMap().entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(Request)) continue;
            return PartsMap.get(Request);
        }
        return null;
    }

    public static List<String> getTablePublicControlNameListByRequest(String Request) {
        List<PeriConfigPart> PartList = null;
        ArrayList<String> publicControlNameList = new ArrayList<String>();
        for (Map.Entry<String, Map<String, List<PeriConfigPart>>> entry : mdmaAllInfo.getConfigInfoMap().entrySet()) {
            Map<String, List<PeriConfigPart>> PartsMap = entry.getValue();
            if (!PartsMap.containsKey(Request)) continue;
            PartList = PartsMap.get(Request);
            if (PartList == null) {
                return publicControlNameList;
            }
            int i = 0;
            while (i < PartList.size()) {
                PeriConfigPart partObj = PartList.get(i);
                if (partObj.getUILocation() == DMAConfigUtil.UILocation.isTable.ordinal() && partObj.getCol() != 0) {
                    publicControlNameList.add(partObj.getName());
                }
                ++i;
            }
        }
        return publicControlNameList;
    }

    public static void AddDMAConfigInfo(MDMAConfigInfo mDMAConfigObj) {
        Map.Entry entry;
        MDMAConfigInfo mdmaConfigObj;
        String requestName;
        String removeSuffix;
        List<String> publicControlNameList;
        String PeriName;
        String ChannelName = "";
        String DMARequest = "";
        Map ContorlInfoMap = mDMAConfigObj.getContorlInfoMap();
        if (ContorlInfoMap.containsKey("Channel")) {
            ChannelName = (String)ContorlInfoMap.get("Channel");
        }
        if (ContorlInfoMap.containsKey("MDMA Request")) {
            DMARequest = mDMAConfigObj.getMDMARequest();
        }
        LinkedHashMap<Object, Object> mDMAPeriConfigMap = temMDMAConfigInfo.containsKey(PeriName = STR_SERIALIZE) ? temMDMAConfigInfo.get(PeriName) : new LinkedHashMap();
        MDMAConfigGroupInfo mDMAChannelConfigObj = new MDMAConfigGroupInfo();
        if (mDMAPeriConfigMap.containsKey(ChannelName)) {
            mDMAChannelConfigObj = (MDMAConfigGroupInfo)mDMAPeriConfigMap.get(ChannelName);
        }
        if (mDMAChannelConfigObj.getMDMAInfo(DMARequest) != null) {
            return;
        }
        Iterator iterator = mDMAChannelConfigObj.getMDMAInfoMap().entrySet().iterator();
        if (iterator.hasNext() && (publicControlNameList = MDMAConfigUtil.getTablePublicControlNameListByRequest(removeSuffix = (requestName = (mdmaConfigObj = (MDMAConfigInfo)(entry = iterator.next()).getValue()).getMDMARequest()).split("%")[0])) != null) {
            for (String publicControlName : publicControlNameList) {
                if (mDMAChannelConfigObj.getContorlValue(publicControlName) == null) continue;
                mDMAConfigObj.setContorlValue(publicControlName, mDMAChannelConfigObj.getContorlValue(publicControlName));
            }
        }
        mDMAChannelConfigObj.addMDMAInfoMap(mDMAConfigObj, DMARequest);
        mDMAPeriConfigMap.put(ChannelName, mDMAChannelConfigObj);
        temMDMAConfigInfo.put(PeriName, mDMAPeriConfigMap);
    }

    public static void DeleteDMAConfigInfo(String ChannelName, String RequestName) {
        String PeriName = MDMAConfigUtil.getChannelUsePeri(ChannelName);
        if (PeriName == null) {
            return;
        }
        Map mDMAPeriConfigMap = temMDMAConfigInfo.get(PeriName);
        if (!mDMAPeriConfigMap.containsKey(ChannelName)) {
            return;
        }
        MDMAConfigGroupInfo mDMAChannelConfigObj = (MDMAConfigGroupInfo)mDMAPeriConfigMap.get(ChannelName);
        LinkedHashMap mDMARequestInfoMap = mDMAChannelConfigObj.getMDMAInfoMap();
        if (!mDMARequestInfoMap.containsKey(RequestName)) {
            return;
        }
        if (mDMARequestInfoMap.size() == 1) {
            MDMAConfigUtil.DeleteDMAConfigInfo(ChannelName);
        } else if (mDMARequestInfoMap.size() > 1) {
            MDMAConfigInfo mDMAConfigObj = (MDMAConfigInfo)mDMARequestInfoMap.get(RequestName);
            String listTypeValue = mDMAConfigObj.getContorlValue("List Type");
            if (listTypeValue != null) {
                if (mDMARequestInfoMap.size() == 2 && listTypeValue.equals("Circular List Looping On First Transfer")) {
                    mDMAChannelConfigObj.setContorlValue("List Type", "Linear List");
                }
                if (mDMARequestInfoMap.size() == 3 && listTypeValue.equals("Circular List Looping On Second Transfer")) {
                    mDMAChannelConfigObj.setContorlValue("List Type", "Linear List");
                }
            }
            mDMAChannelConfigObj.deleteMDMAInfoMap(RequestName);
        }
    }

    public static void DeleteDMAConfigInfo(String ChannelName) {
        String PeriName = MDMAConfigUtil.getChannelUsePeri(ChannelName);
        if (PeriName == null) {
            return;
        }
        LinkedHashMap<String, MDMAConfigGroupInfo> mDMAPeriConfigMap = temMDMAConfigInfo.get(PeriName);
        if (mDMAPeriConfigMap.size() == 1) {
            temMDMAConfigInfo.remove(PeriName);
        } else if (mDMAPeriConfigMap.size() > 1) {
            mDMAPeriConfigMap.remove(ChannelName);
            temMDMAConfigInfo.put(PeriName, mDMAPeriConfigMap);
        }
    }

    public static void addMDMAConfigInfo(MDMAConfigGroupInfo mDMAConfigInfoObj) {
        String channelName = mDMAConfigInfoObj.getMDMAChannel();
        Map<String, Object> mDMAPeriConfigMap = new HashMap<String, MDMAConfigGroupInfo>();
        if (temMDMAConfigInfo.containsKey(STR_SERIALIZE)) {
            mDMAPeriConfigMap = temMDMAConfigInfo.get(STR_SERIALIZE);
        }
        mDMAPeriConfigMap.put(channelName, mDMAConfigInfoObj);
    }

    public static String getChannelUsePeri(String ChannelName) {
        for (Map.Entry<String, LinkedHashMap<String, MDMAConfigGroupInfo>> entry : temMDMAConfigInfo.entrySet()) {
            String PeriName = entry.getKey();
            Map mDMAPeriConfigMap = entry.getValue();
            for (Map.Entry entry1 : mDMAPeriConfigMap.entrySet()) {
                String Channel2 = (String)entry1.getKey();
                if (!ChannelName.equals(Channel2)) continue;
                return PeriName;
            }
        }
        return null;
    }

    private static boolean DMAReqisValid(String Requester, String PeriName) {
        ConflictGroupInfo ConflictGroupObj;
        if (!GlobalVariables.PeripheralConfigObjMap.containsKey(PeriName) && !PeriName.contains("DMA")) {
            return false;
        }
        if (mdmaAllInfo.getPeriModeEventInfo().size() == 0 && mdmaAllInfo.getRequestConditionMap().containsKey(Requester) && !ConflictCheck.PrivilegeCheck((String)(ConflictGroupObj = mdmaAllInfo.getRequestConditionMap().get(Requester)).getType(), (List)ConflictGroupObj.getConditionsList())) {
            return false;
        }
        if (!mdmaAllInfo.getPeriModeEventInfo().containsKey(PeriName)) {
            return true;
        }
        Map<String, DMAEventStruct> ModeEventInfo = mdmaAllInfo.getPeriModeEventInfo().get(PeriName);
        for (Map.Entry<String, DMAEventStruct> entry : ModeEventInfo.entrySet()) {
            String ModeName;
            if (!entry.getValue().getEventSet().contains(Requester) || !((ModeName = entry.getValue().getMode()).equals("") ? GlobalVariables.PeripheralTreeMap.containsKey(PeriName) : ConflictCheck.Equal((String)PeriName, (String)"", (String)"", (String)ModeName, (String)"1", null))) continue;
            return true;
        }
        return false;
    }
}

