/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import com.gigadevice.periconfigview.messages.Messages;
import com.gigadevice.periconfigview.utils.ProjectManagerSettingUtil;
import com.gigadevice.venustool.GlobalVariables;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class ProjectManagerView {
    private static final String CARD_CODEGEN = "Code Generator";
    private static final Color BACKGROUND_COLOR = new Color(240, 248, 255);
    private static final Color HOVER_BG_COLOR = new Color(245, 250, 255);
    private static final Font TITLE_FONT = new Font("Microsoft YaHei", 1, 14);
    private static final Font NAV_FONT = new Font("Microsoft YaHei", 1, 16);
    private static final Font REGULAR_FONT = new Font("Microsoft YaHei", 0, 12);
    private static final int STANDARD_PADDING = 10;
    private static final int NAV_WIDTH = 200;
    private static final int NAV_BUTTON_HEIGHT = 80;
    private static JPanel cardPanel;
    private static JPanel navPanel;
    private static CardLayout cardLayout;
    private static List<NavButton> navButtons;
    static JCheckBox m_JCheckBoxOverwriteFirmwareLib;
    static JCheckBox m_JCheckBoxOverwriteLDFile;
    static JCheckBox m_JCheckBoxOverwriteStartupFile;
    static JCheckBox m_JCheckBoxOverwriteCFGFile;
    private static List<PanelInfo> registeredPanels;

    static {
        navButtons = new ArrayList<NavButton>();
        registeredPanels = new ArrayList<PanelInfo>();
        ProjectManagerView.registerPanel(CARD_CODEGEN, Messages.SwitchLanguageHandler_CodeGenerator, true);
    }

    public static void registerPanel(String id, String title, boolean isActive) {
        registeredPanels.add(new PanelInfo(id, title, isActive));
    }

    public static JComponent createPartControl() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        cardPanel = new JPanel();
        cardLayout = new CardLayout();
        cardPanel.setLayout(cardLayout);
        cardPanel.setBackground(Color.WHITE);
        navPanel = ProjectManagerView.createNavigationPanel();
        for (PanelInfo info : registeredPanels) {
            if (!CARD_CODEGEN.equals(info.id)) continue;
            JScrollPane scrollPane = new JScrollPane(ProjectManagerView.createCodeGeneratorPanel());
            scrollPane.setBorder(null);
            scrollPane.setBackground(Color.WHITE);
            scrollPane.setVerticalScrollBarPolicy(20);
            scrollPane.setHorizontalScrollBarPolicy(30);
            ProjectManagerView.enhanceScrollPane(scrollPane);
            cardPanel.add((Component)scrollPane, info.id);
        }
        mainPanel.add((Component)navPanel, "West");
        mainPanel.add((Component)cardPanel, "Center");
        SwingUtilities.invokeLater(() -> {
            for (PanelInfo info : registeredPanels) {
                if (!info.isActive) continue;
                cardLayout.show(cardPanel, info.id);
                break;
            }
            cardPanel.revalidate();
            cardPanel.repaint();
        });
        return mainPanel;
    }

    private static JPanel createNavigationPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setBackground(BACKGROUND_COLOR);
        panel.setPreferredSize(new Dimension(200, 0));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setBackground(BACKGROUND_COLOR);
        int i = 0;
        while (i < registeredPanels.size()) {
            PanelInfo info = registeredPanels.get(i);
            NavButton btn = new NavButton(info.title, info.id, info.isActive);
            navButtons.add(btn);
            buttonPanel.add(btn);
            buttonPanel.add(ProjectManagerView.createSeparator());
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(buttonPanel);
        scrollPane.setBorder(null);
        scrollPane.setBackground(BACKGROUND_COLOR);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setViewportBorder(null);
        scrollPane.getViewport().setBackground(BACKGROUND_COLOR);
        ProjectManagerView.enhanceScrollPane(scrollPane);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    private static JComponent createSeparator() {
        JSeparator separator = new JSeparator(0);
        separator.setForeground(new Color(210, 220, 230));
        separator.setBackground(BACKGROUND_COLOR);
        separator.setMaximumSize(new Dimension(Integer.MAX_VALUE, 1));
        separator.setPreferredSize(new Dimension(200, 1));
        return separator;
    }

    private static JPanel createCodeGeneratorPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.setBackground(Color.WHITE);
        JPanel fileUpdatePanel = ProjectManagerView.createFileUpdateRulesPanel();
        fileUpdatePanel.setAlignmentX(0.0f);
        mainPanel.add(fileUpdatePanel);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(Box.createVerticalGlue());
        return mainPanel;
    }

    private static JPanel createFileUpdateRulesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(ComponentFactory.createTitledBorder(Messages.SwitchLanguageHandler_FileUpdateRules));
        panel.setBackground(Color.WHITE);
        JLabel infoLabel = ComponentFactory.createLabel(Messages.SwitchLanguageHandler_OverwriteLabel, ComponentFactory.LabelType.INFO);
        infoLabel.setAlignmentX(0.0f);
        panel.add(infoLabel);
        panel.add(Box.createVerticalStrut(10));
        m_JCheckBoxOverwriteFirmwareLib = ComponentFactory.createCheckBox(Messages.SwitchLanguageHandler_OverwriteFirmware, e -> {
            boolean bl = GlobalVariables.isDirtyFlag = true;
        });
        m_JCheckBoxOverwriteLDFile = ComponentFactory.createCheckBox(Messages.SwitchLanguageHandler_OverwriteLD, e -> {
            boolean bl = GlobalVariables.isDirtyFlag = true;
        });
        m_JCheckBoxOverwriteStartupFile = ComponentFactory.createCheckBox(Messages.SwitchLanguageHandler_OverwriteStartup, e -> {
            boolean bl = GlobalVariables.isDirtyFlag = true;
        });
        m_JCheckBoxOverwriteCFGFile = ComponentFactory.createCheckBox(Messages.SwitchLanguageHandler_OverwriteCFG, e -> {
            boolean bl = GlobalVariables.isDirtyFlag = true;
        });
        panel.add(m_JCheckBoxOverwriteFirmwareLib);
        panel.add(Box.createVerticalStrut(5));
        panel.add(m_JCheckBoxOverwriteLDFile);
        panel.add(Box.createVerticalStrut(5));
        panel.add(m_JCheckBoxOverwriteStartupFile);
        panel.add(Box.createVerticalStrut(5));
        panel.add(m_JCheckBoxOverwriteCFGFile);
        ProjectManagerView.loadFileUpdateSettings();
        return panel;
    }

    private static void loadFileUpdateSettings() {
        block18: {
            LinkedHashMap<String, String> ProjectSettingMap;
            block17: {
                ProjectSettingMap = ProjectManagerSettingUtil.getProjectManagerSettingMap();
                if (ProjectSettingMap != null && !ProjectSettingMap.isEmpty()) break block17;
                m_JCheckBoxOverwriteFirmwareLib.setSelected(true);
                m_JCheckBoxOverwriteLDFile.setSelected(false);
                m_JCheckBoxOverwriteStartupFile.setSelected(false);
                m_JCheckBoxOverwriteCFGFile.setSelected(false);
                break block18;
            }
            Set<String> KeySet2 = ProjectSettingMap.keySet();
            for (String Key2 : KeySet2) {
                String Value = ProjectSettingMap.get(Key2);
                switch (Key2) {
                    case "OverwriteFirmwareLib": {
                        m_JCheckBoxOverwriteFirmwareLib.setSelected(Boolean.parseBoolean(Value));
                        break;
                    }
                    case "OverwriteLDFile": {
                        m_JCheckBoxOverwriteLDFile.setSelected(Boolean.parseBoolean(Value));
                        break;
                    }
                    case "OverwriteStartupFile": {
                        m_JCheckBoxOverwriteStartupFile.setSelected(Boolean.parseBoolean(Value));
                        break;
                    }
                    case "OverwriteCFGFile": {
                        m_JCheckBoxOverwriteCFGFile.setSelected(Boolean.parseBoolean(Value));
                    }
                }
            }
        }
    }

    public static LinkedHashMap<String, String> getGDProjectManagerSetting() {
        if (!GlobalVariables.isSupportCodeGen()) {
            return null;
        }
        LinkedHashMap<String, String> GDProjectManagerSettingMap = new LinkedHashMap<String, String>();
        GDProjectManagerSettingMap.put("OverwriteFirmwareLib", m_JCheckBoxOverwriteFirmwareLib.isSelected() ? "true" : "false");
        GDProjectManagerSettingMap.put("OverwriteLDFile", m_JCheckBoxOverwriteLDFile.isSelected() ? "true" : "false");
        GDProjectManagerSettingMap.put("OverwriteStartupFile", m_JCheckBoxOverwriteStartupFile.isSelected() ? "true" : "false");
        GDProjectManagerSettingMap.put("OverwriteCFGFile", m_JCheckBoxOverwriteCFGFile.isSelected() ? "true" : "false");
        return GDProjectManagerSettingMap;
    }

    private static void enhanceScrollPane(JScrollPane scrollPane) {
        scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        scrollPane.addMouseWheelListener(e -> {
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            int notches = e.getWheelRotation();
            int scrollAmount = e.getScrollAmount() * 3;
            if (notches < 0) {
                verticalScrollBar.setValue(verticalScrollBar.getValue() - scrollAmount * verticalScrollBar.getUnitIncrement());
            } else {
                verticalScrollBar.setValue(verticalScrollBar.getValue() + scrollAmount * verticalScrollBar.getUnitIncrement());
            }
        });
    }

    private static class ComponentFactory {
        private ComponentFactory() {
        }

        public static JCheckBox createCheckBox(String text, ActionListener listener) {
            JCheckBox checkBox = new JCheckBox(text);
            checkBox.setFont(REGULAR_FONT);
            checkBox.setBackground(Color.WHITE);
            checkBox.setFocusPainted(false);
            checkBox.setAlignmentX(0.0f);
            if (listener != null) {
                checkBox.addActionListener(listener);
            }
            return checkBox;
        }

        public static JLabel createLabel(String text, LabelType type) {
            JLabel label = new JLabel(text);
            switch (type) {
                case TITLE: {
                    label.setFont(TITLE_FONT);
                    label.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
                    break;
                }
                case INFO: {
                    label.setFont(REGULAR_FONT);
                    break;
                }
                default: {
                    label.setFont(REGULAR_FONT);
                }
            }
            return label;
        }

        public static Border createTitledBorder(String title) {
            return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(200, 200, 200)), title, 1, 2, TITLE_FONT);
        }

        static enum LabelType {
            TITLE,
            INFO,
            NORMAL;

        }
    }

    private static class NavButton
    extends JButton {
        private boolean isCurrentlySelected = false;

        public NavButton(String text, String command, boolean isSelected) {
            super(text);
            this.setFont(NAV_FONT);
            this.setPreferredSize(new Dimension(200, 80));
            this.setMaximumSize(new Dimension(200, 80));
            this.setMinimumSize(new Dimension(200, 80));
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setOpaque(true);
            this.setFocusPainted(false);
            this.setContentAreaFilled(true);
            this.setBorderPainted(true);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setActionCommand(command);
            this.isCurrentlySelected = isSelected;
            this.setAlignmentX(0.5f);
            this.updateSelectedAppearance(isSelected);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (!isCurrentlySelected) {
                        this.setBackground(HOVER_BG_COLOR);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (!isCurrentlySelected) {
                        this.setBackground(BACKGROUND_COLOR);
                    }
                }
            });
            this.addActionListener(e -> {
                String cmd = e.getActionCommand();
                if (this.isCurrentlySelected) {
                    return;
                }
                cardLayout.show(cardPanel, cmd);
                for (NavButton btn : navButtons) {
                    boolean selected;
                    btn.isCurrentlySelected = selected = btn.getActionCommand().equals(cmd);
                    btn.updateSelectedAppearance(selected);
                }
                cardPanel.revalidate();
                cardPanel.repaint();
                navPanel.revalidate();
                navPanel.repaint();
            });
        }

        private void updateSelectedAppearance(boolean selected) {
            this.isCurrentlySelected = selected;
            if (selected) {
                this.setBackground(new Color(166097));
                this.setForeground(Color.WHITE);
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 5, 0, 0, new Color(87963)), BorderFactory.createEmptyBorder(10, 0, 10, 0)));
                this.setFont(new Font(NAV_FONT.getName(), 1, NAV_FONT.getSize()));
            } else {
                this.setBackground(BACKGROUND_COLOR);
                this.setForeground(Color.DARK_GRAY);
                this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
                this.setFont(new Font(NAV_FONT.getName(), 0, NAV_FONT.getSize()));
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static class PanelInfo {
        public final String id;
        public final String title;
        public final boolean isActive;

        public PanelInfo(String id, String title, boolean isActive) {
            this.id = id;
            this.title = title;
            this.isActive = isActive;
        }
    }
}

