/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.periconfigview;

import com.gigadevice.customui.gdui.GDEditComboBox;
import com.gigadevice.periconfigview.baseinfo.systemperi.GPIOConfigCtrlStruct;
import com.gigadevice.periconfigview.model.GPIOTableModel;
import com.gigadevice.periconfigview.utils.GPIOConfigUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.gpio.GPIOInfoUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.Document;

public class GPIOConfigTab
extends JPanel {
    private static final int ROW_HEIGHT = 30;
    private static final int COLUMN_MIN_WIDTH = 90;
    private static final int COLUMN_EXTRA_PADDING = 50;
    private static final String TRUE_FLAG = "TRUE";
    private static final String LABEL_SEARCH = "Search Signal";
    private static final String CHECKBOX_MODIFIED_TEXT = "Show only Modified Pins";
    private JTextField txtSearch;
    public JTable table;
    private String strModuleName;
    boolean FilterTextEnable = false;
    boolean FilterCheckBoxEnable = false;
    private String strTarget = "";
    public GPIOTableModel model;
    private JLabel lblSearchSignal;
    private JScrollPane scrollGPIOPinDisplay;
    private JCheckBox ckBoxModified;
    private JScrollPane scrollGPIOConfig;
    private JPanel panelGPIOConfig;
    private Boolean multiCoreEnabled;
    private int tempWidthSum = 0;
    private int[] baseColumnWidths;
    private boolean detailPanelVisible = false;
    private static final double DETAIL_PANEL_RATIO = 0.38;
    private static final int DETAIL_PANEL_MIN_HEIGHT = 160;
    private boolean layoutResizeListenerAdded = false;

    public void load(String mStrModuleName) {
        this.GPIOConfigTabInit(mStrModuleName);
    }

    public void reload() {
        if (this.strModuleName != null && !this.strModuleName.equals("")) {
            this.saveSortingOrder();
            this.removeAll();
            this.GPIOConfigTabInit(this.strModuleName);
        }
    }

    public void GPIOConfigTabInit(String mStrModuleName) {
        Font hf;
        this.strModuleName = mStrModuleName;
        this.setLayout(new BorderLayout());
        this.detailPanelVisible = false;
        Vector<String> ColVector = new Vector<String>();
        for (String strConfigObj : GPIOInfoUtil.mapGPIOConfigObjsIndex.keySet()) {
            ColVector.add((String)GPIOInfoUtil.mapGPIOConfigObjsIndex.get(strConfigObj));
        }
        List lstCore = GlobalVariables.getCoreList();
        this.multiCoreEnabled = lstCore.size() > 1;
        Vector<Vector<String>> OrigDataVector = new Vector<Vector<String>>();
        if (GPIOConfigUtil.GPIOConfigInfoMapTemp.containsKey(this.strModuleName)) {
            Map<String, Vector<String>> TableData = GPIOConfigUtil.GPIOConfigInfoMapTemp.get(this.strModuleName);
            for (String pinName : TableData.keySet()) {
                OrigDataVector.add(TableData.get(pinName));
                if (!this.multiCoreEnabled.booleanValue() || !this.strModuleName.equals("GPIO")) continue;
                GPIOConfigUtil.GPIOConfigPinOnCore.put(pinName, (String)lstCore.get(0));
            }
        }
        this.model = new GPIOTableModel((Vector)OrigDataVector, (Vector)ColVector);
        this.table = new JTable(this.model);
        this.table.setRowHeight(30);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(0);
        this.adjustInitialColumnWidths();
        TableColumnModel bcm = this.table.getColumnModel();
        this.baseColumnWidths = new int[bcm.getColumnCount()];
        int i = 0;
        while (i < bcm.getColumnCount()) {
            this.baseColumnWidths[i] = bcm.getColumn(i).getPreferredWidth();
            ++i;
        }
        TableRowSorter<GPIOTableModel> sorter = new TableRowSorter<GPIOTableModel>(this.model);
        this.table.setRowSorter(sorter);
        this.table.setShowVerticalLines(true);
        this.table.setShowHorizontalLines(true);
        this.table.setGridColor(new Color(220, 220, 220));
        this.table.setFont(new Font("Arial", 0, 15));
        this.table.setSelectionMode(0);
        JTableHeader hdr = this.table.getTableHeader();
        if (hdr != null && (hf = hdr.getFont()).getStyle() != 1) {
            hdr.setFont(hf.deriveFont(1));
        }
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        centerRenderer.setVerticalAlignment(0);
        int c = 0;
        while (c < this.table.getColumnCount()) {
            this.table.getColumnModel().getColumn(c).setCellRenderer(centerRenderer);
            ++c;
        }
        this.scrollGPIOPinDisplay = new JScrollPane(this.table);
        this.add((Component)this.scrollGPIOPinDisplay, "Center");
        this.scrollGPIOPinDisplay.getViewport().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GPIOConfigTab.this.fillLastColumn();
            }
        });
        SwingUtilities.invokeLater(this::fillLastColumn);
        JPanel topBar = new JPanel(new BorderLayout());
        this.lblSearchSignal = new JLabel(LABEL_SEARCH);
        this.txtSearch = new JTextField(14);
        this.ckBoxModified = new JCheckBox(CHECKBOX_MODIFIED_TEXT);
        JPanel leftPane = new JPanel(new FlowLayout(0, 8, 4));
        leftPane.add(this.lblSearchSignal);
        leftPane.add(this.txtSearch);
        JPanel rightPane = new JPanel(new FlowLayout(2, 8, 4));
        rightPane.add(this.ckBoxModified);
        topBar.add((Component)leftPane, "West");
        topBar.add((Component)rightPane, "East");
        this.add((Component)topBar, "North");
        this.panelGPIOConfig = new JPanel(new GridBagLayout());
        this.scrollGPIOConfig = new JScrollPane(this.panelGPIOConfig);
        Document dtSearch = this.txtSearch.getDocument();
        dtSearch.addDocumentListener(new DocumentListener(){

            private void refresh() {
                GPIOConfigTab.this.strTarget = GPIOConfigTab.this.txtSearch.getText().trim();
                GPIOConfigTab.this.FilterTextEnable = !GPIOConfigTab.this.strTarget.isEmpty();
                GPIOConfigTab.this.applyFilters();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.refresh();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.refresh();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.ckBoxModified.addItemListener(ev -> {
            this.FilterCheckBoxEnable = ev.getStateChange() == 1;
            this.applyFilters();
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int viewRow = GPIOConfigTab.this.table.getSelectedRow();
                if (viewRow < 0) {
                    return;
                }
                String pinName = GPIOConfigTab.this.table.getValueAt(viewRow, 0).toString();
                int modelRow = -1;
                int r = 0;
                while (r < GPIOConfigTab.this.model.getRowCount()) {
                    if (pinName.equals(GPIOConfigTab.this.model.getValueAt(r, 0))) {
                        modelRow = r;
                        break;
                    }
                    ++r;
                }
                if (modelRow < 0) {
                    return;
                }
                GPIOConfigTab.this.rebuildDetailPanel(pinName, modelRow);
                GPIOConfigTab.this.ensureDetailPanelVisible();
            }
        });
    }

    private void fillLastColumn() {
        if (this.table == null) {
            return;
        }
        TableColumnModel cm = this.table.getColumnModel();
        int count = cm.getColumnCount();
        if (count == 0) {
            return;
        }
        if (this.baseColumnWidths == null || this.baseColumnWidths.length != count) {
            this.baseColumnWidths = new int[count];
            int i = 0;
            while (i < count) {
                this.baseColumnWidths[i] = cm.getColumn(i).getPreferredWidth();
                ++i;
            }
        }
        int viewportWidth = this.scrollGPIOPinDisplay.getViewport().getWidth();
        int baseNonLast = 0;
        int i = 0;
        while (i < count - 1) {
            baseNonLast += this.baseColumnWidths[i];
            ++i;
        }
        int baseLast = this.baseColumnWidths[count - 1];
        int targetWidth = Math.max(baseLast, viewportWidth - baseNonLast);
        TableColumn last = cm.getColumn(count - 1);
        if (last.getPreferredWidth() != targetWidth) {
            last.setPreferredWidth(targetWidth);
            this.table.revalidate();
        }
    }

    private void rebuildDetailPanel(final String pinName, final int modelRow) {
        this.panelGPIOConfig.removeAll();
        this.scrollGPIOConfig.setBorder(BorderFactory.createTitledBorder(pinName));
        int gridy = 0;
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.gridx = 0;
        gbcLabel.insets = new Insets(4, 12, 4, 8);
        gbcLabel.anchor = 21;
        GridBagConstraints gbcField = new GridBagConstraints();
        gbcField.gridx = 1;
        gbcField.weightx = 1.0;
        gbcField.fill = 2;
        gbcField.insets = new Insets(4, 0, 4, 12);
        if (GPIOConfigUtil.PinComboBoxItemsMap.containsKey(pinName)) {
            Map<String, List<String>> map = GPIOConfigUtil.PinComboBoxItemsMap.get(pinName);
            for (GPIOConfigCtrlStruct control : GPIOConfigUtil.lstConfigControls) {
                List<String> lstItems;
                String strMode;
                final String id = control.getId();
                if ((id.equals("InputFilterType") || id.equals("InputFilter")) && !(strMode = this.model.getValueAt(modelRow, GPIOInfoUtil.getConfigColIndex((String)"GPIOMode")).toString()).equals("Input Mode") && !strMode.contains("Alternate Function") || id.equals("OutputLevel") && !(strMode = this.model.getValueAt(modelRow, GPIOInfoUtil.getConfigColIndex((String)"GPIOMode")).toString()).contains("Output ") || id.equals("MaxSpeed") && control.getType().equals("comboBox") && (lstItems = map.get(id)) != null && lstItems.size() == 0) continue;
                JPanel labelPanel = new JPanel(new FlowLayout(0, 2, 0));
                labelPanel.setOpaque(false);
                JLabel label = new JLabel(control.getName());
                label.setFont(new Font("Arial", 1, 13));
                labelPanel.add(label);
                if (id.equals("InputFilterType") && this.model.getValueAt(modelRow, GPIOInfoUtil.getConfigColIndex((String)"GPIOMode")).toString().contains("Alternate Function")) {
                    ImageIcon alertIcon = new ImageIcon("icon/alert.png");
                    if (alertIcon.getImageLoadStatus() != 8) {
                        alertIcon = new ImageIcon(this.getClass().getResource("/icon/alert.png"));
                    }
                    if (alertIcon.getIconWidth() > 16) {
                        alertIcon = new ImageIcon(alertIcon.getImage().getScaledInstance(16, 16, 4));
                    }
                    labelPanel.add(new JLabel(alertIcon));
                    labelPanel.setToolTipText("If the peripheral performs synchronization by itself, it must be set to asynchronous mode.");
                }
                gbcLabel.gridy = gridy;
                this.panelGPIOConfig.add((Component)labelPanel, gbcLabel);
                if (map.containsKey(id)) {
                    String cur;
                    Object comboBox;
                    List<String> items;
                    if (control.getType().equals("comboBox")) {
                        items = map.get(id);
                        if (items != null && items.size() > 0) {
                            comboBox = new JComboBox<String>(items.toArray(new String[0]));
                            ((JComboBox)comboBox).setEnabled(true);
                            cur = this.model.getValueAt(modelRow, GPIOInfoUtil.getConfigColIndex((String)id)).toString();
                            ((JComboBox)comboBox).setSelectedItem(cur);
                        } else {
                            comboBox = new JComboBox();
                            ((JComboBox)comboBox).setEnabled(false);
                        }
                        gbcField.gridy = gridy;
                        this.panelGPIOConfig.add((Component)comboBox, gbcField);
                        ((JComboBox)comboBox).addItemListener(arg_0 -> this.lambda$2((JComboBox)comboBox, modelRow, id, pinName, arg_0));
                    } else if (control.getType().equals("editcombo")) {
                        items = map.get(id);
                        if (items != null && items.size() > 0) {
                            comboBox = new GDEditComboBox((Object[])items.toArray(new String[0]));
                            comboBox.setEnabled(true);
                            cur = this.model.getValueAt(modelRow, GPIOInfoUtil.getConfigColIndex((String)id)).toString();
                            comboBox.setSelectedItem((Object)cur);
                        } else {
                            comboBox = new GDEditComboBox();
                            comboBox.setEnabled(false);
                        }
                        gbcField.gridy = gridy;
                        this.panelGPIOConfig.add((Component)comboBox, gbcField);
                        comboBox.addItemListener(arg_0 -> this.lambda$3((GDEditComboBox)comboBox, modelRow, id, pinName, arg_0));
                    }
                } else if (control.getType().equals("edit")) {
                    final JTextField txtEdit = new JTextField();
                    gbcField.gridy = gridy;
                    this.panelGPIOConfig.add((Component)txtEdit, gbcField);
                    txtEdit.setColumns(10);
                    final String original = this.model.getValueAt(modelRow, GPIOInfoUtil.getConfigColIndex((String)id)).toString();
                    txtEdit.setText(original);
                    Document dt = txtEdit.getDocument();
                    final boolean isUserLabel = id.equals("UserLabel");
                    dt.addDocumentListener(new DocumentListener(){

                        private void sync(boolean validate) {
                            if (isUserLabel && validate && !GPIOConfigTab.this.isVariableNameValid(txtEdit)) {
                                SwingUtilities.invokeLater(() -> txtEdit.setText(original));
                                GPIOConfigUtil.updatePinUserConfig(GPIOConfigTab.this.strModuleName, pinName, id, original);
                                GPIOConfigUtil.UnifyPinChange(GPIOConfigTab.this.strModuleName, pinName, id, original);
                                return;
                            }
                            String val = txtEdit.getText();
                            GPIOConfigTab.this.model.setValueAt(val, modelRow, GPIOInfoUtil.getConfigColIndex((String)id));
                            GPIOConfigUtil.updatePinUserConfig(GPIOConfigTab.this.strModuleName, pinName, id, val);
                            GPIOConfigUtil.UnifyPinChange(GPIOConfigTab.this.strModuleName, pinName, id, val);
                            GlobalVariables.UpdatePinPadUserLabel((String)pinName, (String)val);
                            GPIOConfigTab.this.scrollGPIOPinDisplay.updateUI();
                            GlobalVariables.isDirtyFlag = true;
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.sync(true);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.sync(false);
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                        }
                    });
                }
                ++gridy;
            }
        }
        this.panelGPIOConfig.revalidate();
        this.panelGPIOConfig.repaint();
    }

    private void ensureDetailPanelVisible() {
        if (this.detailPanelVisible && this.scrollGPIOConfig.getParent() == this) {
            return;
        }
        int containerH = this.getHeight();
        if (containerH <= 0) {
            SwingUtilities.invokeLater(this::ensureDetailPanelVisible);
            return;
        }
        int targetH = (int)Math.max(160.0, (double)containerH * 0.38);
        this.scrollGPIOConfig.setPreferredSize(new Dimension(this.getWidth(), targetH));
        this.add((Component)this.scrollGPIOConfig, "South");
        this.detailPanelVisible = true;
        this.revalidate();
        if (!this.layoutResizeListenerAdded) {
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (!GPIOConfigTab.this.detailPanelVisible) {
                        return;
                    }
                    int h = GPIOConfigTab.this.getHeight();
                    if (h > 0) {
                        int newH = (int)Math.max(160.0, (double)h * 0.38);
                        GPIOConfigTab.this.scrollGPIOConfig.setPreferredSize(new Dimension(GPIOConfigTab.this.getWidth(), newH));
                        GPIOConfigTab.this.revalidate();
                    }
                }
            });
            this.layoutResizeListenerAdded = true;
        }
    }

    public String getTabTitle() {
        return this.strModuleName;
    }

    public boolean isVariableNameValid(JTextField jTextField) {
        String input = jTextField.getText().trim();
        if (input.isEmpty()) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(input.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < input.length()) {
            if (!Character.isJavaIdentifierPart(input.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void applyFilters() {
        if (this.table == null || this.table.getRowSorter() == null) {
            return;
        }
        TableRowSorter sorter = (TableRowSorter)this.table.getRowSorter();
        ArrayList filters = new ArrayList();
        if (this.FilterTextEnable && this.strTarget != null && !this.strTarget.isEmpty()) {
            try {
                filters.add(RowFilter.regexFilter("(?i)" + Pattern.quote(this.strTarget), GPIOInfoUtil.getConfigColIndex((String)"SignalOnPin")));
            }
            catch (Exception exception) {}
        }
        if (this.FilterCheckBoxEnable) {
            filters.add(RowFilter.regexFilter(TRUE_FLAG, GPIOInfoUtil.getConfigColIndex((String)"ModifyFlag")));
        }
        if (filters.isEmpty()) {
            sorter.setRowFilter(null);
        } else if (filters.size() == 1) {
            sorter.setRowFilter((RowFilter)filters.get(0));
        } else {
            sorter.setRowFilter(RowFilter.andFilter(filters));
        }
    }

    private void adjustInitialColumnWidths() {
        if (this.table == null) {
            return;
        }
        TableColumnModel columnModel = this.table.getColumnModel();
        this.tempWidthSum = 0;
        int maxSampleRows = Math.min(15, this.table.getRowCount());
        int column = 0;
        while (column < this.table.getColumnCount()) {
            TableColumn tableColumn = columnModel.getColumn(column);
            int preferredWidth = 90;
            int row = 0;
            while (row < maxSampleRows) {
                TableCellRenderer cellRenderer = this.table.getCellRenderer(row, column);
                Component cellComponent = this.table.prepareRenderer(cellRenderer, row, column);
                int cellWidth = cellComponent.getPreferredSize().width + this.table.getIntercellSpacing().width + 50;
                preferredWidth = Math.max(preferredWidth, cellWidth);
                ++row;
            }
            tableColumn.setPreferredWidth(preferredWidth);
            this.tempWidthSum += preferredWidth;
            ++column;
        }
    }

    public void saveSortingOrder() {
        if (this.table == null || this.table.getRowSorter() == null || this.strModuleName == null) {
            return;
        }
        Map<String, Vector<String>> original = GPIOConfigUtil.GPIOConfigInfoMapTemp.get(this.strModuleName);
        if (original == null) {
            return;
        }
        boolean hasFilter = false;
        if (this.table.getRowSorter() instanceof TableRowSorter) {
            RowFilter rf = ((TableRowSorter)this.table.getRowSorter()).getRowFilter();
            boolean bl = hasFilter = rf != null;
        }
        if (hasFilter) {
            return;
        }
        LinkedHashMap newOrdered = new LinkedHashMap();
        int viewRow = 0;
        while (viewRow < this.table.getRowCount()) {
            int modelRow = this.table.convertRowIndexToModel(viewRow);
            String pinName = (String)this.model.getValueAt(modelRow, 0);
            Vector<String> rowData = new Vector<String>();
            int col = 0;
            while (col < this.model.getColumnCount()) {
                rowData.add((String)this.model.getValueAt(modelRow, col));
                ++col;
            }
            newOrdered.put(pinName, rowData);
            ++viewRow;
        }
        GPIOConfigUtil.GPIOConfigInfoMapTemp.put(this.strModuleName, newOrdered);
    }

    private /* synthetic */ void lambda$2(JComboBox jComboBox, int n, String string, String string2, ItemEvent ev) {
        if (ev.getStateChange() == 1) {
            String sel = jComboBox.getSelectedItem().toString();
            this.model.setValueAt(sel, n, GPIOInfoUtil.getConfigColIndex((String)string));
            GPIOConfigUtil.updatePinUserConfig(this.strModuleName, string2, string, sel);
            GPIOConfigUtil.UnifyPinChange(this.strModuleName, string2, string, sel);
            this.scrollGPIOPinDisplay.updateUI();
            GlobalVariables.isDirtyFlag = true;
        }
    }

    private /* synthetic */ void lambda$3(GDEditComboBox gDEditComboBox, int n, String string, String string2, ItemEvent ev) {
        if (ev.getStateChange() == 1) {
            String sel = gDEditComboBox.getSelectedItem().toString();
            this.model.setValueAt(sel, n, GPIOInfoUtil.getConfigColIndex((String)string));
            GPIOConfigUtil.updatePinUserConfig(this.strModuleName, string2, string, sel);
            GPIOConfigUtil.UnifyPinChange(this.strModuleName, string2, string, sel);
            this.scrollGPIOPinDisplay.updateUI();
            GlobalVariables.isDirtyFlag = true;
        }
    }

    static enum LabelAddDel {
        LABEL_ADD,
        LABEL_DELETE;

    }
}

