/*
 * Copyright (c) 2020 Nordic Semiconductor ASA
 *
 * SPDX-License-Identifier: Apache-2.0
 */
/*!
    \file    app_mesh.h
    \brief   Header file for BLE mesh application.

    \version 2024-05-24, V1.0.0, firmware for GD32VW55x
*/

/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef APP_MESH_H_
#define APP_MESH_H_

const char *bearer2str(bt_mesh_prov_bearer_t bearer);

void app_mesh_cdb_node_add(uint16_t addr, uint8_t num_elem, uint16_t net_idx, uint8_t uuid[16],
                           uint8_t dev_key[16]);

void app_mesh_cdb_subnet_add(uint16_t net_idx, uint8_t net_key[16]);

void app_mesh_cdb_app_key_add(uint16_t net_idx, uint16_t app_idx, uint8_t app_key[16]);

void app_mesh_provision_local(uint16_t net_idx, uint32_t iv_index, uint16_t addr, uint8_t *net_key, uint8_t *dev_key);

void app_mesh_set_dev_uuid_prop(uint8_t uuid[16]);

void app_mesh_init(void);

void app_mesh_cdb_print_nodes(void);

void app_mesh_cdb_print_subnets(void);

void app_mesh_cdb_print_app_keys(void);

void app_mesh_auth_method_set_done(void);

int vnd_button_op(uint16_t net_idx, uint16_t app_idx, uint16_t dst, uint8_t op);

int vnd_button_op_va(uint16_t net_idx, uint16_t app_idx, uint16_t dst, uint8_t op, uint8_t uuid[16]);
#endif // APP_MESH_H_