#ifndef MESH_CFG_INT_H_
#define MESH_CFG_INT_H_

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CONFIG_BT_MESH 1
#define CONFIG_BT_MESH_PROXY 1
#define CONFIG_BT_MESH_PROXY_MSG_LEN 66
#define CONFIG_BT_MESH_GATT_CLIENT 1
#define CONFIG_BT_MESH_GATT_SERVER 1
#define CONFIG_BT_MESH_PB_GATT_COMMON 1
#define CONFIG_BT_MESH_PROV 1
#define CONFIG_BT_DEVICE_NAME "GD-BLE-MESH"
#define CONFIG_BT_SETTINGS 1
#define CONFIG_BT_CONN 1
#define CONFIG_BT_MAX_CONN 1
#define CONFIG_BT_MESH_ADV_EXT 1
#define CONFIG_BT_MESH_ADV_STACK_SIZE 1024
#define CONFIG_BT_MESH_ADV_PRIO 2
#define CONFIG_BT_EXT_ADV_MAX_ADV_SET 4
#define CONFIG_BT_MESH_RELAY_ADV_SETS 0
#define CONFIG_BT_MESH_ADV_BUF_COUNT 6
#define CONFIG_BT_MESH_PB_ADV 1
#define CONFIG_BT_MESH_UNPROV_BEACON_INT 5
#define CONFIG_BT_MESH_PB_ADV_TRANS_PDU_RETRANSMIT_COUNT 0
#define CONFIG_BT_MESH_PB_ADV_TRANS_ACK_RETRANSMIT_COUNT 2
#define CONFIG_BT_MESH_PB_ADV_LINK_CLOSE_RETRANSMIT_COUNT 2
#define CONFIG_BT_MESH_PB_ADV_RETRANS_TIMEOUT 500
#define CONFIG_BT_MESH_PB_GATT 1
#define CONFIG_BT_MESH_PB_GATT_USE_DEVICE_NAME 1
#define CONFIG_BT_MESH_PB_GATT_CLIENT 1
#define CONFIG_BT_MESH_PROVISIONEE 1
#define CONFIG_BT_MESH_PROV_OOB_PUBLIC_KEY 1
#define CONFIG_BT_MESH_ECDH_P256_CMAC_AES128_AES_CCM 1
#define CONFIG_BT_MESH_ECDH_P256_HMAC_SHA256_AES_CCM 1
#define CONFIG_BT_MESH_PROVISIONER 1
#define CONFIG_BT_MESH_CDB 1
#define CONFIG_BT_MESH_CDB_NODE_COUNT 8
#define CONFIG_BT_MESH_CDB_SUBNET_COUNT 1
#define CONFIG_BT_MESH_CDB_APP_KEY_COUNT 1
#define CONFIG_BT_MESH_LOOPBACK_BUFS 3
#define CONFIG_BT_MESH_NETWORK_TRANSMIT_COUNT 2
#define CONFIG_BT_MESH_NETWORK_TRANSMIT_INTERVAL 20
#define CONFIG_BT_MESH_MSG_CACHE_SIZE 32
#define CONFIG_BT_MESH_RELAY 1
#define CONFIG_BT_MESH_RELAY_ENABLED 1
#define CONFIG_BT_MESH_RELAY_RETRANSMIT_COUNT 2
#define CONFIG_BT_MESH_RELAY_RETRANSMIT_INTERVAL 20
#define CONFIG_BT_MESH_RELAY_BUF_COUNT 32
#define CONFIG_BT_MESH_TX_SEG_MSG_COUNT 5
#define CONFIG_BT_MESH_RX_SEG_MSG_COUNT 5
#define CONFIG_BT_MESH_SEG_BUFS 64
#define CONFIG_BT_MESH_RX_SEG_MAX 20
#define CONFIG_BT_MESH_TX_SEG_MAX 6
#define CONFIG_BT_MESH_SAR_TX_SEG_INT_STEP 0x05
#define CONFIG_BT_MESH_SAR_TX_UNICAST_RETRANS_COUNT 0x02
#define CONFIG_BT_MESH_SAR_TX_UNICAST_RETRANS_WITHOUT_PROG_COUNT 0x02
#define CONFIG_BT_MESH_SAR_TX_UNICAST_RETRANS_INT_STEP 0x07
#define CONFIG_BT_MESH_SAR_TX_UNICAST_RETRANS_INT_INC 0x01
#define CONFIG_BT_MESH_SAR_TX_MULTICAST_RETRANS_COUNT 0x02
#define CONFIG_BT_MESH_SAR_TX_MULTICAST_RETRANS_INT 0x09
#define CONFIG_BT_MESH_SAR_RX_SEG_THRESHOLD 0x03
#define CONFIG_BT_MESH_SAR_RX_ACK_DELAY_INC 0x01
#define CONFIG_BT_MESH_SAR_RX_SEG_INT_STEP 0x05
#define CONFIG_BT_MESH_SAR_RX_DISCARD_TIMEOUT 0x01
#define CONFIG_BT_MESH_SAR_RX_ACK_RETRANS_COUNT 0x00
#define CONFIG_BT_MESH_DEFAULT_TTL 7
#define CONFIG_BT_MESH_CRPL 10
#define CONFIG_BT_MESH_RPL_STORAGE_MODE_SETTINGS 1
#define CONFIG_BT_MESH_ACCESS_LAYER_MSG 1
#define CONFIG_BT_MESH_MODEL_VND_MSG_CID_FORCE 1
#define CONFIG_BT_MESH_MODEL_EXTENSIONS 1
#define CONFIG_BT_MESH_COMP_PST_BUF_SIZE 100
#define CONFIG_BT_MESH_ACCESS_DELAYABLE_MSG 1
#define CONFIG_BT_MESH_ACCESS_DELAYABLE_MSG_CTX_ENABLED 1
#define CONFIG_BT_MESH_ACCESS_DELAYABLE_MSG_COUNT 4
#define CONFIG_BT_MESH_ACCESS_DELAYABLE_MSG_CHUNK_SIZE 10
#define CONFIG_BT_MESH_ACCESS_DELAYABLE_MSG_CHUNK_COUNT 40
#define CONFIG_BT_MESH_DELAYABLE_PUBLICATION 1
#define CONFIG_BT_MESH_CFG_CLI 1
#define CONFIG_BT_MESH_CFG_CLI_TIMEOUT 5000
#define CONFIG_BT_MESH_HEALTH_CLI 1
#define CONFIG_BT_MESH_HEALTH_CLI_TIMEOUT 2000
#define CONFIG_BT_MESH_BLOB_SRV 1
#define CONFIG_BT_MESH_BLOB_SRV_PULL_REQ_COUNT 4
#define CONFIG_BT_MESH_BLOB_SIZE_MAX 524288
#define CONFIG_BT_MESH_BLOB_BLOCK_SIZE_MIN 4096
#define CONFIG_BT_MESH_BLOB_BLOCK_SIZE_MAX 4096
#define CONFIG_BT_MESH_BLOB_REPORT_TIMEOUT 10
#define CONFIG_BT_MESH_BLOB_CLI 1
#define CONFIG_BT_MESH_BLOB_CLI_BLOCK_RETRIES 5
#define CONFIG_BT_MESH_TX_BLOB_CHUNK_SEND_INTERVAL 0
#define CONFIG_BT_MESH_ALIGN_CHUNK_SIZE_TO_MAX_SEGMENT 1
#define CONFIG_BT_MESH_BLOB_CHUNK_COUNT_MAX 256
#define CONFIG_BT_MESH_DFU_SRV 1
#define CONFIG_BT_MESH_DFU_CLI 1
#define CONFIG_BT_MESH_DFU_FWID_MAXLEN 16
#define CONFIG_BT_MESH_DFU_METADATA_MAXLEN 32
#define CONFIG_BT_MESH_DFU_METADATA 1
#define CONFIG_BT_MESH_DFU_URI_MAXLEN 32
#define CONFIG_BT_MESH_DFU_SLOTS 1
#define CONFIG_BT_MESH_DFU_SLOT_CNT 1
#define CONFIG_BT_MESH_RPR_SRV 1
#define CONFIG_BT_MESH_RPR_CLI 1
#define CONFIG_BT_MESH_RPR_AD_TYPES_MAX 8
#define CONFIG_BT_MESH_RPR_SRV_SCANNED_ITEMS_MAX 4
#define CONFIG_BT_MESH_RPR_SRV_AD_DATA_MAX 31
#define CONFIG_BT_MESH_SAR_CFG 1
#define CONFIG_BT_MESH_SAR_CFG_SRV 1
#define CONFIG_BT_MESH_SAR_CFG_CLI 1
#define CONFIG_BT_MESH_OP_AGG 1
#define CONFIG_BT_MESH_OP_AGG_SRV 1
#define CONFIG_BT_MESH_OP_AGG_CLI 1
#define CONFIG_BT_MESH_OP_AGG_CLI_TIMEOUT 10000
#define CONFIG_BT_MESH_LARGE_COMP_DATA_SRV 1
#define CONFIG_BT_MESH_MODELS_METADATA_PAGE_LEN 150
#define CONFIG_BT_MESH_LARGE_COMP_DATA_CLI 1
#define CONFIG_BT_MESH_PRIV_BEACON_SRV 1
#define CONFIG_BT_MESH_PRIV_BEACON_CLI 1
#define CONFIG_BT_MESH_OD_PRIV_PROXY_CLI 1
#define CONFIG_BT_MESH_OD_PRIV_PROXY_CLI_TIMEOUT 5000
#define CONFIG_BT_MESH_OD_PRIV_PROXY_SRV 1
#define CONFIG_BT_MESH_PROXY_SRPL_SIZE 10
#define CONFIG_BT_MESH_SOL_PDU_RPL_CLI 1
#define CONFIG_BT_MESH_SOL_PDU_RPL_CLI_TIMEOUT 5000
#define CONFIG_BT_MESH_BRG_TABLE_ITEMS_MAX 16
#define CONFIG_BT_MESH_GATT_PROXY 1
#define CONFIG_BT_MESH_GATT_PROXY_ENABLED 1
#define CONFIG_BT_MESH_NODE_ID_TIMEOUT 60
#define CONFIG_BT_MESH_PROXY_USE_DEVICE_NAME 1
#define CONFIG_BT_MESH_PROXY_FILTER_SIZE 16
#define CONFIG_BT_MESH_PROXY_CLIENT 1
#define CONFIG_BT_MESH_SOLICITATION 1
#define CONFIG_BT_MESH_PROXY_SOLICITATION 1
#define CONFIG_BT_MESH_SOL_ADV_XMIT 2
#define CONFIG_BT_MESH_BEACON_ENABLED 1
#define CONFIG_BT_MESH_PRIV_BEACONS 1
#define CONFIG_BT_MESH_IV_UPDATE_TEST 1
#define CONFIG_BT_MESH_IV_UPDATE_SEQ_LIMIT 0x800000
#define CONFIG_BT_MESH_IVU_DIVIDER 4
#define CONFIG_BT_MESH_SUBNET_COUNT 2
#define CONFIG_BT_MESH_APP_KEY_COUNT 2
#define CONFIG_BT_MESH_MODEL_KEY_COUNT 2
#define CONFIG_BT_MESH_MODEL_GROUP_COUNT 2
#define CONFIG_BT_MESH_LABEL_COUNT 2
#define CONFIG_BT_MESH_STORE_TIMEOUT 3
#define CONFIG_BT_MESH_SEQ_STORE_RATE 128
#define CONFIG_BT_MESH_RPL_STORE_TIMEOUT 5
#define CONFIG_BT_MESH_SETTINGS_WORKQ 1
#define CONFIG_BT_MESH_SETTINGS_WORKQ_PRIO 2
#define CONFIG_BT_MESH_SETTINGS_WORKQ_STACK_SIZE 768
#define CONFIG_BT_MESH_MAX_CONN 1

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* MESH_CFG_INT_H_*/
