if(NOT NXP_TOOLCHAIN_PATH)
     set(NXP_TOOLCHAIN_PATH "/usr")
     message(STATUS "No NXP_TOOLCHAIN_PATH specified, using default: " ${NXP_TOOLCHAIN_PATH})
else()
     file(TO_CMAKE_PATH "${NXP_TOOLCHAIN_PATH}" NXP_TOOLCHAIN_PATH)
endif()

if(NOT NXP_TARGET_TRIPLET)
    set(NXP_TARGET_TRIPLET "arm-none-eabi")
    message(STATUS "No NXP_TARGET_TRIPLET specified, using default: " ${NXP_TARGET_TRIPLET})
endif()

set(CMAKE_SYSTEM_NAME Generic)
set(CMAKE_SYSTEM_PROCESSOR arm)

set(TOOLCHAIN_SYSROOT  "${NXP_TOOLCHAIN_PATH}/${NXP_TARGET_TRIPLET}")
set(TOOLCHAIN_BIN_PATH "${NXP_TOOLCHAIN_PATH}/bin")
set(TOOLCHAIN_INC_PATH "${NXP_TOOLCHAIN_PATH}/${NXP_TARGET_TRIPLET}/include")
set(TOOLCHAIN_LIB_PATH "${NXP_TOOLCHAIN_PATH}/${NXP_TARGET_TRIPLET}/lib")

find_program(CMAKE_OBJCOPY NAMES ${NXP_TARGET_TRIPLET}-objcopy PATHS ${TOOLCHAIN_BIN_PATH} NO_DEFAULT_PATH)
find_program(CMAKE_OBJDUMP NAMES ${NXP_TARGET_TRIPLET}-objdump PATHS ${TOOLCHAIN_BIN_PATH} NO_DEFAULT_PATH)
find_program(CMAKE_SIZE NAMES ${NXP_TARGET_TRIPLET}-size PATHS ${TOOLCHAIN_BIN_PATH} NO_DEFAULT_PATH)
find_program(CMAKE_DEBUGGER NAMES ${NXP_TARGET_TRIPLET}-gdb PATHS ${TOOLCHAIN_BIN_PATH} NO_DEFAULT_PATH)
find_program(CMAKE_CPPFILT NAMES ${NXP_TARGET_TRIPLET}-c++filt PATHS ${TOOLCHAIN_BIN_PATH} NO_DEFAULT_PATH)
