"""General key class."""

import sys

AUTOGEN_MESSAGE = "/* Autogenerated by imgtool.py, do not edit. */"

class KeyClass(object):
    def _public_emit(self, header, trailer, indent, file=sys.stdout, len_format=None):
        print(AUTOGEN_MESSAGE, file=file)
        print(header, end='', file=file)
        encoded = self.get_public_bytes()
        for count, b in enumerate(encoded):
            if count % 8 == 0:
                print("\n" + indent, end='', file=file)
            else:
                print(" ", end='', file=file)
            print("0x{:02x},".format(b), end='', file=file)
        print("\n" + trailer, file=file)
        if len_format is not None:
            print(len_format.format(len(encoded)), file=file)

    def emit_c(self, file=sys.stdout):
        self._public_emit(
                header="const unsigned char {}_pub_key[] = {{".format(self.shortname()),
                trailer="};",
                indent="    ",
                len_format="const unsigned int {}_pub_key_len = {{}};".format(self.shortname()),
                file=file)

    def emit_rust(self, file=sys.stdout):
        self._public_emit(
                header="static {}_PUB_KEY: &'static [u8] = &[".format(self.shortname().upper()),
                trailer="];",
                indent="    ",
                file=file)
