/*!
    \file    main.h
    \brief   the header file of main 

    \version 2021-10-30, V1.0.0, firmware for GD32W51x
*/

/*
    Copyright (c) 2021, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#include "gd32w51x.h"
#include "stdio.h"

#ifndef MAIN_H
#define MAIN_H

__attribute__((aligned(4)))
uint8_t message_input_task_1[] = {
    0x54, 0x68, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x20, 0x69,
    0x73, 0x20, 0x61, 0x20, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x74, 0x20,
    0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
    0x65, 0x20, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
    0x74, 0x68, 0x6d, 0x20, 0x0d, 0x0a, 0x28, 0x53, 0x48, 0x41, 0x2d, 0x31, 0x2c, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x32,
    0x34, 0x2c, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x35, 0x36, 0x29, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x44, 0x35,
    0x20, 0x28, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2d, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x20, 0x61, 0x6c, 0x67,
    0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x20, 0x35, 0x29, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72,
    0x69, 0x74, 0x68, 0x6d, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x0d, 0x0a, 0x74, 0x68, 0x65, 0x20, 0x48, 0x4d, 0x41, 0x43, 0x20,
    0x28, 0x6b, 0x65, 0x79, 0x65, 0x64, 0x2d, 0x68, 0x61, 0x73, 0x68, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20,
    0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x63, 0x6f, 0x64, 0x65, 0x29,
    0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x20, 0x73, 0x75, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20,
    0x66, 0x6f, 0x72, 0x20, 0x61, 0x20, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x0d, 0x0a, 0x61,
    0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x20, 0x49, 0x74, 0x20, 0x63, 0x6f, 0x6d, 0x70,
    0x75, 0x74, 0x65, 0x73, 0x20, 0x61, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64, 0x69, 0x67, 0x65, 0x73,
    0x74, 0x20, 0x28, 0x31, 0x36, 0x30, 0x20, 0x62, 0x69, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20,
    0x53, 0x48, 0x41, 0x2d, 0x31, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x2c, 0x20, 0x32, 0x35, 0x36,
    0x20, 0x62, 0x69, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x0d, 0x0a, 0x74, 0x68, 0x65, 0x20, 0x53, 0x48, 0x41, 0x2d,
    0x32, 0x35, 0x36, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x32, 0x32,
    0x34, 0x20, 0x62, 0x69, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32,
    0x32, 0x34, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x2c, 0x31, 0x32, 0x38, 0x20, 0x62, 0x69, 0x74,
    0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x44, 0x35, 0x20, 0x0d, 0x0a, 0x61, 0x6c, 0x67, 0x6f,
    0x72, 0x69, 0x74, 0x68, 0x6d, 0x29, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x20,
    0x6f, 0x66, 0x20, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20, 0x28, 0x32, 0x36, 0x34, 0x20, 0xe2, 0x80, 0x93, 0x20, 0x31, 0x29,
    0x20, 0x62, 0x69, 0x74, 0x73, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20, 0x48, 0x4d, 0x41, 0x43, 0x20, 0x61, 0x6c,
    0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x20, 0x61, 0x20, 0x77,
    0x61, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x0d, 0x0a, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
    0x6e, 0x67, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x20, 0x62, 0x79, 0x20, 0x6d, 0x65, 0x61, 0x6e, 0x73,
    0x20, 0x6f, 0x66, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x20,
    0x48, 0x4d, 0x41, 0x43, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73,
    0x69, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x0d, 0x0a, 0x74, 0x68, 0x65,
    0x20, 0x53, 0x48, 0x41, 0x2d, 0x31, 0x2c, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x32, 0x34, 0x2c, 0x20, 0x53, 0x48, 0x41,
    0x2d, 0x32, 0x35, 0x36, 0x20, 0x6f, 0x72, 0x20, 0x4d, 0x44, 0x35, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x66, 0x75, 0x6e,
    0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x77, 0x69, 0x63, 0x65, 0x2e, 0x0d, 0x0a, 0x0d, 0x0a, 0x54, 0x68, 0x65, 0x20,
    0x46, 0x49, 0x50, 0x53, 0x20, 0x50, 0x55, 0x42, 0x20, 0x31, 0x38, 0x30, 0x2d, 0x32, 0x20, 0x73, 0x74, 0x61, 0x6e, 0x64,
    0x61, 0x72, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x49, 0x45, 0x54, 0x46, 0x20, 0x52, 0x46, 0x43,
    0x20, 0x31, 0x33, 0x32, 0x31, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x73, 0x70,
    0x65, 0x63, 0x69, 0x66, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x31, 0x2c, 0x20, 0x53, 0x48, 0x41,
    0x2d, 0x0d, 0x0a, 0x32, 0x32, 0x34, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x35, 0x36, 0x20, 0x61,
    0x6e, 0x64, 0x20, 0x4d, 0x44, 0x35, 0x20, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x61,
    0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x73, 0x2c, 0x20, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x76,
    0x65, 0x6c, 0x79, 0x2c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x61,
    0x20, 0x0d, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65,
    0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
    0x20, 0x6f, 0x72, 0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x20, 0x57, 0x68, 0x65, 0x6e, 0x20,
    0x61, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6c, 0x65, 0x6e,
    0x67, 0x74, 0x68, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x77, 0x20, 0x0d, 0x0a, 0x32, 0x36, 0x34, 0x20, 0x62, 0x69, 0x74, 0x73,
    0x20, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x70, 0x75,
    0x74, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x31, 0x2c, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x32,
    0x34, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x35, 0x36, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x4d, 0x44,
    0x35, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x20, 0x0d, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
    0x76, 0x65, 0x20, 0x61, 0x20, 0x31, 0x36, 0x30, 0x2d, 0x62, 0x69, 0x74, 0x2c, 0x20, 0x32, 0x32, 0x34, 0x20, 0x62, 0x69,
    0x74, 0x2c, 0x20, 0x32, 0x35, 0x36, 0x20, 0x62, 0x69, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x31, 0x32, 0x38, 0x2d, 0x62,
    0x69, 0x74, 0x20, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x20, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2c, 0x20, 0x72, 0x65,
    0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x2c, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x61,
    0x20, 0x0d, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x2e, 0x20, 0x54,
    0x68, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x20, 0x63, 0x61,
    0x6e, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x20,
    0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x61,
    0x74, 0x75, 0x72, 0x65, 0x20, 0x0d, 0x0a, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x20, 0x69, 0x6e, 0x20,
    0x6f, 0x72, 0x64, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x72,
    0x20, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
    0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x20, 0x53,
    0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x0d,
    0x0a, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x20, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20,
    0x74, 0x68, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x69, 0x6d,
    0x70, 0x72, 0x6f, 0x76, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63,
    0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x20, 0x62, 0x65, 0x63,
    0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x0d, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64,
    0x69, 0x67, 0x65, 0x73, 0x74, 0x20, 0x69, 0x73, 0x20, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x6d, 0x75, 0x63,
    0x68, 0x20, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x20, 0x69, 0x6e, 0x20, 0x73, 0x69, 0x7a, 0x65, 0x20, 0x74, 0x68,
    0x61, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20,
    0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61,
    0x6c, 0x20, 0x0d, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x68, 0x61, 0x73, 0x20, 0x74, 0x6f,
    0x20, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x61,
    0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x65, 0x20,
    0x75, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x20,
    0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x20, 0x0d, 0x0a, 0x73, 0x69, 0x67,
    0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x0d, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x31, 0x2c, 0x20,
    0x53, 0x48, 0x41, 0x2d, 0x32, 0x32, 0x34, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x35, 0x36, 0x20,
    0x61, 0x6e, 0x64, 0x20, 0x4d, 0x44, 0x35, 0x20, 0x61, 0x72, 0x65, 0x20, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65,
    0x64, 0x20, 0x61, 0x73, 0x20, 0xe2, 0x80, 0x9c, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0xe2, 0x80, 0x9d, 0x20, 0x62, 0x65,
    0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x0d, 0x0a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
    0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x69, 0x6e, 0x66, 0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65,
    0x20, 0x74, 0x6f, 0x20, 0x66, 0x69, 0x6e, 0x64, 0x20, 0x61, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x74,
    0x68, 0x61, 0x74, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x61,
    0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64, 0x69, 0x67, 0x65, 0x73,
    0x74, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x0d, 0x0a, 0x74, 0x6f, 0x20, 0x66, 0x69, 0x6e, 0x64, 0x20, 0x74, 0x77, 0x6f, 0x20,
    0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x20, 0x74,
    0x68, 0x61, 0x74, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65,
    0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x2e, 0x20, 0x41, 0x6e, 0x79,
    0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x20, 0x0d, 0x0a, 0x6d, 0x65, 0x73, 0x73, 0x61,
    0x67, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x2c, 0x20,
    0x77, 0x69, 0x74, 0x68, 0x20, 0x76, 0x65, 0x72, 0x79, 0x20, 0x68, 0x69, 0x67, 0x68, 0x20, 0x70, 0x72, 0x6f, 0x62, 0x61,
    0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2c, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x20,
    0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x64, 0x69,
    0x67, 0x65, 0x73, 0x74, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x0d, 0x0a, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x67, 0x6e,
    0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x66, 0x61, 0x69, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x76,
    0x65, 0x72, 0x69, 0x66, 0x79, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x65, 0x74, 0x61,
    0x69, 0x6c, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x31, 0x20, 0x6f, 0x72, 0x20, 0x53,
    0x48, 0x41, 0x2d, 0x32, 0x32, 0x34, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x35, 0x36, 0x20, 0x0d,
    0x0a, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x2c, 0x20, 0x70, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x20, 0x72,
    0x65, 0x66, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x46, 0x49, 0x50, 0x53, 0x20, 0x50, 0x55, 0x42,
    0x20, 0x31, 0x38, 0x30, 0x2d, 0x32, 0x20, 0x28, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x49, 0x6e, 0x66, 0x6f,
    0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x53,
    0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x73, 0x20, 0x0d, 0x0a, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
    0x6f, 0x6e, 0x20, 0x31, 0x38, 0x30, 0x2d, 0x32, 0x29, 0x2c, 0x20, 0x32, 0x30, 0x30, 0x32, 0x20, 0x61, 0x75, 0x67, 0x75,
    0x73, 0x74, 0x20, 0x31, 0x2e, 0x0d, 0x0a, 0x0d, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
    0x20, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74,
    0x68, 0x69, 0x73, 0x20, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x20, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x20, 0x77,
    0x69, 0x74, 0x68, 0x20, 0x6c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x2d, 0x65, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x69, 0x6e,
    0x70, 0x75, 0x74, 0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
    0x20, 0x0d, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20,
    0x43, 0x20, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x20, 0xe2, 0x80, 0x9c, 0x61, 0x62, 0x63, 0xe2, 0x80, 0x9d, 0x20, 0x6d,
    0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x20, 0x69,
    0x6e, 0x20, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x32, 0x34, 0x2d, 0x62,
    0x69, 0x74, 0x20, 0x68, 0x65, 0x78, 0x61, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x20, 0x0d, 0x0a, 0x76, 0x61, 0x6c,
    0x75, 0x65, 0x20, 0x30, 0x78, 0x34, 0x33, 0x34, 0x32, 0x34, 0x31, 0x2e, 0x0d, 0x0a, 0x41, 0x20, 0x6d, 0x65, 0x73, 0x73,
    0x61, 0x67, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x66, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x20,
    0x62, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20,
    0x68, 0x61, 0x73, 0x68, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c,
    0x64, 0x20, 0x62, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x61, 0x20, 0x62, 0x69,
    0x74, 0x20, 0x0d, 0x0a, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x6c, 0x65, 0x6e, 0x67,
    0x74, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x69, 0x73,
    0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x62, 0x69, 0x74, 0x73, 0x20,
    0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x28, 0x74, 0x68, 0x65, 0x20,
    0x65, 0x6d, 0x70, 0x74, 0x79, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x0d, 0x0a, 0x68, 0x61, 0x73, 0x20,
    0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x30, 0x29, 0x2e, 0x20, 0x59, 0x6f, 0x75, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x63,
    0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x33, 0x32, 0x20, 0x62, 0x69, 0x74, 0x73,
    0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x62, 0x69, 0x74, 0x20, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x20,
    0x66, 0x6f, 0x72, 0x6d, 0x73, 0x20, 0x61, 0x20, 0x33, 0x32, 0x2d, 0x62, 0x69, 0x74, 0x20, 0x77, 0x6f, 0x72, 0x64, 0x2e,
    0x20, 0x4e, 0x6f, 0x74, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x0d, 0x0a, 0x74, 0x68, 0x65, 0x20, 0x46, 0x49, 0x50,
    0x53, 0x20, 0x50, 0x55, 0x42, 0x20, 0x31, 0x38, 0x30, 0x2d, 0x31, 0x20, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64,
    0x20, 0x75, 0x73, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
    0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x62, 0x69, 0x74, 0x20, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x20, 0x67, 0x72,
    0x6f, 0x77, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x6c, 0x65, 0x66, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x69, 0x67, 0x68,
    0x74, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x0d, 0x0a, 0x62, 0x69, 0x74, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65,
    0x20, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x65, 0x64, 0x20, 0x61, 0x73, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x20, 0x28, 0x38,
    0x20, 0x62, 0x69, 0x74, 0x73, 0x29, 0x20, 0x6f, 0x72, 0x20, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x20, 0x28, 0x33, 0x32, 0x20,
    0x62, 0x69, 0x74, 0x73, 0x29, 0x20, 0x28, 0x62, 0x75, 0x74, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x69, 0x6d, 0x70, 0x6c,
    0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x75, 0x73, 0x65,
    0x20, 0x0d, 0x0a, 0x68, 0x61, 0x6c, 0x66, 0x2d, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x20, 0x28, 0x31, 0x36, 0x20, 0x62, 0x69,
    0x74, 0x73, 0x29, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x2c,
    0x20, 0x75, 0x73, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x69, 0x67, 0x2d, 0x65, 0x6e, 0x64, 0x69, 0x61, 0x6e,
    0x20, 0x62, 0x79, 0x74, 0x65, 0x20, 0x28, 0x68, 0x61, 0x6c, 0x66, 0x2d, 0x77, 0x6f, 0x72, 0x64, 0x29, 0x20, 0x6f, 0x72,
    0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x0d, 0x0a, 0x63, 0x6f, 0x6e, 0x76, 0x65,
    0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x73, 0x20, 0x6d, 0x61, 0x69, 0x6e, 0x6c, 0x79, 0x20, 0x69, 0x6d, 0x70, 0x6f,
    0x72, 0x74, 0x61, 0x6e, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x0d, 0x0a,
    0x0d, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x20, 0x61, 0x72, 0x65, 0x20, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x69,
    0x6e, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
    0x6f, 0x72, 0x20, 0x33, 0x32, 0x20, 0x62, 0x69, 0x74, 0x73, 0x20, 0x28, 0x77, 0x6f, 0x72, 0x64, 0x29, 0x20, 0x61, 0x74,
    0x20, 0x61, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2c, 0x20, 0x62, 0x79, 0x20, 0x77, 0x72, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x20,
    0x74, 0x68, 0x65, 0x6d, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x0d, 0x0a, 0x48, 0x41, 0x53, 0x48,
    0x5f, 0x44, 0x49, 0x4e, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x20, 0x42, 0x75, 0x74, 0x20, 0x74,
    0x68, 0x65, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x20, 0x62, 0x69, 0x74, 0x2d, 0x73, 0x74, 0x72, 0x69,
    0x6e, 0x67, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x65, 0x64, 0x20,
    0x69, 0x6e, 0x20, 0x62, 0x79, 0x74, 0x65, 0x73, 0x2c, 0x20, 0x68, 0x61, 0x6c, 0x66, 0x2d, 0x77, 0x6f, 0x72, 0x64, 0x73,
    0x20, 0x6f, 0x72, 0x20, 0x0d, 0x0a, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x65, 0x76, 0x65, 0x6e,
    0x20, 0x62, 0x65, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x20, 0x61, 0x73, 0x20, 0x62,
    0x69, 0x74, 0x73, 0x2e, 0x20, 0x41, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20, 0x6d,
    0x65, 0x6d, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69,
    0x73, 0x20, 0x6c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x2d, 0x65, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x0d, 0x0a, 0x61, 0x6e,
    0x64, 0x20, 0x53, 0x48, 0x41, 0x31, 0x2c, 0x20, 0x53, 0x48, 0x41, 0x2d, 0x32, 0x32, 0x34, 0x20, 0x61, 0x6e, 0x64, 0x20,
    0x53, 0x48, 0x41, 0x2d, 0x32, 0x35, 0x36, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
    0x69, 0x73, 0x20, 0x62, 0x69, 0x67, 0x2d, 0x65, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x2c, 0x20, 0x64, 0x65, 0x70, 0x65, 0x6e,
    0x64, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x61, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20,
    0x0d, 0x0a, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x20, 0x62, 0x69, 0x74, 0x20, 0x73, 0x74, 0x72, 0x69, 0x6e,
    0x67, 0x20, 0x69, 0x73, 0x20, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x65, 0x64, 0x2c, 0x20, 0x61, 0x20, 0x62, 0x69, 0x74, 0x2c,
    0x20, 0x62, 0x79, 0x74, 0x65, 0x2c, 0x20, 0x6f, 0x72, 0x20, 0x68, 0x61, 0x6c, 0x66, 0x2d, 0x77, 0x6f, 0x72, 0x64, 0x20,
    0x73, 0x77, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69,
    0x73, 0x20, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x20, 0x0d, 0x0a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
    0x74, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x20,
    0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x2e, 0x0d, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x6b, 0x69, 0x6e, 0x64,
    0x20, 0x6f, 0x66, 0x20, 0x64, 0x61, 0x74, 0x61, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65,
    0x73, 0x73, 0x65, 0x64, 0x20, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x64, 0x20, 0x77,
    0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x41, 0x54, 0x41, 0x54, 0x59, 0x50, 0x45, 0x20, 0x62, 0x69, 0x74,
    0x66, 0x69, 0x65, 0x6c, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x48, 0x41, 0x53, 0x48, 0x20, 0x0d, 0x0a,
    0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x20, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x20, 0x28, 0x48, 0x41,
    0x53, 0x48, 0x5f, 0x43, 0x52, 0x29, 0x2e};

__attribute__((aligned(4)))
uint8_t message_input_task_2[] = {
    0x54,0x68,0x65,0x20,0x68,0x61,0x73,0x68,
    0x20,0x70,0x72,0x6f,0x63,0x65,0x73,0x73,
    0x6f,0x72,0x20,0x69,0x73,0x20,0x61,0x20,
    0x66,0x75,0x6c,0x6c,0x79,0x20,0x63,0x6f,
    0x6d,0x70,0x6c,0x69,0x61,0x6e,0x74,0x20,
    0x69,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,
    0x74,0x61,0x74,0x69,0x6f,0x6e,0x20,0x6f,
    0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x65,
    0x63,0x75,0x72,0x65,0x20,0x68,0x61,0x73,
    0x68,0x20,0x61,0x6c,0x67,0x6f,0x72,0x69,
    0x74,0x68,0x6d,0x20,0x28,0x53,0x48,0x41,
    0x2d,0x31,0x29,0x2c,0x20,0x74,0x68,0x65,
    0x20,0x4d,0x44,0x35,0x20,0x28,0x6d,0x65,
    0x73,0x73,0x61,0x67,0x65,0x2d,0x64,0x69,
    0x67,0x65,0x73,0x74,0x20,0x61,0x6c,0x67,
    0x6f,0x72,0x69,0x74,0x68,0x6d,0x20,0x35,
    0x29,0x20,0x68,0x61,0x73,0x68,0x20,0x61,
    0x6c,0x67,0x6f,0x72,0x69,0x74,0x68,0x6d,
    0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,
    0x20,0x48,0x4d,0x41,0x43,0x20,0x28,0x6b,
    0x65,0x79,0x65,0x64,0x2d,0x68,0x61,0x73,
    0x68,0x20,0x6d,0x65,0x73,0x73,0x61,0x67,
    0x65,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,
    0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,
    0x20,0x63,0x6f,0x64,0x65,0x29,0x20,0x61,
    0x6c,0x67,0x6f,0x72,0x69,0x74,0x68,0x6d,
    0x20,0x73,0x75,0x69,0x74,0x61,0x62,0x6c,
    0x65,0x20,0x66,0x6f,0x72,0x20,0x61,0x20,
    0x76,0x61,0x72,0x69,0x65,0x74,0x79,0x20,
    0x6f,0x66,0x20,0x61,0x70,0x70,0x6c,0x69,
    0x63,0x61,0x74,0x69,0x6f,0x6e,0x73,0x2e,
    0x2a,0x2a,0x2a,0x20,0x53,0x54,0x4d,0x33,
    0x32,0x20,0x2a,0x2a,0x2a};

#endif /* MAIN_H */
