/*
 * Copyright (c) 2019 Arm Limited. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __RTE_DEVICE_H
#define __RTE_DEVICE_H

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]
// <i> Configuration settings for Driver_USART0 in component ::Drivers:USART
#define   RTE_USART0                     1
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART0]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART1]
// <i> Configuration settings for Driver_USART1 in component ::Drivers:USART
#define   RTE_USART1                     0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART1]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART2]
// <i> Configuration settings for Driver_USART2 in component ::Drivers:USART
#define   RTE_USART2                     0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART2]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART3]
// <i> Configuration settings for Driver_USART3 in component ::Drivers:USART
#define   RTE_USART3                     0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART3]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART4]
// <i> Configuration settings for Driver_USART4 in component ::Drivers:USART
#define   RTE_USART4                     0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART4]

// <e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART5]
// <i> Configuration settings for Driver_USART5 in component ::Drivers:USART
#define   RTE_USART5                     0
// </e> USART (Universal synchronous - asynchronous receiver transmitter) [Driver_USART5]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM0_MPC]
// <i> Configuration settings for Driver_ISRAM0_MPC in component ::Drivers:MPC
#define   RTE_ISRAM0_MPC                 1
// </e> MPC (Memory Protection Controller) [Driver_ISRAM0_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM1_MPC]
// <i> Configuration settings for Driver_ISRAM1_MPC in component ::Drivers:MPC
#define   RTE_SSRAM1_MPC                 1
// </e> MPC (Memory Protection Controller) [Driver_ISRAM1_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM2_MPC]
// <i> Configuration settings for Driver_ISRAM2_MPC in component ::Drivers:MPC
#define   RTE_SSRAM2_MPC                 1
// </e> MPC (Memory Protection Controller) [Driver_ISRAM2_MPC]

// <e> MPC (Memory Protection Controller) [Driver_ISRAM3_MPC]
// <i> Configuration settings for Driver_ISRAM3_MPC in component ::Drivers:MPC
#define   RTE_SSRAM3_MPC                 1
// </e> MPC (Memory Protection Controller) [Driver_ISRAM3_MPC]

// <e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP0]
// <i> Configuration settings for Driver_AHB_PPCEXP0 in component ::Drivers:MPC
#define   RTE_PPC_SSE123_AHB_EXP0        1
// </e> PPC (Peripheral Protection Controller) [Driver_AHB_PPCEXP0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPC0]
// <i> Configuration settings for Driver_APB_PPC0 in component ::Drivers:MPC
#define   RTE_PPC_SSE123_APB             1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPC0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP0]
// <i> Configuration settings for Driver_APB_PPCEXP0 in component ::Drivers:MPC
#define   RTE_PPC_SSE123_APB_EXP0        1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP0]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP1]
// <i> Configuration settings for Driver_APB_PPCEXP1 in component ::Drivers:MPC
#define   RTE_PPC_SSE123_APB_EXP1        1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP1]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP2]
// <i> Configuration settings for Driver_APB_PPCEXP2 in component ::Drivers:MPC
#define   RTE_PPC_SSE123_APB_EXP2        1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP2]

// <e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP2]
// <i> Configuration settings for Driver_APB_PPCEXP2 in component ::Drivers:MPC
#define   RTE_PPC_SSE123_APB_EXP3        1
// </e> PPC (Peripheral Protection Controller) [Driver_APB_PPCEXP2]

// <e> Flash device emulated by BRAM [Driver_Flash0]
// <i> Configuration settings for Driver_Flash0 in component ::Drivers:Flash
#define   RTE_FLASH0                     1
// </e> Flash device emulated by BRAM [Driver_Flash0]

#endif  /* __RTE_DEVICE_H */
