/*!
    \file    main.h
    \brief   the header file of main

    \version 2025-08-11, V2.9.0, demo for GD32F20x
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32f20x.h"
#include "stdio.h"

#ifndef MAIN_H
#define MAIN_H

#define HASH_MODE               "HASH"
#define HMAC_MODE               "HMAC"
#define SHA1                    "SHA1"
#define SHA224                  "SHA224"
#define SHA256                  "SHA256"
#define MD5                     "MD5"

#define ALGORITHM_USE_SHA1      (0x01)
#define ALGORITHM_USE_SHA224    (0x02)
#define ALGORITHM_USE_SHA256    (0x04)
#define ALGORITHM_USE_MD5       (0x08)
#define MODE_USE_HASH           (0x10)
#define MODE_USE_HMAC           (0x20)

/* message to be hashed */
const uint8_t message_input[] = {
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63,
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63,
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63,
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63,
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63,
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63,
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63,
    0x43, 0x48, 0x4E, 0x20, 0x47, 0x69, 0x67, 0x61, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x20, 0x53,
    0x65, 0x6D, 0x69, 0x63, 0x6F, 0x6E, 0x64, 0x75, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x49, 0x6E, 0x63
};

/* key for HMAC mode */
const uint8_t key[] = {
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50,
    0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F, 0x50
};

#endif /* MAIN_H */
