/*!
    \file    gd32f403_libopt.h
    \brief   library optional for gd32f403

    \version 2025-08-20, V3.0.2, demo for GD32F403
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/


#ifndef GD32F403_LIBOPT_H
#define GD32F403_LIBOPT_H

#include "gd32f403_rcu.h"
#include "gd32f403_adc.h"
#include "gd32f403_can.h"
#include "gd32f403_crc.h"
#include "gd32f403_ctc.h"
#include "gd32f403_dac.h"
#include "gd32f403_dbg.h"
#include "gd32f403_dma.h"
#include "gd32f403_exti.h"
#include "gd32f403_fmc.h"
#include "gd32f403_fwdgt.h"
#include "gd32f403_gpio.h"
#include "gd32f403_i2c.h"
#include "gd32f403_pmu.h"
#include "gd32f403_bkp.h"
#include "gd32f403_rtc.h"
#include "gd32f403_sdio.h"
#include "gd32f403_spi.h"
#include "gd32f403_timer.h"
#include "gd32f403_usart.h"
#include "gd32f403_wwdgt.h"
#include "gd32f403_misc.h"
#include "gd32f403_exmc.h"

#endif /* GD32F403_LIBOPT_H */
