/*!
    \file    lcd_driver.h
    \brief   the header file of lcd driver

    \version 2025-01-17, V2.5.0, demo for GD32F3x0
*/

/*
    Copyright (c) 2025, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification, 
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/

#ifndef LCD_DRIVER_H
#define LCD_DRIVER_H

#include <stdlib.h>
#include "gd32f3x0.h"

/* colors */
#define RED             (uint16_t)0xF800U
#define GREEN           (uint16_t)0x07E0U
#define BLUE            (uint16_t)0x001FU
#define WHITE           (uint16_t)0xFFFFU
#define BLACK           (uint16_t)0x0000U
#define YELLOW          (uint16_t)0xFFE0U

/* grays */
#define GRAY0           (uint16_t)0xEF7DU
#define GRAY1           (uint16_t)0x8410U
#define GRAY2           (uint16_t)0x4208U

/* PB0 tft cs */
#define LCD_CS_SET      ((uint32_t)(GPIO_BOP(GPIOB) = GPIO_PIN_0))
#define LCD_CS_CLR      ((uint32_t)(GPIO_BC(GPIOB) = GPIO_PIN_0))

/* PB2 tft rs/dc */
#define LCD_RS_SET      ((uint32_t)(GPIO_BOP(GPIOB) = GPIO_PIN_2))
#define LCD_RS_CLR      ((uint32_t)(GPIO_BC(GPIOB) = GPIO_PIN_2))

/* PB1 tft rst */
#define LCD_RST_SET     ((uint32_t)(GPIO_BOP(GPIOB) = GPIO_PIN_1))
#define LCD_RST_CLR     ((uint32_t)(GPIO_BC(GPIOB) = GPIO_PIN_1))

/* initialize the lcd */
void lcd_init(void);
/* set lcd display region */
void lcd_set_region(uint16_t x_start, uint16_t y_start, uint16_t x_end, uint16_t y_end);
/* set the start display point of lcd */
void lcd_set_xy(uint16_t x, uint16_t y);
/* draw a point on the lcd */
void gui_draw_point(uint16_t x, uint16_t y, uint16_t data);
/* clear the lcd */
void lcd_clear(uint16_t color);

#endif /* LCD_DRIVER_H */
