## Huawei LiteOS简介

华为物联网操作系统Huawei LiteOS是华为面向物联网领域开发的一个基于实时内核的轻量级操作系统。本项目属于华为物联网操作系统[Huawei LiteOS](http://developer.huawei.com/ict/cn/site-iot/product/liteos)基础内核源码，现有代码支持任务调度，内存管理，中断机制，队列管理，事件管理，IPC机制，时间管理，软定时器以及双向链表等常用数据结构。

## LiteOS Git入门必读

- [LiteOS Commit Message规则](./doc/LiteOS_Commit_rules.md)

该文档描述如何提交commit到LiteOS仓库，这是LiteOS开发必须遵守的commit规则，否则提交的commit会被驳回。请点链接了解详细信息。

- [Huawei LiteOS代码贡献流程](./doc/LiteOS_Contribute_Guide.md)

该文档描述开发者如何创建自己的仓库，开发然后贡献代码到LiteOS仓库。请点链接了解详细信息。

## 如何编译LiteOS？

- [Keil 编译](./doc/LiteOS_Compile_Guide.md)

- [IAR 编译](./doc/LiteOS_Compile_Guide.md)

- [GCC 编译](./doc/LiteOS_Compile_Guide.md)



## LiteOS 代码导读

- [LiteOS内核源代码目录说明](./doc/LiteOS_Code_Info.md)

该文档描述的是LiteOS内核源代码的详细信息。通过此文档读者可以了解LiteOS的源代码结构，以及LiteOS的main()函数的功能。


## LiteOS 内核API参考

[LiteOS内核API参考手册](./doc/HuaweiLiteOSKernelDevGuide.md)

该文档详细讲解了LiteOS Kernel所提供的各种API以及其实现原理。用户可以根据该文档学习各种内核API的使用。

## LiteOS 移植指南

- [LiteOS移植指南列表](./doc/LiteOS_Migration_list.md)

本文档中列出了将LiteOS移植到不同的开发板的移植指导文档

## LiteOS Huawei IoT开发指南

* [NB 接入Huawei IoT平台](./doc/LiteOS_NB_Demo.md)

* [AgentTiny 接入Huawei IoT平台](./doc/LiteOS_AgentTiny_Demo.md)


## LiteOS 支持的开发板列表

* [LiteOS 默认支持的开发板](./doc/LiteOS_Supported_board_list.md)

LiteOS目前已经适配了18种开发板，其中包括ST、NXP、MIDMOTION、SILICON、ATMEL、GD等主流厂商的开发板

## 加入我们
* 欢迎提交issue对关心的问题发起讨论
* 欢迎提交PR参与特性建设

## 开源协议
* 遵循BSD-3开源许可协议
